/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.setting;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.SyncBLEViewModel;
import com.brytonsport.active.databinding.ActivitySettingBikeOverviewBinding;
import com.brytonsport.active.ui.setting.Hilt_SettingBikeOverviewActivity;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.vm.base.BikeSetting;
import com.brytonsport.active.vm.setting.SettingBikeOverviewViewModel;
import java.util.Objects;

public class SettingBikeOverviewActivity
extends Hilt_SettingBikeOverviewActivity<ActivitySettingBikeOverviewBinding, SettingBikeOverviewViewModel> {
    public static Intent createIntent(Context context, BikeSetting bikeSetting, int n) {
        return new Intent(context, SettingBikeOverviewActivity.class).putExtra("data", bikeSetting.encode()).putExtra("bike", n);
    }

    @Override
    protected ActivitySettingBikeOverviewBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivitySettingBikeOverviewBinding.inflate(layoutInflater);
    }

    @Override
    protected SettingBikeOverviewViewModel createViewModel() {
        SettingBikeOverviewViewModel settingBikeOverviewViewModel = new ViewModelProvider(this).get(SettingBikeOverviewViewModel.class);
        settingBikeOverviewViewModel.bikeSetting = this.getBikeSettingFromBundle();
        return settingBikeOverviewViewModel;
    }

    public int getBike() {
        return this.getIntent().getIntExtra("bike", 0);
    }

    public BikeSetting getBikeSettingFromBundle() {
        return new BikeSetting(this.getIntent().getStringExtra("data"));
    }

    @Override
    protected void initColor() {
        ((ActivitySettingBikeOverviewBinding)this.binding).getRoot().setBackgroundResource(2131034148);
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        App.put("Trip 1", String.format(i18N.get("BikeODO"), 1));
        App.put("Trip 2", String.format(i18N.get("BikeODO"), 2));
        App.put("Ride Time", i18N.get("RideTime"));
        App.put("Alt. Gain", i18N.get("AltGain"));
        App.put("Alt. Loss", i18N.get("AltLoss"));
        this.setTitle(i18N.get("Overview"));
        Object object = ((ActivitySettingBikeOverviewBinding)this.binding).trip1Item.titleText;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(i18N.get("BikeODO"));
        stringBuilder.append("1");
        object.setText((CharSequence)stringBuilder.toString());
        ((ActivitySettingBikeOverviewBinding)this.binding).trip1Item.editText.setText((CharSequence)((SettingBikeOverviewViewModel)this.viewModel).mRideTrip1.getValue());
        ((ActivitySettingBikeOverviewBinding)this.binding).trip1Item.editText.setInputType(2);
        ((ActivitySettingBikeOverviewBinding)this.binding).trip1Item.editText.setSelectAllOnFocus(true);
        ((ActivitySettingBikeOverviewBinding)this.binding).trip1Item.editText.setHint((CharSequence)"");
        ((ActivitySettingBikeOverviewBinding)this.binding).trip1Item.unitText.setVisibility(0);
        ((ActivitySettingBikeOverviewBinding)this.binding).trip1Item.unitText.setText((CharSequence)Utils.getUnitByKM());
        ((ActivitySettingBikeOverviewBinding)this.binding).trip1Item.divider.setVisibility(0);
        stringBuilder = ((ActivitySettingBikeOverviewBinding)this.binding).trip2Item.titleText;
        object = new StringBuilder();
        ((StringBuilder)object).append(i18N.get("BikeODO"));
        ((StringBuilder)object).append("2");
        stringBuilder.setText(((StringBuilder)object).toString());
        ((ActivitySettingBikeOverviewBinding)this.binding).trip2Item.editText.setText((CharSequence)((SettingBikeOverviewViewModel)this.viewModel).mRideTrip2.getValue());
        ((ActivitySettingBikeOverviewBinding)this.binding).trip2Item.editText.setInputType(2);
        ((ActivitySettingBikeOverviewBinding)this.binding).trip2Item.editText.setSelectAllOnFocus(true);
        ((ActivitySettingBikeOverviewBinding)this.binding).trip2Item.editText.setHint((CharSequence)"");
        ((ActivitySettingBikeOverviewBinding)this.binding).trip2Item.unitText.setVisibility(0);
        ((ActivitySettingBikeOverviewBinding)this.binding).trip2Item.unitText.setText((CharSequence)Utils.getUnitByKM());
        ((ActivitySettingBikeOverviewBinding)this.binding).trip2Item.divider.setVisibility(0);
        ((ActivitySettingBikeOverviewBinding)this.binding).rideTimeItem.titleText.setText((CharSequence)App.get("Ride Time"));
        ((ActivitySettingBikeOverviewBinding)this.binding).rideTimeItem.editText.setText((CharSequence)((SettingBikeOverviewViewModel)this.viewModel).mRideTime.getValue());
        ((ActivitySettingBikeOverviewBinding)this.binding).rideTimeItem.editText.setInputType(2);
        ((ActivitySettingBikeOverviewBinding)this.binding).rideTimeItem.editText.setSelectAllOnFocus(true);
        ((ActivitySettingBikeOverviewBinding)this.binding).rideTimeItem.editText.setHint((CharSequence)"");
        ((ActivitySettingBikeOverviewBinding)this.binding).rideTimeItem.unitText.setVisibility(0);
        ((ActivitySettingBikeOverviewBinding)this.binding).rideTimeItem.unitText.setText((CharSequence)i18N.get("Hours"));
        ((ActivitySettingBikeOverviewBinding)this.binding).rideTimeItem.divider.setVisibility(0);
        ((ActivitySettingBikeOverviewBinding)this.binding).altGainItem.titleText.setText((CharSequence)App.get("Alt. Gain"));
        ((ActivitySettingBikeOverviewBinding)this.binding).altGainItem.editText.setText((CharSequence)((SettingBikeOverviewViewModel)this.viewModel).mRideAltGain.getValue());
        ((ActivitySettingBikeOverviewBinding)this.binding).altGainItem.editText.setInputType(2);
        ((ActivitySettingBikeOverviewBinding)this.binding).altGainItem.editText.setSelectAllOnFocus(true);
        ((ActivitySettingBikeOverviewBinding)this.binding).altGainItem.editText.setHint((CharSequence)"");
        ((ActivitySettingBikeOverviewBinding)this.binding).altGainItem.unitText.setVisibility(0);
        ((ActivitySettingBikeOverviewBinding)this.binding).altGainItem.unitText.setText((CharSequence)Utils.getUnitByM());
        ((ActivitySettingBikeOverviewBinding)this.binding).altGainItem.divider.setVisibility(0);
        ((ActivitySettingBikeOverviewBinding)this.binding).altLossItem.titleText.setText((CharSequence)App.get("Alt. Loss"));
        ((ActivitySettingBikeOverviewBinding)this.binding).altLossItem.editText.setText((CharSequence)((SettingBikeOverviewViewModel)this.viewModel).mRideAltLoss.getValue());
        ((ActivitySettingBikeOverviewBinding)this.binding).altLossItem.editText.setInputType(2);
        ((ActivitySettingBikeOverviewBinding)this.binding).altLossItem.editText.setSelectAllOnFocus(true);
        ((ActivitySettingBikeOverviewBinding)this.binding).altLossItem.editText.setHint((CharSequence)"");
        ((ActivitySettingBikeOverviewBinding)this.binding).altLossItem.unitText.setVisibility(0);
        ((ActivitySettingBikeOverviewBinding)this.binding).altLossItem.unitText.setText((CharSequence)Utils.getUnitByM());
        ((ActivitySettingBikeOverviewBinding)this.binding).altLossItem.divider.setVisibility(0);
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.bindRideTrip1(((ActivitySettingBikeOverviewBinding)this.binding).trip1Item.editText, ((ActivitySettingBikeOverviewBinding)this.binding).trip1Item.unitText, ((SettingBikeOverviewViewModel)this.viewModel).bikeSetting.bikeNum);
        this.bindRideTrip2(((ActivitySettingBikeOverviewBinding)this.binding).trip2Item.editText, ((ActivitySettingBikeOverviewBinding)this.binding).trip2Item.unitText, ((SettingBikeOverviewViewModel)this.viewModel).bikeSetting.bikeNum);
        this.bindRideTime(((ActivitySettingBikeOverviewBinding)this.binding).rideTimeItem.editText, ((ActivitySettingBikeOverviewBinding)this.binding).rideTimeItem.unitText, ((SettingBikeOverviewViewModel)this.viewModel).bikeSetting.bikeNum);
        this.bindRideAltGain(((ActivitySettingBikeOverviewBinding)this.binding).altGainItem.editText, ((ActivitySettingBikeOverviewBinding)this.binding).altGainItem.unitText, ((SettingBikeOverviewViewModel)this.viewModel).bikeSetting.bikeNum);
        this.bindRideAltLoss(((ActivitySettingBikeOverviewBinding)this.binding).altLossItem.editText, ((ActivitySettingBikeOverviewBinding)this.binding).altLossItem.unitText, ((SettingBikeOverviewViewModel)this.viewModel).bikeSetting.bikeNum);
        SettingBikeOverviewViewModel settingBikeOverviewViewModel = (SettingBikeOverviewViewModel)this.viewModel;
        SettingBikeOverviewViewModel settingBikeOverviewViewModel2 = (SettingBikeOverviewViewModel)this.viewModel;
        Objects.requireNonNull((SettingBikeOverviewViewModel)this.viewModel);
        settingBikeOverviewViewModel.addReq(settingBikeOverviewViewModel2.getBaseCmdJsonArray(42, 0, ((SettingBikeOverviewViewModel)this.viewModel).bikeSetting.bikeNum));
        settingBikeOverviewViewModel = (SettingBikeOverviewViewModel)this.viewModel;
        settingBikeOverviewViewModel2 = (SettingBikeOverviewViewModel)this.viewModel;
        Objects.requireNonNull((SettingBikeOverviewViewModel)this.viewModel);
        Objects.requireNonNull((SettingBikeOverviewViewModel)this.viewModel);
        settingBikeOverviewViewModel.addReq(settingBikeOverviewViewModel2.getBaseCmdJsonArray(48, 0, new SyncBLEViewModel.BikeCmdExtra(0, ((SettingBikeOverviewViewModel)this.viewModel).bikeSetting.bikeNum)));
        settingBikeOverviewViewModel = (SettingBikeOverviewViewModel)this.viewModel;
        settingBikeOverviewViewModel2 = (SettingBikeOverviewViewModel)this.viewModel;
        Objects.requireNonNull((SettingBikeOverviewViewModel)this.viewModel);
        Objects.requireNonNull((SettingBikeOverviewViewModel)this.viewModel);
        settingBikeOverviewViewModel.addReq(settingBikeOverviewViewModel2.getBaseCmdJsonArray(48, 0, new SyncBLEViewModel.BikeCmdExtra(1, ((SettingBikeOverviewViewModel)this.viewModel).bikeSetting.bikeNum)));
        settingBikeOverviewViewModel = (SettingBikeOverviewViewModel)this.viewModel;
        settingBikeOverviewViewModel2 = (SettingBikeOverviewViewModel)this.viewModel;
        Objects.requireNonNull((SettingBikeOverviewViewModel)this.viewModel);
        Objects.requireNonNull((SettingBikeOverviewViewModel)this.viewModel);
        settingBikeOverviewViewModel.addReq(settingBikeOverviewViewModel2.getBaseCmdJsonArray(48, 0, new SyncBLEViewModel.BikeCmdExtra(2, ((SettingBikeOverviewViewModel)this.viewModel).bikeSetting.bikeNum)));
        ((SettingBikeOverviewViewModel)this.viewModel).startSyncSettings();
    }

    @Override
    protected void setListeners() {
    }
}

