/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.setting;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.databinding.ActivitySettingLanguageBinding;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.ui.setting.Hilt_SettingLanguageActivity;
import com.brytonsport.active.ui.setting.SettingLanguageActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.setting.adapter.SettingLanguageAdapter;
import com.brytonsport.active.utils.DeviceBusyStatusUtil;
import com.brytonsport.active.utils.SettingLanguageUtil;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.ConfirmDialog;
import com.brytonsport.active.views.layoutmanager.AdvancedLinearLayoutManager;
import com.brytonsport.active.vm.setting.SettingLanguageViewModel;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SettingLanguageActivity
extends Hilt_SettingLanguageActivity<ActivitySettingLanguageBinding, SettingLanguageViewModel> {
    private SettingLanguageAdapter settingLanguageAdapter;

    private void changePageTitle() {
        if (this.getPageFromBundle().equals("device_language")) {
            this.setTitle(i18N.get("DeviceLanguage"));
        } else if (this.getPageFromBundle().equals("voice_language")) {
            this.setTitle(i18N.get("VoiceLanguage"));
        } else {
            this.setTitle(i18N.get("Language"));
        }
    }

    public static Intent createIntent(Context context, String string2) {
        return new Intent(context, SettingLanguageActivity.class).putExtra("languagePageFrom", string2);
    }

    public static Intent createIntent(Context context, String string2, String string3) {
        return new Intent(context, SettingLanguageActivity.class).putExtra("languagePageFrom", string2).putExtra("model", string3);
    }

    public static Intent createIntent(Context context, String string2, String string3, String string4, String string5) {
        return new Intent(context, SettingLanguageActivity.class).putExtra("languagePageFrom", string2).putExtra("model", string3).putExtra("lang_ver", string4).putExtra("cur_lang", string5);
    }

    private String getCurrentLangFromBundle() {
        return this.getIntent().getStringExtra("cur_lang");
    }

    private String getLangPackVerFromBundle() {
        return this.getIntent().getStringExtra("lang_ver");
    }

    private String getModelNameFromBundle() {
        return this.getIntent().getStringExtra("model");
    }

    private String getPageFromBundle() {
        return this.getIntent().getStringExtra("languagePageFrom");
    }

    private void observeViewModel() {
        ((SettingLanguageViewModel)this.viewModel).loadDeviceIsChoiceAndConnected().observe(this, new Observer<DeviceManagerEntity>(){

            @Override
            public void onChanged(DeviceManagerEntity object) {
                if (object != null) {
                    object = ((DeviceManagerEntity)object).getDevName();
                    ((SettingLanguageViewModel)SettingLanguageActivity.this.viewModel).loadLanguageListFromPageType(SettingLanguageActivity.this.getPageFromBundle(), (String)object);
                }
            }
        });
    }

    private void syncVoiceLang(String string2) {
        if (this.getPageFromBundle().equals("app_language")) {
            ((SettingLanguageViewModel)this.viewModel).getSptGoogleLangList();
            string2 = SettingLanguageUtil.getAppMappingDefaultVoiceLang(SettingLanguageUtil.appLangMap.get(string2), "text");
            ((SettingLanguageViewModel)this.viewModel).choiceVoiceLanguage(string2);
        }
    }

    @Override
    protected ActivitySettingLanguageBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivitySettingLanguageBinding.inflate(layoutInflater);
    }

    @Override
    protected SettingLanguageViewModel createViewModel() {
        return new ViewModelProvider(this).get(SettingLanguageViewModel.class);
    }

    public ArrayList<String> get320SupportLangs() {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = this.getModelNameFromBundle();
        String[] stringArray = this.loadSptLangList(string3, string2 = this.getLangPackVerFromBundle());
        if (stringArray != null && !stringArray.isEmpty()) {
            stringArray = stringArray.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.isSptLangPackReady(string3, string2, stringArray[i])) continue;
                arrayList.add(SettingLanguageUtil.getRider320LangKeyByServerStr(stringArray[i]));
            }
        }
        return arrayList;
    }

    @Override
    protected void initColor() {
        ((ActivitySettingLanguageBinding)this.binding).getRoot().setBackgroundResource(2131034148);
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        this.setTitle(i18N.get("Language"));
    }

    public /* synthetic */ void lambda$setListeners$0$com-brytonsport-active-ui-setting-SettingLanguageActivity(String string2) {
        if (this.getPageFromBundle().equals("device_language")) {
            Object object;
            String string3 = this.getModelNameFromBundle();
            if (string3 != null && string3.equalsIgnoreCase("rider320")) {
                object = DeviceBusyStatusUtil.getNowDeviceStatus();
                if (object.equals((Object)DeviceBusyStatusUtil.DeviceStatus.SyncActivity)) {
                    ConfirmDialog.showSelfSingle(this.activity, i18N.get("M_ReadDevice"), i18N.get("B_OK"));
                    return;
                }
                if (object.equals((Object)DeviceBusyStatusUtil.DeviceStatus.RunningGroupRide)) {
                    ConfirmDialog.showSelfSingle(this.activity, i18N.get("StopGRFrist"), i18N.get("B_OK"));
                    return;
                }
                if (object.equals((Object)DeviceBusyStatusUtil.DeviceStatus.SendServerEeToDev)) {
                    ConfirmDialog.showSelfSingle(this.activity, i18N.get("M_DeviceBusy"), i18N.get("B_OK"));
                    return;
                }
            }
            ((SettingLanguageViewModel)this.viewModel).mSelectedLanguage = string2;
            ((SettingLanguageViewModel)this.viewModel).choiceLanguageItemFromPageType(this.getPageFromBundle(), string2);
            this.settingLanguageAdapter.setmSelectedLanguage(((SettingLanguageViewModel)this.viewModel).mSelectedLanguage);
            if (string3 != null && string3.equalsIgnoreCase("rider320")) {
                String string4 = this.getLangPackVerFromBundle();
                String[] stringArray = this.loadSptLangArrays(string3, string4);
                if (stringArray != null) {
                    Object var6_6 = null;
                    int n = 0;
                    while (true) {
                        object = var6_6;
                        if (n >= stringArray.length) break;
                        if (string2.equals(SettingLanguageUtil.getRider320LangKeyByServerStr(stringArray[n]))) {
                            object = stringArray[n];
                            break;
                        }
                        ++n;
                    }
                    this.sync320DeviceLang(this.loadSptLangPack(string3, string4, (String)object));
                } else {
                    Log.e((String)"ActivityBase", (String)"Could not get 320 support language keys");
                }
            } else {
                this.syncDeviceLang(SettingLanguageUtil.deviceLangMap.getMap().get(string2));
            }
        } else {
            ((SettingLanguageViewModel)this.viewModel).choiceLanguageItemFromPageType(this.getPageFromBundle(), string2);
            this.syncVoiceLang(string2);
            this.setResult(-1, new Intent().putExtra("key", string2).putExtra("serverStr", SettingLanguageUtil.deviceLangMap.getMap().get(string2)));
            this.finish();
        }
    }

    @Override
    public void onBackPressed() {
        if (this.getPageFromBundle().equals("device_language")) {
            ((SettingLanguageViewModel)this.viewModel).choiceLanguageItemFromPageType(this.getPageFromBundle(), ((SettingLanguageViewModel)this.viewModel).mSelectedLanguage);
            this.setResult(-1, new Intent().putExtra("key", ((SettingLanguageViewModel)this.viewModel).mSelectedLanguage).putExtra("serverStr", SettingLanguageUtil.deviceLangMap.getMap().get(((SettingLanguageViewModel)this.viewModel).mSelectedLanguage)).putExtra("device_reboot", ((SettingLanguageViewModel)this.viewModel).mIsDeviceReboot));
            this.finish();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        ((SettingLanguageViewModel)this.viewModel).mSelectedLanguage = this.getCurrentLangFromBundle();
        ((ActivitySettingLanguageBinding)this.binding).languageList.setLayoutManager(new AdvancedLinearLayoutManager((Context)this));
        this.settingLanguageAdapter = new SettingLanguageAdapter(this, ((SettingLanguageViewModel)this.viewModel).languages, this.getPageFromBundle(), ((SettingLanguageViewModel)this.viewModel).mSelectedLanguage);
        ((ActivitySettingLanguageBinding)this.binding).languageList.setAdapter(this.settingLanguageAdapter);
        this.changePageTitle();
        if (this.getPageFromBundle().equals("device_language")) {
            String string2 = this.getModelNameFromBundle();
            if (string2 != null && !string2.isEmpty()) {
                if (string2.equalsIgnoreCase("rider320")) {
                    ((SettingLanguageViewModel)this.viewModel).languages.addAll(this.get320SupportLangs());
                    ((SettingLanguageViewModel)this.viewModel).mFWDeviceLangPosted.observe(this, new Observer<Integer>(){

                        @Override
                        public void onChanged(Integer n) {
                            if (n > 0) {
                                SettingLanguageActivity.this.tellFWDeviceLangFileSize(n);
                            } else {
                                Log.e((String)"ActivityBase", (String)"Get strange post size");
                            }
                        }
                    });
                    ((SettingLanguageViewModel)this.viewModel).mIsPackageInfoUpdated.observe(this, new Observer<Boolean>(){

                        @Override
                        public void onChanged(Boolean bl) {
                            if (bl.booleanValue()) {
                                SettingLanguageActivity.this.askDeviceRebootToUpdate();
                            } else {
                                Log.e((String)"ActivityBase", (String)"Failed to update device lang");
                            }
                        }
                    });
                    ((SettingLanguageViewModel)this.viewModel).mExtraCmdRun.observe(this, new Observer<Integer>(){

                        @Override
                        public void onChanged(Integer n) {
                            if (n == -1) {
                                ((SettingLanguageViewModel)SettingLanguageActivity.this.viewModel).mIsLoading.setValue(false);
                                ((SettingLanguageViewModel)SettingLanguageActivity.this.viewModel).mIsDeviceReboot = true;
                                SettingLanguageActivity.this.onBackPressed();
                            }
                        }
                    });
                } else {
                    ((SettingLanguageViewModel)this.viewModel).loadLanguageListFromPageType(this.getPageFromBundle(), string2);
                }
            } else {
                this.observeViewModel();
            }
        } else {
            ((SettingLanguageViewModel)this.viewModel).loadLanguageListFromPageType(this.getPageFromBundle(), null);
        }
    }

    @Override
    protected void setListeners() {
        this.settingLanguageAdapter.setOnLanguageClickListener(new SettingLanguageActivity$$ExternalSyntheticLambda0(this));
    }

    protected void sync320DeviceLang(String string2) {
        ((SettingLanguageViewModel)this.viewModel).post320DeviceLanguage(string2);
    }
}

