/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.setting;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.ActivityCourseSearchBinding;
import com.brytonsport.active.db.course.entity.CourseSearchHistoryEntity;
import com.brytonsport.active.ui.course.adapter.SearchResultAdapter;
import com.brytonsport.active.ui.setting.Hilt_SettingMarkSearchActivity;
import com.brytonsport.active.ui.setting.SettingMarkSearchActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.setting.SettingMarkSearchActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.setting.SettingMarkSearchActivity$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.setting.SettingMarkSearchActivity$$ExternalSyntheticLambda3;
import com.brytonsport.active.ui.setting.SettingMarkSearchActivity$$ExternalSyntheticLambda4;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.views.layoutmanager.AdvancedLinearLayoutManager;
import com.brytonsport.active.vm.base.SearchResult;
import com.brytonsport.active.vm.course.CourseSearchViewModel;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SettingMarkSearchActivity
extends Hilt_SettingMarkSearchActivity<ActivityCourseSearchBinding, CourseSearchViewModel> {
    private double nowLat;
    private double nowLng;
    private SearchResultAdapter resultAdapter;

    private void animateSearchLayout(int n) {
        int n2 = ((ViewGroup.MarginLayoutParams)((ActivityCourseSearchBinding)this.binding).searchLayout.getLayoutParams()).topMargin;
        if (n2 <= 0) {
            ((ViewGroup.MarginLayoutParams)((ActivityCourseSearchBinding)this.binding).searchLayout.getLayoutParams()).topMargin = 0;
            ((ActivityCourseSearchBinding)this.binding).searchLayout.requestLayout();
            return;
        }
        ((ViewGroup.MarginLayoutParams)((ActivityCourseSearchBinding)this.binding).searchLayout.getLayoutParams()).topMargin = n2 - n;
        ((ActivityCourseSearchBinding)this.binding).searchLayout.requestLayout();
        this.postDelayed(new SettingMarkSearchActivity$$ExternalSyntheticLambda4(this, n), 10L);
    }

    public static Intent createIntent(Context context) {
        return new Intent(context, SettingMarkSearchActivity.class);
    }

    public static Intent createIntent(Context context, double d, double d2) {
        return new Intent(context, SettingMarkSearchActivity.class).putExtra("nowLat", d).putExtra("nowLng", d2);
    }

    private void observeViewModel() {
        ((CourseSearchViewModel)this.viewModel).getSearchPoiListLiveData().observe(this, new Observer<JSONObject>(){

            @Override
            public void onChanged(JSONObject jSONObject) {
                if (jSONObject.has("data")) {
                    JSONArray jSONArray = new JSONArray();
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("type", 0);
                    jSONObject2.put("icon", 2131165558);
                    jSONObject2.put("text", (Object)"Relevants");
                    jSONArray.put((Object)jSONObject2);
                    jSONObject2 = jSONObject.getJSONArray("data");
                    for (int i = 0; i < jSONObject2.length(); ++i) {
                        JSONObject jSONObject3 = jSONObject2.getJSONObject(i);
                        JSONObject jSONObject4 = jSONObject3.getJSONObject("latlng");
                        jSONObject = new JSONObject();
                        jSONObject.put("type", 2);
                        jSONObject.put("text", (Object)jSONObject3.getString("name"));
                        jSONObject.put("address", (Object)jSONObject3.getString("vicinity"));
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(Utils.convertKM((float)DistanceUtil.distanceMeteor2Km(jSONObject3.getDouble("distance"))));
                        stringBuilder.append(" ");
                        stringBuilder.append(Utils.getUnitByKM());
                        jSONObject.put("distance", (Object)stringBuilder.toString());
                        jSONObject.put("lat", jSONObject4.getDouble("lat"));
                        jSONObject.put("lng", jSONObject4.getDouble("lng"));
                        jSONArray.put((Object)jSONObject);
                    }
                    try {
                        jSONObject = new JSONObject();
                        jSONObject.put("searches", (Object)jSONArray);
                        ((CourseSearchViewModel)SettingMarkSearchActivity.this.viewModel).updateSearchResult(jSONObject.toString());
                        SettingMarkSearchActivity.this.resultAdapter.swapItems(((CourseSearchViewModel)SettingMarkSearchActivity.this.viewModel).getSearchResults(""));
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            }
        });
        ((CourseSearchViewModel)this.viewModel).loadSearchHistoryListLive().observe(this, new Observer<List<CourseSearchHistoryEntity>>(){

            @Override
            public void onChanged(List<CourseSearchHistoryEntity> jSONObject) {
                if (jSONObject.size() > 0) {
                    JSONArray jSONArray = new JSONArray();
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("type", 0);
                    jSONObject2.put("icon", 2131165511);
                    jSONObject2.put("text", (Object)"Recents");
                    jSONArray.put((Object)jSONObject2);
                    for (int i = 0; i < jSONObject.size(); ++i) {
                        CourseSearchHistoryEntity courseSearchHistoryEntity = jSONObject.get(i);
                        jSONObject2 = new JSONObject();
                        jSONObject2.put("type", 1);
                        jSONObject2.put("text", (Object)courseSearchHistoryEntity.getContent());
                        jSONArray.put((Object)jSONObject2);
                    }
                    try {
                        jSONObject = new JSONObject();
                        jSONObject.put("defaults", (Object)jSONArray);
                        ((CourseSearchViewModel)SettingMarkSearchActivity.this.viewModel).updateSearchResult(jSONObject.toString());
                        SettingMarkSearchActivity.this.resultAdapter.swapItems(((CourseSearchViewModel)SettingMarkSearchActivity.this.viewModel).getDefaultResults());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            }
        });
    }

    private void startSearchLayoutAnimation() {
        this.post(new SettingMarkSearchActivity$$ExternalSyntheticLambda3(this));
    }

    @Override
    protected ActivityCourseSearchBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityCourseSearchBinding.inflate(layoutInflater);
    }

    @Override
    protected CourseSearchViewModel createViewModel() {
        return new ViewModelProvider(this).get(CourseSearchViewModel.class);
    }

    @Override
    protected void initColor() {
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        App.put("Where to?", "Where to?");
        App.put("Cancel", "Cancel");
        this.setActionbarVisibility(8);
        ((ActivityCourseSearchBinding)this.binding).searchEdit.setHint((CharSequence)App.get("Where to?"));
        ((ActivityCourseSearchBinding)this.binding).searchEdit.setFocusable(true);
        ((ActivityCourseSearchBinding)this.binding).searchEdit.requestFocus();
        ((ActivityCourseSearchBinding)this.binding).cancelText.setText((CharSequence)App.get("Cancel"));
    }

    public /* synthetic */ void lambda$animateSearchLayout$4$com-brytonsport-active-ui-setting-SettingMarkSearchActivity(int n) {
        this.animateSearchLayout(n);
    }

    public /* synthetic */ void lambda$setListeners$0$com-brytonsport-active-ui-setting-SettingMarkSearchActivity(View view) {
        this.finish();
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-setting-SettingMarkSearchActivity(View view) {
        ((ActivityCourseSearchBinding)this.binding).clearImage.setVisibility(8);
        ((ActivityCourseSearchBinding)this.binding).searchEdit.setText((CharSequence)"");
    }

    public /* synthetic */ void lambda$setListeners$2$com-brytonsport-active-ui-setting-SettingMarkSearchActivity(SearchResult searchResult) {
        if (searchResult.type == 1) {
            ((ActivityCourseSearchBinding)this.binding).searchEdit.setText((CharSequence)searchResult.text);
        } else if (searchResult.type == 2) {
            this.setResult(-1, new Intent().putExtra("data", searchResult.encode()));
            this.finish();
        }
    }

    public /* synthetic */ void lambda$startSearchLayoutAnimation$3$com-brytonsport-active-ui-setting-SettingMarkSearchActivity() {
        this.animateSearchLayout(((ViewGroup.MarginLayoutParams)((ActivityCourseSearchBinding)this.binding).searchLayout.getLayoutParams()).topMargin / 20);
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.startSearchLayoutAnimation();
        ((ActivityCourseSearchBinding)this.binding).searchList.setLayoutManager(new AdvancedLinearLayoutManager((Context)this));
        this.resultAdapter = new SearchResultAdapter((Activity)this, ((CourseSearchViewModel)this.viewModel).getDefaultResults());
        ((ActivityCourseSearchBinding)this.binding).searchList.setAdapter(this.resultAdapter);
        this.nowLat = this.getIntent().getDoubleExtra("nowLat", 0.0);
        this.nowLng = this.getIntent().getDoubleExtra("nowLng", 0.0);
        this.observeViewModel();
    }

    @Override
    protected void setListeners() {
        ((ActivityCourseSearchBinding)this.binding).cancelText.setOnClickListener((View.OnClickListener)new SettingMarkSearchActivity$$ExternalSyntheticLambda0(this));
        ((ActivityCourseSearchBinding)this.binding).clearImage.setOnClickListener((View.OnClickListener)new SettingMarkSearchActivity$$ExternalSyntheticLambda1(this));
        ((ActivityCourseSearchBinding)this.binding).searchEdit.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable object) {
                object = object.toString();
                ImageView imageView = ((ActivityCourseSearchBinding)SettingMarkSearchActivity.this.binding).clearImage;
                int n = TextUtils.isEmpty((CharSequence)object) ? 8 : 0;
                imageView.setVisibility(n);
                if (SettingMarkSearchActivity.this.nowLat != 0.0 && SettingMarkSearchActivity.this.nowLng != 0.0) {
                    ((CourseSearchViewModel)SettingMarkSearchActivity.this.viewModel).searchPoiUseTextSearch(SettingMarkSearchActivity.this.nowLat, SettingMarkSearchActivity.this.nowLng, (String)object);
                    ((CourseSearchViewModel)SettingMarkSearchActivity.this.viewModel).addNewSearchHistory((String)object);
                }
                if (TextUtils.isEmpty((CharSequence)object)) {
                    ((ActivityCourseSearchBinding)SettingMarkSearchActivity.this.binding).clearImage.setVisibility(8);
                    SettingMarkSearchActivity.this.resultAdapter.swapItems(((CourseSearchViewModel)SettingMarkSearchActivity.this.viewModel).getDefaultResults());
                } else {
                    ((ActivityCourseSearchBinding)SettingMarkSearchActivity.this.binding).clearImage.setVisibility(0);
                    SettingMarkSearchActivity.this.resultAdapter.swapItems(((CourseSearchViewModel)SettingMarkSearchActivity.this.viewModel).getSearchResults((String)object));
                }
            }

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }
        });
        this.resultAdapter.setOnResultItemClickListener(new SettingMarkSearchActivity$$ExternalSyntheticLambda2(this));
    }
}

