/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.setting.adapter.item;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import com.brytonsport.active.databinding.ItemSettingHeaderBinding;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.vm.base.Device;
import com.brytonsport.active.vm.base.Profile;
import com.james.views.FreeLayout;

public class SettingHeaderItem
extends FreeLayout {
    private RotateAnimation animation;
    public ItemSettingHeaderBinding binding;
    private Device device;
    private boolean isLoading = false;
    private Profile profile;

    public SettingHeaderItem(Context context) {
        super(context);
        this.init(context);
    }

    public SettingHeaderItem(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public SettingHeaderItem(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void init(Context object) {
        RotateAnimation rotateAnimation;
        this.animation = rotateAnimation = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        rotateAnimation.setRepeatCount(-1);
        this.animation.setDuration(2250L);
        this.animation.setInterpolator((Interpolator)new LinearInterpolator());
        object = ItemSettingHeaderBinding.inflate(LayoutInflater.from((Context)object));
        this.binding = object;
        this.addFreeView((View)((ItemSettingHeaderBinding)object).getRoot(), -1, -2);
        this.binding.uuidTitle.setText((CharSequence)i18N.get("UUID"));
        this.binding.firmwareTitle.setText((CharSequence)i18N.get("FirmwareVersion"));
        this.binding.bluetoothText.setText((CharSequence)i18N.get("B_BTnotconnect"));
    }

    public void setBatteryIcon(int n) {
        ImageView imageView = this.binding.batteryIcon;
        Device device = this.device;
        int n2 = device != null && device.isConnected && n != 0 ? 0 : 8;
        imageView.setVisibility(n2);
        this.binding.batteryIcon.setImageResource(n);
    }

    public void setBluetoothOpen(boolean bl) {
        if (!bl) {
            this.binding.bluetoothLayout.setVisibility(0);
        } else {
            this.binding.bluetoothLayout.setVisibility(8);
        }
    }

    public void setDevice(Device object) {
        this.device = object;
        this.binding.noDeviceLayout.setVisibility(8);
        this.binding.deviceLayout.setVisibility(0);
        int n = 2131165941;
        if (object == null) {
            this.binding.mobileImage.setImageResource(2131165941);
            this.binding.deviceNameText.setText((CharSequence)"");
            this.binding.uuidText.setText((CharSequence)"");
            this.binding.firmwareText.setText((CharSequence)"");
            this.binding.batteryIcon.setVisibility(8);
            return;
        }
        ImageView imageView = this.binding.mobileImage;
        if (((Device)object).isConnected) {
            n = ((Device)object).deviceImage;
        }
        imageView.setImageResource(n);
        this.binding.deviceNameText.setText((CharSequence)((Device)object).deviceName);
        this.binding.uuidTitle.setText((CharSequence)i18N.get("UUID"));
        this.binding.uuidText.setText((CharSequence)((Device)object).uuid);
        this.binding.firmwareTitle.setText((CharSequence)i18N.get("FirmwareVersion"));
        imageView = this.binding.firmwareText;
        object = ((Device)object).isConnected ? ((Device)object).firmware : i18N.get("M_NoConnectedDev");
        imageView.setText((CharSequence)object);
    }

    public void setLoading(boolean bl) {
        this.isLoading = bl;
        if (bl) {
            this.binding.loadingImage.setVisibility(0);
            this.binding.loadingImage.startAnimation((Animation)this.animation);
        } else {
            this.binding.loadingImage.setVisibility(4);
            this.binding.loadingImage.clearAnimation();
        }
    }

    public void showCaption() {
        this.binding.mobileImage.setImageResource(2131165646);
        this.binding.deviceLayout.setVisibility(8);
        this.binding.noDeviceLayout.setVisibility(0);
        this.binding.noDeviceText.setText((CharSequence)i18N.get("M_AddUuidNote"));
    }
}

