/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.setting.adapter.item;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.TextView;
import com.brytonsport.active.databinding.ItemSettingSensorBinding;
import com.brytonsport.active.vm.base.Sensor;
import com.brytonsport.active.vm.base.SensorType;
import com.james.views.FreeLayout;

public class SettingSensorItem
extends FreeLayout {
    private Animation animation;
    public ItemSettingSensorBinding binding;

    public SettingSensorItem(Context context) {
        super(context);
        this.init(context);
    }

    public SettingSensorItem(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public SettingSensorItem(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void init(Context object) {
        object = ItemSettingSensorBinding.inflate(LayoutInflater.from((Context)object));
        this.binding = object;
        this.addFreeView((View)((ItemSettingSensorBinding)object).getRoot(), -1, -2);
        object = new AlphaAnimation(0.0f, 1.0f);
        this.animation = object;
        object.setDuration(500L);
        this.animation.setRepeatCount(-1);
        this.animation.setRepeatMode(2);
    }

    public SettingSensorItem setSensor(Sensor sensor) {
        this.binding.nameText.setText((CharSequence)sensor.name);
        TextView textView = this.binding.typeIdText;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = sensor.hwType == 0 ? "ANT+ " : "Bluetooth+ ";
        stringBuilder.append(string2);
        stringBuilder.append(sensor.id);
        textView.setText((CharSequence)stringBuilder.toString());
        if (sensor.status.equalsIgnoreCase("connecting")) {
            this.binding.sensorIcon.startAnimation(this.animation);
            this.binding.sensorIcon.setImageResource(SensorType.getSensorIconByType(sensor.type));
        } else if (sensor.status.equalsIgnoreCase("unconnected")) {
            this.binding.sensorIcon.clearAnimation();
            this.binding.sensorIcon.setImageResource(SensorType.getSensorOffIconByType(sensor.type));
        } else {
            this.binding.sensorIcon.clearAnimation();
            this.binding.sensorIcon.setImageResource(SensorType.getSensorIconByType(sensor.type));
        }
        return this;
    }
}

