/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.setting.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

public class CircleProgressView
extends View {
    private float endInner = 250.0f;
    private float endOuter = 120.0f;
    private int innerColor = -16723133;
    private int outerColor = -1657300;
    private Paint paint;
    private RectF rectF;
    private float startInner = 0.0f;
    private float startOuter = 0.0f;

    public CircleProgressView(Context context) {
        super(context);
        this.init(context);
    }

    public CircleProgressView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public CircleProgressView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void init(Context context) {
        this.paint = new Paint();
        this.rectF = new RectF();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n != 0 && n2 != 0) {
            float f;
            float f2 = (float)(n * 6) / 150.0f;
            float f3 = (float)(n * 30) / 150.0f;
            float f4 = this.startInner;
            int n3 = (int)f4 - 90;
            int n4 = (int)this.endInner;
            int n5 = (int)(f4 + 360.0f);
            this.paint.reset();
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setStrokeWidth(f3 / 2.0f);
            RectF rectF = this.rectF;
            rectF.left = f = 7.0f * f2 / 2.0f;
            this.rectF.top = f;
            rectF = this.rectF;
            f3 = n;
            rectF.right = f3 - f;
            rectF = this.rectF;
            f4 = n2;
            rectF.bottom = f4 - f;
            this.paint.setColor(-14275008);
            rectF = this.rectF;
            f = n3;
            canvas.drawArc(rectF, f, (float)(n5 - 90 - n3), false, this.paint);
            this.paint.setColor(this.innerColor);
            canvas.drawArc(this.rectF, f, (float)(n4 - 90 - n3), false, this.paint);
            f = this.startOuter;
            n4 = (int)f - 90;
            n = (int)this.endOuter;
            n2 = (int)(f + 360.0f);
            this.paint.reset();
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setStrokeWidth(f2 / 2.0f);
            this.rectF.left = f2;
            this.rectF.top = f2;
            this.rectF.right = f3 - f2;
            this.rectF.bottom = f4 - f2;
            this.paint.setColor(-14275008);
            rectF = this.rectF;
            f2 = n4;
            canvas.drawArc(rectF, f2, (float)(n2 - 90 - n4), false, this.paint);
            this.paint.setColor(this.outerColor);
            canvas.drawArc(this.rectF, f2, (float)(n - 90 - n4), false, this.paint);
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.postInvalidate();
    }

    public void setInnerProgress(int n) {
        this.endInner = n * 360 / 100;
        this.postInvalidate();
    }

    public void setOuterProgress(int n) {
        this.endOuter = n * 360 / 100;
        this.postInvalidate();
    }
}

