/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import com.brytonsport.active.utils.NumberFormatUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.i18N;

public class AppUnitUtil {
    public static final int UNIT_IMPERIAL = 1;
    public static final String UNIT_IMPERIAL_STRING;
    public static final int UNIT_METRIC = 0;
    public static final String UNIT_METRIC_STRING;

    static {
        UNIT_METRIC_STRING = i18N.get("Metric");
        UNIT_IMPERIAL_STRING = i18N.get("Imperial");
    }

    public static float centimeterToInch(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)f * 0.3937, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static float feetAndInchToInch(int n, int n2) {
        return (float)NumberFormatUtil.doubleValueFormatDigit(n * 12 + n2, 0);
    }

    public static float feetToMeter(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)f * 0.3048, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static int getIdByUnitString(String string2) {
        if (string2.equals(i18N.get("Metric"))) {
            return 0;
        }
        return 1;
    }

    public static String getUnitStringById(int n) {
        if (n == 0) {
            return i18N.get("Metric");
        }
        return i18N.get("Imperial");
    }

    public static float inchToCentimeter(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)f * 2.54, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static String inchToFeetAndInch(float f) {
        int n = (int)(f / 12.0f);
        int n2 = (int)(f % 12.0f);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append("'");
        stringBuilder.append(n2);
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    public static boolean isAppUnitMetric() {
        return (Integer)ProfileUtil.getInstance().get("app_unit_id") == 0;
    }

    public static float kilogramToLb(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)f * 2.2046, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static float kilometerToMile(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)f * 0.6214, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static float lbToKilogram(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)f * 0.4536, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static double meterToFeet(double d) {
        return NumberFormatUtil.doubleValueFormatDigit(d * 3.2808, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static float meterToFeet(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)f * 3.2808, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static float mileToKilometer(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)f * 1.6093, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static float paceKmToMi(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)f / 1.6, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static float paceMiToKm(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)f * 1.6, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static float temperatureCToF(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)f * 9.0 / 5.0 + 32.0, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }

    public static float temperatureFToC(float f) {
        return (float)NumberFormatUtil.doubleValueFormatDigit((double)(f - 32.0f) * 5.0 / 9.0, NumberFormatUtil.DEFAULT_DIGIT_NUMBER);
    }
}

