/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import android.util.Log;
import com.brytonsport.active.base.App;
import com.brytonsport.active.bleplugin.BbcpUtil;
import com.brytonsport.active.bleplugin.CommandBbcpQueueUtil;
import com.brytonsport.active.bleplugin.CommandQueueUtil;
import com.brytonsport.active.bleplugin.NewSettingUtil;
import com.brytonsport.active.bleplugin.SampleGattAttributes;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.ui.DeviceVo;
import com.brytonsport.active.utils.LocationUtils;
import com.mapbox.mapboxsdk.Mapbox;
import com.welie.blessed.BluetoothCentralManager;
import com.welie.blessed.BluetoothCentralManagerCallback;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.BluetoothPeripheralCallback;
import com.welie.blessed.BondState;
import com.welie.blessed.GattStatus;
import com.welie.blessed.HciStatus;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pub.devrel.easypermissions.EasyPermissions;

public class BleUtil {
    public static final String ACTION_BLUETOOTH_STATE_CHANGE = "com.brytonsport.active.ACTION_BLUETOOTH_STATE_CHANGE";
    public static final String ACTION_BLUETOOTH_STATE_CHANGE_EXTRA_DATA = "com.brytonsport.active.ACTION_BLUETOOTH_STATE_CHANGE_EXTRA_DATA";
    public static final String ACTION_BONDING_FAILED = "com.brytonsport.active.ACTION_BONDING_FAILED";
    public static final String ACTION_BONDING_LOST = "com.brytonsport.active.ACTION_BONDING_LOST";
    public static final String ACTION_BONDING_STARTED = "com.brytonsport.active.ACTION_BONDING_STARTED";
    public static final String ACTION_BONDING_SUCCEEDED = "com.brytonsport.active.ACTION_BONDING_SUCCEEDED";
    public static final String ACTION_CONNECTED_PERIPHERAL = "com.brytonsport.active.ACTION_CONNECTED_PERIPHERAL";
    public static final String ACTION_CONNECTION_FAILED = "com.brytonsport.active.ACTION_CONNECTION_FAILED";
    public static final String ACTION_DISCONNECTED_PERIPHERAL = "com.brytonsport.active.ACTION_DISCONNECTED_PERIPHERAL";
    public static final String ACTION_DISCONNECTED_PERIPHERAL_EXTRA_DATA = "com.brytonsport.active.ACTION_DISCONNECTED_PERIPHERAL_EXTRA_DATA";
    public static final String ACTION_NOTIFICATION_STATE_SETTING_CHANNEL = "com.brytonsport.active.ACTION_NOTIFICATION_STATE_SETTING_CHANNEL";
    public static final String ACTION_SCAN_RECORD = "com.brytonsport.active.ACTION_SCAN_RECORD";
    public static final String ACTION_SCAN_RECORD_EXTRA_DATA = "com.brytonsport.active.ACTION_SCAN_RECORD_EXTRA_DATA";
    public static final String ACTION_SERVICES_DISCOVERED = "com.brytonsport.active.ACTION_SERVICES_DISCOVERED";
    public static final String FILTER_SERVICE_UUID = "00002014-0000-1000-8000-00805f9b34fb";
    private static final String TAG = "BleUtil";
    private static BleUtil sInstance;
    BbcpUtil bbcpUtil;
    private final BluetoothCentralManagerCallback bluetoothCentralManagerCallback;
    BluetoothPeripheralCallback bluetoothPeripheralCallback;
    public BluetoothCentralManager central;
    CommandBbcpQueueUtil commandBbcpQueueUtil;
    CommandQueueUtil commandQueueUtil;
    int defaultScanTimeout = 10000;
    private List<DeviceManagerEntity> devicesInDb = new ArrayList<DeviceManagerEntity>();
    public boolean hasBlePermission = false;
    int needMtuVal = 153;
    NewSettingUtil newSettingUtil;
    private Map<String, BluetoothPeripheral> peripheralsMap;

    public BleUtil() {
        BluetoothCentralManagerCallback bluetoothCentralManagerCallback;
        this.bluetoothCentralManagerCallback = bluetoothCentralManagerCallback = new BluetoothCentralManagerCallback(){

            public void onBluetoothAdapterStateChanged(int n) {
                super.onBluetoothAdapterStateChanged(n);
                BleUtil.this.broadcastUpdate(BleUtil.ACTION_BLUETOOTH_STATE_CHANGE, n);
            }

            public void onConnectedPeripheral(BluetoothPeripheral bluetoothPeripheral) {
                super.onConnectedPeripheral(bluetoothPeripheral);
                BleUtil.this.broadcastUpdate(BleUtil.ACTION_CONNECTED_PERIPHERAL, bluetoothPeripheral.getAddress());
            }

            public void onConnectionFailed(BluetoothPeripheral bluetoothPeripheral, HciStatus hciStatus) {
                super.onConnectionFailed(bluetoothPeripheral, hciStatus);
                BleUtil.this.broadcastUpdate(BleUtil.ACTION_CONNECTION_FAILED);
            }

            public void onDisconnectedPeripheral(BluetoothPeripheral bluetoothPeripheral, HciStatus hciStatus) {
                super.onDisconnectedPeripheral(bluetoothPeripheral, hciStatus);
                BleUtil.this.broadcastUpdate(BleUtil.ACTION_DISCONNECTED_PERIPHERAL, bluetoothPeripheral.getAddress());
            }

            public void onDiscoveredPeripheral(BluetoothPeripheral object, ScanResult scanResult) {
                if ((scanResult = scanResult.getDevice()) != null) {
                    boolean bl = false;
                    object = scanResult.getAddress();
                    Object object2 = BleUtil.this.devicesInDb.iterator();
                    while (object2.hasNext()) {
                        if (!((DeviceManagerEntity)object2.next()).getMacAddress().equals(object)) continue;
                        bl = true;
                    }
                    if (!bl) {
                        if (scanResult.getBondState() == 12) {
                            new Thread(new Runnable((String)object){
                                final /* synthetic */ String val$scanDevMacAddr;
                                {
                                    this.val$scanDevMacAddr = string2;
                                }

                                @Override
                                public void run() {
                                    BleUtil.this.unBondDevice(this.val$scanDevMacAddr);
                                }
                            }).start();
                        } else {
                            object2 = new DeviceVo();
                            ((DeviceVo)object2).setAddress((String)object);
                            ((DeviceVo)object2).setName(scanResult.getName());
                            BleUtil.this.broadcastUpdate(BleUtil.ACTION_SCAN_RECORD, (DeviceVo)object2);
                        }
                    }
                }
            }
        };
        this.bluetoothPeripheralCallback = new BluetoothPeripheralCallback(){

            public void onBondLost(BluetoothPeripheral bluetoothPeripheral) {
                super.onBondLost(bluetoothPeripheral);
                Log.d((String)TAG, (String)"onBondLost: ");
                BleUtil.this.broadcastUpdate(BleUtil.ACTION_BONDING_LOST);
            }

            public void onBondingFailed(BluetoothPeripheral bluetoothPeripheral) {
                super.onBondingFailed(bluetoothPeripheral);
                Log.d((String)TAG, (String)"onBondingFailed: ");
                BleUtil.this.broadcastUpdate(BleUtil.ACTION_BONDING_FAILED, bluetoothPeripheral.getAddress(), bluetoothPeripheral.getName());
            }

            public void onBondingStarted(BluetoothPeripheral bluetoothPeripheral) {
                super.onBondingStarted(bluetoothPeripheral);
                Log.d((String)TAG, (String)"00-onBondingStarted: ");
                BleUtil.this.broadcastUpdate(BleUtil.ACTION_BONDING_STARTED);
            }

            public void onBondingSucceeded(BluetoothPeripheral bluetoothPeripheral) {
                super.onBondingSucceeded(bluetoothPeripheral);
                Log.d((String)TAG, (String)"onBondingSucceeded: ");
                BleUtil.this.broadcastUpdate(BleUtil.ACTION_BONDING_SUCCEEDED);
            }

            public void onCharacteristicUpdate(BluetoothPeripheral bluetoothPeripheral, byte[] object, BluetoothGattCharacteristic bluetoothGattCharacteristic, GattStatus gattStatus) {
                super.onCharacteristicUpdate(bluetoothPeripheral, (byte[])object, bluetoothGattCharacteristic, gattStatus);
                if (object != null && ((byte[])object).length > 0) {
                    object = bluetoothGattCharacteristic.getUuid().toString().toUpperCase();
                    if (((String)object).equals(SampleGattAttributes.CHAR_COMMAND_CHANNEL)) {
                        Log.d((String)TAG, (String)"onCharacteristicUpdate: Command channel");
                        if (BleUtil.this.bbcpUtil != null) {
                            BleUtil.this.bbcpUtil.onCharacteristicChangedCommandChannel(bluetoothGattCharacteristic);
                        }
                    } else if (((String)object).equals(SampleGattAttributes.CHAR_DATA_CHANNEL)) {
                        Log.d((String)TAG, (String)"onCharacteristicUpdate: Data channel");
                        if (BleUtil.this.bbcpUtil != null) {
                            BleUtil.this.bbcpUtil.onCharacteristicChangedDataChannel(bluetoothPeripheral, bluetoothGattCharacteristic);
                        }
                    } else if (((String)object).equals(SampleGattAttributes.CHAR_SETTING_CHANNEL) && BleUtil.this.newSettingUtil != null) {
                        BleUtil.this.newSettingUtil.onCharacteristicChangedSettingChannel(bluetoothGattCharacteristic);
                    }
                }
            }

            public void onCharacteristicWrite(BluetoothPeripheral object, byte[] byArray, BluetoothGattCharacteristic bluetoothGattCharacteristic, GattStatus gattStatus) {
                super.onCharacteristicWrite((BluetoothPeripheral)object, byArray, bluetoothGattCharacteristic, gattStatus);
                if (byArray != null && byArray.length > 0) {
                    object = bluetoothGattCharacteristic.getUuid().toString().toUpperCase();
                    if (((String)object).equals(SampleGattAttributes.CHAR_COMMAND_CHANNEL)) {
                        BleUtil.this.bbcpUtil.onCharacteristicWriteCommandChannel(bluetoothGattCharacteristic);
                    } else if (((String)object).equals(SampleGattAttributes.CHAR_DATA_CHANNEL)) {
                        BleUtil.this.bbcpUtil.onCharacteristicWriteDataChannel(bluetoothGattCharacteristic);
                    } else if (((String)object).equals(SampleGattAttributes.CHAR_NOTIFY_CHANNEL)) {
                        BleUtil.this.bbcpUtil.onCharacteristicWriteNotifyChannel(bluetoothGattCharacteristic);
                    } else if (((String)object).equals(SampleGattAttributes.CHAR_SETTING_CHANNEL)) {
                        BleUtil.this.newSettingUtil.onCharacteristicWriteSettingChannel(bluetoothGattCharacteristic);
                    }
                }
            }

            public void onMtuChanged(BluetoothPeripheral object, int n, GattStatus gattStatus) {
                super.onMtuChanged(object, n, gattStatus);
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onMtuChanged: mtu -> ");
                stringBuilder.append(n);
                stringBuilder.append(", status -> ");
                stringBuilder.append(gattStatus);
                Log.d((String)object, (String)stringBuilder.toString());
                BleUtil.this.readDeviceInfo();
            }

            public void onNotificationStateUpdate(BluetoothPeripheral object, BluetoothGattCharacteristic object2, GattStatus gattStatus) {
                super.onNotificationStateUpdate((BluetoothPeripheral)object, object2, gattStatus);
                object = object2.getUuid().toString().toUpperCase();
                object2 = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onNotificationStateUpdate: ");
                stringBuilder.append((String)object);
                stringBuilder.append(", status: ");
                stringBuilder.append(gattStatus);
                Log.d((String)object2, (String)stringBuilder.toString());
                if (((String)object).equals(SampleGattAttributes.CHAR_SETTING_CHANNEL) && gattStatus.equals((Object)GattStatus.SUCCESS)) {
                    BleUtil.this.broadcastUpdate(BleUtil.ACTION_NOTIFICATION_STATE_SETTING_CHANNEL);
                }
            }

            public void onServicesDiscovered(BluetoothPeripheral bluetoothPeripheral) {
                super.onServicesDiscovered(bluetoothPeripheral);
                String string2 = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onServicesDiscovered: CurrentMtu -> ");
                stringBuilder.append(bluetoothPeripheral.getCurrentMtu());
                Log.d((String)string2, (String)stringBuilder.toString());
                BleUtil.this.broadcastUpdate(BleUtil.ACTION_SERVICES_DISCOVERED);
                BleUtil.this.commandBbcpQueueUtil = new CommandBbcpQueueUtil((Context)App.getInstance(), bluetoothPeripheral);
                BleUtil.this.bbcpUtil = new BbcpUtil((Context)App.getInstance(), bluetoothPeripheral, BleUtil.this.commandBbcpQueueUtil);
                BleUtil.this.commandQueueUtil = new CommandQueueUtil((Context)App.getInstance(), bluetoothPeripheral);
                BleUtil.this.newSettingUtil = new NewSettingUtil((Context)App.getInstance(), bluetoothPeripheral, BleUtil.this.commandQueueUtil);
                BleUtil.this.checkDataChannelWriteType(bluetoothPeripheral);
                BleUtil.this.setNotifyOldChannel(bluetoothPeripheral);
                bluetoothPeripheral.requestMtu(BleUtil.this.needMtuVal);
            }
        };
        Log.d((String)TAG, (String)"BleUtil: \u91cd\u65b0 new BleUtil()");
        if (this.central == null) {
            this.central = new BluetoothCentralManager((Context)App.getInstance(), bluetoothCentralManagerCallback, new Handler(Looper.getMainLooper()));
        }
        if (this.peripheralsMap == null) {
            this.peripheralsMap = new HashMap<String, BluetoothPeripheral>();
        }
    }

    private void broadcastUpdate(String string2) {
        string2 = new Intent(string2);
        App.getInstance().sendBroadcast((Intent)string2);
    }

    private void broadcastUpdate(String string2, int n) {
        string2 = new Intent(string2);
        string2.putExtra(ACTION_BLUETOOTH_STATE_CHANGE_EXTRA_DATA, n);
        App.getInstance().sendBroadcast((Intent)string2);
    }

    private void broadcastUpdate(String string2, DeviceVo deviceVo) {
        string2 = new Intent(string2);
        string2.putExtra(ACTION_SCAN_RECORD_EXTRA_DATA, (Serializable)deviceVo);
        App.getInstance().sendBroadcast((Intent)string2);
    }

    private void broadcastUpdate(String string2, String string3) {
        string2 = new Intent(string2);
        string2.putExtra(ACTION_DISCONNECTED_PERIPHERAL_EXTRA_DATA, string3);
        App.getInstance().sendBroadcast((Intent)string2);
    }

    private void broadcastUpdate(String string2, String string3, String string4) {
        string2 = new Intent(string2);
        string2.putExtra("macAddress", string3);
        string2.putExtra("deviceName", string4);
        App.getInstance().sendBroadcast((Intent)string2);
    }

    public static BleUtil getInstance() {
        synchronized (BleUtil.class) {
            BleUtil bleUtil;
            if (sInstance == null) {
                Log.d((String)TAG, (String)"getInstance: BleUtil null \u91cd\u65b0 new");
                sInstance = bleUtil = new BleUtil();
            }
            bleUtil = sInstance;
            return bleUtil;
        }
    }

    private void setAppFunSupportCmd(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.app.fun.support");
        jSONArray.put(n);
        this.passSettingCommand(jSONArray);
    }

    private void setNotifyOldChannel(BluetoothPeripheral bluetoothPeripheral) {
        bluetoothPeripheral.setNotify(SampleGattAttributes.COMMAND_AND_DATA_SERVICE_UUID, SampleGattAttributes.COMMAND_CHANNEL_UUID, true);
        bluetoothPeripheral.setNotify(SampleGattAttributes.COMMAND_AND_DATA_SERVICE_UUID, SampleGattAttributes.DATA_CHANNEL_UUID, true);
        bluetoothPeripheral.setNotify(SampleGattAttributes.NOTIFY_SERVICE_UUID, SampleGattAttributes.NOTIFY_CHANNEL_UUID, true);
    }

    public void checkDataChannelWriteType(BluetoothPeripheral object) {
        if ((object = object.getCharacteristic(SampleGattAttributes.COMMAND_AND_DATA_SERVICE_UUID, SampleGattAttributes.DATA_CHANNEL_UUID)) != null) {
            int n = this.isCharacteristicWriteNoResponse((BluetoothGattCharacteristic)object);
            object = this.bbcpUtil;
            if (object != null) {
                ((BbcpUtil)object).setDataChannelWriteType(n);
            }
        }
    }

    public void config(int n, int n2, int n3, int n4) {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.setConfig(n, n2, n3, n4);
        }
    }

    public void createBondOrConnect(String object, boolean bl) {
        Log.d((String)"susan", (String)"createBondOrConnect");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("central = ");
        stringBuilder.append(this.central);
        Log.d((String)"susan", (String)stringBuilder.toString());
        if (this.central == null) {
            Log.e((String)TAG, (String)"createBondOrConnect got a null central");
            return;
        }
        if (!this.peripheralsMap.containsKey(object) && this.central.getPeripheral((String)object) != null) {
            this.peripheralsMap.put((String)object, this.central.getPeripheral((String)object));
        }
        if ((stringBuilder = this.peripheralsMap.get(object)) == null) {
            Log.e((String)TAG, (String)"createBondOrConnect got a null peripheral");
            return;
        }
        object = BondState.NONE;
        Log.d((String)"susan", (String)"LocationUtils.isSorAbove()");
        object = LocationUtils.isSorAbove() ? new String[]{"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_CONNECT"} : new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};
        if (EasyPermissions.hasPermissions((Context)Mapbox.getApplicationContext(), (String[])object)) {
            BondState bondState = stringBuilder.getBondState();
            this.hasBlePermission = true;
            object = this.central;
            if (object != null) {
                object.stopScan();
            }
            if (bl && !bondState.equals((Object)BondState.BONDED)) {
                this.central.createBond((BluetoothPeripheral)stringBuilder, this.bluetoothPeripheralCallback);
            } else {
                this.central.autoConnectPeripheral((BluetoothPeripheral)stringBuilder, this.bluetoothPeripheralCallback);
            }
            Log.d((String)"susan", (String)"createBondOrConnect()\u7d50\u675f");
            object = new StringBuilder();
            ((StringBuilder)object).append("Build.VERSION.SDK_INT = ");
            ((StringBuilder)object).append(Build.VERSION.SDK_INT);
            Log.d((String)"susan", (String)((StringBuilder)object).toString());
            return;
        }
        this.hasBlePermission = false;
    }

    public void disConnect(String string2) {
        if (this.peripheralsMap.containsKey(string2)) {
            string2 = this.peripheralsMap.get(string2);
            this.central.cancelConnection((BluetoothPeripheral)string2);
        }
    }

    public JSONObject getAppSupportFeature() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("surprise_me", true);
            jSONObject.put("log_compress", true);
            jSONObject.put("group_ride", true);
            jSONObject.put("live_tracking", true);
            jSONObject.put("android_notification", true);
            jSONObject.put("native_app", true);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public void getFile(int n, byte by) {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.getFile(n, by);
        }
    }

    public void getFileList() {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.getFileList();
        }
    }

    public void getFileRange(int n, byte by, int n2, int n3) {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.getFileRange(n, by, n2, n3);
        }
    }

    public void getLogState() {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"get.log.state");
        this.passSettingCommand(jSONArray);
    }

    public JSONObject getNewAppSupportForService(String string2) {
        NewSettingUtil newSettingUtil = this.newSettingUtil;
        if (newSettingUtil != null) {
            return newSettingUtil.getNewAppSupportForService(string2);
        }
        return null;
    }

    public float getRxProgress() {
        float f;
        block3: {
            Object object = this.bbcpUtil;
            if (object != null) {
                try {
                    f = ((BbcpUtil)object).getRxProgress();
                    break block3;
                }
                catch (Exception exception) {
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("getRxProgress error: ");
                    ((StringBuilder)object).append(exception.getMessage());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                }
            }
            f = 0.0f;
        }
        return f;
    }

    public void getServerEE() {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"get.serveree");
        this.passSettingCommand(jSONArray);
    }

    public int isCharacteristicWriteNoResponse(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        if ((bluetoothGattCharacteristic.getProperties() & 4) != 0) {
            return 1;
        }
        return 2;
    }

    public boolean isDeviceAlreadyConnected(String string2) {
        Object object = this.central;
        if (object != null) {
            object = object.getConnectedPeripherals().iterator();
            while (object.hasNext()) {
                if (!((BluetoothPeripheral)object.next()).getAddress().equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public void notifyApplication(String string2, String string3, String string4) {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.notifyApplication(string2, string3, string4);
        }
    }

    public void notifyIncomingCall(String string2, String string3) {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.notifyIncomingCall(string2, string3);
        }
    }

    public void notifyIncomingCallCancel() {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.notifyIncomingCallCancel();
        }
    }

    public void notifyIncomingEmail() {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.notifyIncomingEmail();
        }
    }

    public void notifyIncomingText() {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.notifyIncomingText();
        }
    }

    public void passSettingCommand(JSONArray jSONArray) {
        NewSettingUtil newSettingUtil = this.newSettingUtil;
        if (newSettingUtil != null) {
            newSettingUtil.settingCommand(jSONArray);
        }
    }

    public void postAltitudeValue(int n) {
        byte[] byArray = ByteBuffer.allocate(4).putInt(n).array();
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.postData(1, byArray);
        }
    }

    public void postData(int n, byte[] byArray) {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.postData(n, byArray);
        }
    }

    public void readDeviceInfo() {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.readDeviceInfo();
        }
    }

    public void requestData(int n) {
        BbcpUtil bbcpUtil = this.bbcpUtil;
        if (bbcpUtil != null) {
            bbcpUtil.requestData(n);
        }
    }

    public void resetBleUtil() {
        Log.d((String)TAG, (String)"resetBleUtil: \u65b7\u7dda\u6e05\u9664 BleUtil \u76f8\u95dc\u8cc7\u6599");
        BluetoothCentralManager bluetoothCentralManager = this.central;
        if (bluetoothCentralManager != null) {
            bluetoothCentralManager.close();
        }
        this.central = null;
        this.peripheralsMap = null;
        sInstance = null;
        this.bbcpUtil = null;
        this.commandBbcpQueueUtil = null;
        this.newSettingUtil = null;
        this.commandQueueUtil = null;
        SampleGattAttributes.isGetFileRangePhase2 = true;
    }

    public void setAppSupportFun(JSONObject object) {
        if (object != null) {
            CharSequence charSequence;
            int n;
            Iterator iterator = object.keys();
            CharSequence charSequence2 = "";
            while (true) {
                block6: {
                    boolean bl = iterator.hasNext();
                    n = 0;
                    if (!bl) break;
                    charSequence = (String)iterator.next();
                    bl = object.getBoolean((String)charSequence);
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append((String)charSequence2);
                    if (!bl) break block6;
                    n = 1;
                }
                try {
                    ((StringBuilder)charSequence).append(String.valueOf(n));
                    charSequence2 = charSequence = ((StringBuilder)charSequence).toString();
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            int n2 = (int)Math.ceil((double)((String)charSequence2).length() / 4.0);
            for (n = 0; n < n2; ++n) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)charSequence2);
                ((StringBuilder)object).append(0);
                charSequence2 = ((StringBuilder)object).toString();
            }
            object = TAG;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("setAppSupportFun: appSupFeature = ");
            ((StringBuilder)charSequence).append((String)charSequence2);
            Log.d((String)object, (String)((StringBuilder)charSequence).toString());
            charSequence2 = new StringBuilder((String)charSequence2);
            ((StringBuilder)charSequence2).reverse();
            charSequence = ((StringBuilder)charSequence2).toString();
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append("setAppSupportFun: reverseStr = ");
            ((StringBuilder)charSequence2).append((String)charSequence);
            Log.d((String)object, (String)((StringBuilder)charSequence2).toString());
            n = Integer.parseInt((String)charSequence, 2);
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append("setAppSupportFun: appSupFeatureNum = ");
            ((StringBuilder)charSequence2).append(n);
            Log.d((String)object, (String)((StringBuilder)charSequence2).toString());
            this.setAppFunSupportCmd(n);
        }
    }

    public void setBbcpRxTx(JSONObject jSONObject) {
        if (jSONObject != null) {
            try {
                this.config(jSONObject.getInt("payloadSize"), jSONObject.getInt("handShakeSize"), 39600, 6930);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    public void setBtNotifyDev(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.btnotifydev");
        jSONArray.put(n);
        this.passSettingCommand(jSONArray);
    }

    public void setDevNotify(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.dev.notify");
        jSONArray.put(n);
        this.passSettingCommand(jSONArray);
    }

    public void setDevVoiceLang(String string2) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.dev.voiceLang");
        jSONArray.put((Object)string2);
        this.passSettingCommand(jSONArray);
    }

    public void setDevicesInDb(List<DeviceManagerEntity> list) {
        this.devicesInDb = list;
    }

    public void setLatLon(int n, double d, double d2) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.latLon");
        jSONArray.put(n);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("latitude", d);
            jSONObject.put("longitude", d2);
            jSONArray.put((Object)jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.passSettingCommand(jSONArray);
    }

    public void setLiveTrackingSwitch(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.liveTracking.switch");
        jSONArray.put(1);
        jSONArray.put(n);
        this.passSettingCommand(jSONArray);
    }

    public void setLiveTrackingSwitchStop(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.liveTracking.switch");
        jSONArray.put(n);
        jSONArray.put(0);
        this.passSettingCommand(jSONArray);
    }

    public void setNewApp() {
        JSONArray jSONArray = new JSONArray();
        try {
            jSONArray.put(0, (Object)"set.new.app");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.passSettingCommand(jSONArray);
    }

    public void setNotifyNewChannel(BluetoothPeripheral bluetoothPeripheral) {
        bluetoothPeripheral.setNotify(SampleGattAttributes.SETTING_SERVICE_UUID, SampleGattAttributes.SETTING_CHANNEL_UUID, true);
    }

    public void setPhoneName(String string2) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.phone.name");
        jSONArray.put((Object)string2);
        this.passSettingCommand(jSONArray);
    }

    public void setPlantrip(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.plan_trip");
        jSONArray.put(n);
        this.passSettingCommand(jSONArray);
    }

    public void setPlantripName(String string2) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.plantrip.name");
        jSONArray.put((Object)string2);
        this.passSettingCommand(jSONArray);
    }

    public void setSpeechToText(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.speechToText");
        jSONArray.put(n);
        this.passSettingCommand(jSONArray);
    }

    public void setSurpriseMeDistance(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.surpriseMe.distance");
        jSONArray.put(n);
        this.passSettingCommand(jSONArray);
    }

    public void setUnit(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.unit");
        jSONArray.put(n);
        this.passSettingCommand(jSONArray);
    }

    public void setVoiceResult(String string2) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.voice_result");
        jSONArray.put((Object)string2);
        this.passSettingCommand(jSONArray);
    }

    public void startScan() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (BleUtil.this.central != null) {
                    BleUtil.this.central.stopScan();
                }
                Log.d((String)TAG, (String)"mHandler stopScan");
            }
        }, (long)this.defaultScanTimeout);
        ArrayList<ScanFilter> arrayList = new ArrayList<ScanFilter>();
        arrayList.add(new ScanFilter.Builder().setServiceUuid(ParcelUuid.fromString((String)FILTER_SERVICE_UUID)).build());
        this.central.scanForPeripheralsUsingFilters(arrayList);
    }

    public void unBondDevice(String string2) {
        Object object = this.central;
        if (object != null) {
            boolean bl = object.removeBond(string2);
            object = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("unBondDevice ->");
            stringBuilder.append(string2);
            stringBuilder.append(" result:");
            stringBuilder.append(bl);
            Log.d((String)object, (String)stringBuilder.toString());
        }
        if ((object = this.peripheralsMap) == null) {
            return;
        }
        if ((string2 = (BluetoothPeripheral)object.get(string2)) != null && string2.getBondState().equals((Object)BondState.BONDED)) {
            this.central.cancelConnection((BluetoothPeripheral)string2);
        }
    }
}

