/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

public class DistanceUtil {
    public static double aroundUp(double d, int n) {
        double d2 = (int)Math.pow(10.0, n);
        return Math.ceil(d * d2) / d2;
    }

    public static double distance(double d, double d2, double d3, double d4) {
        if (d == d3 && d2 == d4) {
            return 0.0;
        }
        d = d * Math.PI / 180.0;
        d3 = d3 * Math.PI / 180.0;
        d2 = d2 * Math.PI / 180.0;
        d4 = d4 * Math.PI / 180.0;
        return Math.acos(Math.sin(d) * Math.sin(d3) + Math.cos(d) * Math.cos(d3) * Math.cos(d4 - d2)) * 6372795.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double distance(double d, double d2, double d3, double d4, String string2) {
        if (d == d3 && d2 == d4) {
            return 0.0;
        }
        d2 = Math.toDegrees(Math.acos(Math.sin(Math.toRadians(d)) * Math.sin(Math.toRadians(d3)) + Math.cos(Math.toRadians(d)) * Math.cos(Math.toRadians(d3)) * Math.cos(Math.toRadians(d2 - d4)))) * 60.0 * 1.1515;
        if (string2.equals("K")) {
            d = 1.609344;
            return d2 * d;
        }
        d = d2;
        if (!string2.equals("N")) return d;
        d = 0.8684;
        return d2 * d;
    }

    public static String distanceDefaultFormat(double d) {
        return String.format("%.2f", d);
    }

    public static double distanceMeteor2Km(double d) {
        return DistanceUtil.aroundUp(d / 1000.0, 2);
    }

    public static boolean isDistanceOver1000Meteor(double d) {
        boolean bl = d >= 1000.0;
        return bl;
    }
}

