/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.content.Context;
import android.os.Bundle;
import com.brytonsport.active.base.App;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.firebase.crashlytics.FirebaseCrashlytics;

public class FirebaseCustomUtil {
    private static String BRYTON_CUSTOM_EVENT_NAME = "bryton_custom";
    private static String KEY_ACTIVITY_FIT_DECODE_LOG = "activity_fit_decode_log";
    private static String KEY_ACTIVITY_FIT_DECODE_OTHER_ERROR = "activity_fit_decode_other_error";
    private static String KEY_ACTIVITY_LOG = "activity_log";
    private static String KEY_BLE_LOG = "ble_log";
    private static String KEY_CONNECT_HANDSHAKE_STATE = "connect_handshake_state";
    private static FirebaseCustomUtil sInstance;
    private FirebaseCrashlytics crashlytics;
    private FirebaseAnalytics mFirebaseAnalytics;

    public FirebaseCustomUtil() {
        FirebaseApp.initializeApp((Context)App.getInstance());
        if (this.crashlytics == null) {
            this.crashlytics = FirebaseCrashlytics.getInstance();
        }
        if (this.mFirebaseAnalytics == null) {
            this.mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)App.getInstance());
        }
    }

    public static FirebaseCustomUtil getInstance() {
        if (sInstance == null) {
            sInstance = new FirebaseCustomUtil();
        }
        return sInstance;
    }

    public void logCustomEvent(String string2) {
        if (this.mFirebaseAnalytics != null) {
            Bundle bundle = new Bundle();
            bundle.putString("cust_msg", "\u81ea\u5b9a\u7fa9Bryton");
            bundle.putString(KEY_CONNECT_HANDSHAKE_STATE, string2);
            this.mFirebaseAnalytics.logEvent(BRYTON_CUSTOM_EVENT_NAME, bundle);
        }
    }

    public void setActivityDecodeLogMessage(String string2) {
        FirebaseCrashlytics firebaseCrashlytics = this.crashlytics;
        if (firebaseCrashlytics != null) {
            firebaseCrashlytics.setCustomKey(KEY_ACTIVITY_FIT_DECODE_LOG, string2);
            firebaseCrashlytics = this.crashlytics;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u9019\u662f Activity Fit Decode Log -> ");
            stringBuilder.append(string2);
            firebaseCrashlytics.log(stringBuilder.toString());
            this.crashlytics.recordException((Throwable)new RuntimeException(string2));
            this.crashlytics.sendUnsentReports();
        }
    }

    public void setActivityDecodeOtherErrorMessage(String string2) {
        Object object = this.crashlytics;
        if (object != null) {
            object.setCustomKey(KEY_ACTIVITY_FIT_DECODE_OTHER_ERROR, string2);
            FirebaseCrashlytics firebaseCrashlytics = this.crashlytics;
            object = new StringBuilder();
            ((StringBuilder)object).append("\u9019\u662f Activity Fit Decode \u975ecrc error -> ");
            ((StringBuilder)object).append(string2);
            firebaseCrashlytics.log(((StringBuilder)object).toString());
            this.crashlytics.recordException((Throwable)new RuntimeException(string2));
            this.crashlytics.sendUnsentReports();
        }
    }

    public void setActivityLogMessage(String string2) {
        Object object = this.crashlytics;
        if (object != null) {
            object.setCustomKey(KEY_ACTIVITY_LOG, string2);
            FirebaseCrashlytics firebaseCrashlytics = this.crashlytics;
            object = new StringBuilder();
            ((StringBuilder)object).append("\u9019\u662f Activity Log -> ");
            ((StringBuilder)object).append(string2);
            firebaseCrashlytics.log(((StringBuilder)object).toString());
            this.crashlytics.recordException((Throwable)new RuntimeException(string2));
            this.crashlytics.sendUnsentReports();
        }
    }

    public void setBleLogMessage(String string2) {
        Object object = this.crashlytics;
        if (object != null) {
            object.setCustomKey(KEY_BLE_LOG, string2);
            FirebaseCrashlytics firebaseCrashlytics = this.crashlytics;
            object = new StringBuilder();
            ((StringBuilder)object).append("\u9019\u662f BLE Log -> ");
            ((StringBuilder)object).append(string2);
            firebaseCrashlytics.log(((StringBuilder)object).toString());
            this.crashlytics.recordException((Throwable)new RuntimeException(string2));
            this.crashlytics.sendUnsentReports();
        }
    }

    public void setCustomLogMessage(String string2) {
        FirebaseCrashlytics firebaseCrashlytics = this.crashlytics;
        if (firebaseCrashlytics != null) {
            firebaseCrashlytics.setCustomKey(KEY_CONNECT_HANDSHAKE_STATE, string2);
            firebaseCrashlytics = this.crashlytics;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u9019\u662flog -> ");
            stringBuilder.append(string2);
            firebaseCrashlytics.log(stringBuilder.toString());
            this.crashlytics.recordException((Throwable)new RuntimeException(string2));
            this.crashlytics.sendUnsentReports();
        }
    }
}

