/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipUtils {
    public static byte[] compress(String string2) throws IOException {
        if (string2 != null && string2.length() != 0) {
            return GZipUtils.compress(string2.getBytes("utf-8"));
        }
        return null;
    }

    public static byte[] compress(byte[] byArray) throws IOException {
        if (byArray != null && byArray.length != 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void compressGzipFile(String string2, String object) {
        byte[] byArray = new byte[1024];
        try {
            Closeable closeable = new FileOutputStream((String)object);
            object = new GZIPOutputStream((OutputStream)closeable);
            closeable = new FileInputStream(string2);
            while (true) {
                int n;
                if ((n = ((FileInputStream)closeable).read(byArray)) <= 0) {
                    ((FileInputStream)closeable).close();
                    ((GZIPOutputStream)object).finish();
                    ((DeflaterOutputStream)object).close();
                    Log.d((String)"GZipUtils", (String)"compressGzipFile: The file was compressed successfully!");
                    return;
                }
                ((GZIPOutputStream)object).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean isGzip(byte[] byArray) {
        boolean bl = false;
        byte by = byArray[0];
        if ((byArray[1] & 0xFF | by << 8) == 8075) {
            bl = true;
        }
        return bl;
    }

    public static String uncompress(String string2) throws IOException {
        if (string2 != null && string2.length() != 0) {
            return new String(GZipUtils.uncompress(string2.getBytes("utf-8")));
        }
        return string2;
    }

    public static byte[] uncompress(byte[] object) throws IOException {
        Object object2 = object;
        if (object != null) {
            if (((byte[])object).length == 0) {
                object2 = object;
            } else {
                int n;
                object2 = new ByteArrayOutputStream();
                object = new ByteArrayInputStream((byte[])object);
                GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)object);
                byte[] byArray = new byte[1024];
                while ((n = gZIPInputStream.read(byArray)) >= 0) {
                    object2.write(byArray, 0, n);
                }
                gZIPInputStream.close();
                ((ByteArrayInputStream)object).close();
                object2 = object2.toByteArray();
            }
        }
        return object2;
    }
}

