/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class IniFileUtil
implements Serializable {
    private String charSet = "UTF-8";
    private Integer cyclingSectionCount = 0;
    private File file = null;
    private String line_separator = "\\r\\n";
    private ArrayList<String> sectionKeys;
    private Map<String, Section> sections = new LinkedHashMap<String, Section>();

    public IniFileUtil() {
        this.sectionKeys = new ArrayList();
    }

    public IniFileUtil(File file) {
        this.sectionKeys = new ArrayList();
        this.file = file;
        this.initFromFile(file);
    }

    public IniFileUtil(InputStream inputStream) {
        this.sectionKeys = new ArrayList();
        this.initFromInputStream(inputStream);
    }

    private void initFromFile(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            this.toIniFile(bufferedReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private void initFromInputStream(InputStream inputStream) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.charSet);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            this.toIniFile(bufferedReader);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveConfig(BufferedWriter bufferedWriter) {
        int n;
        boolean bl;
        int n2;
        Object[] objectArray;
        try {
            objectArray = this.line_separator;
            n2 = 0;
            bl = objectArray == null || objectArray.trim().equals("");
            objectArray = this.sections.keySet().toArray();
            n = objectArray.length;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        while (n2 < n) {
            Iterator<Map.Entry<String, String>> iterator = objectArray[n2];
            {
                Section section = this.sections.get((String)((Object)iterator));
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("[");
                stringBuilder.append(iterator);
                stringBuilder.append("]");
                bufferedWriter.write(stringBuilder.toString());
                if (bl) {
                    bufferedWriter.write(this.line_separator);
                } else {
                    bufferedWriter.newLine();
                }
                for (Map.Entry<String, String> entry : section.getValues().entrySet()) {
                    bufferedWriter.write(entry.getKey());
                    bufferedWriter.write("=");
                    bufferedWriter.write(entry.getValue());
                    if (bl) {
                        bufferedWriter.write(this.line_separator);
                        continue;
                    }
                    bufferedWriter.newLine();
                }
                ++n2;
            }
        }
        {
            bufferedWriter.close();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void toIniFile(BufferedReader bufferedReader) {
        Pattern pattern = Pattern.compile("^\\[.*\\]$");
        Section section = null;
        try {
            while (true) {
                String[] stringArray;
                if ((stringArray = bufferedReader.readLine()) == null) {
                    bufferedReader.close();
                    return;
                }
                if (pattern.matcher((CharSequence)stringArray).matches()) {
                    stringArray = stringArray.trim();
                    section = new Section();
                    Section.access$002(section, stringArray.substring(1, stringArray.length() - 1));
                    this.sections.put(section.name, section);
                    this.sectionKeys.add(section.name);
                    if (!section.name.startsWith("Page") || !section.name.endsWith("Cycling")) continue;
                    this.cyclingSectionCount = this.cyclingSectionCount + 1;
                    continue;
                }
                if ((stringArray = stringArray.split("=")).length != 2) continue;
                if (stringArray[0].equals("DataPage")) {
                    section.set(stringArray[0], "0");
                    continue;
                }
                section.set(stringArray[0], stringArray[1]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Section get(String string2) {
        return this.sections.get(string2);
    }

    public Object get(String string2, String string3) {
        return this.get(string2, string3, null);
    }

    public Object get(String object, String string2, String string3) {
        if ((object = this.sections.get(object)) != null) {
            if ((object = ((Section)object).get(string2)) != null && !object.toString().trim().equals("")) {
                return object;
            }
            return string3;
        }
        return null;
    }

    public Integer getCyclingSectionCount() {
        return this.cyclingSectionCount;
    }

    public byte[] getFileContent() {
        byte[] byArray = new byte[(int)this.file.length()];
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return byArray;
    }

    public Section getPageSection(Integer n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Page");
        stringBuilder.append(String.valueOf(n + 1));
        stringBuilder.append("_Cycling");
        return this.get(stringBuilder.toString());
    }

    public Map<String, Section> getSections() {
        return this.sections;
    }

    public void load(File file) {
        this.file = file;
        this.initFromFile(file);
    }

    public void load(InputStream inputStream) {
        this.initFromInputStream(inputStream);
    }

    public void remove(String string2) {
        this.sections.remove(string2);
        this.sectionKeys.remove(string2);
    }

    public void remove(String object, String string2) {
        if ((object = this.sections.get(object)) != null) {
            ((Section)object).getValues().remove(string2);
        }
    }

    public void save() {
        this.save(this.file);
    }

    public void save(File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            this.saveConfig(bufferedWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void save(OutputStream outputStream) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.charSet);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            this.saveConfig(bufferedWriter);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void set(String string2, String string3, String string4) {
        Section section;
        Section section2 = section = this.sections.get(string2);
        if (section == null) {
            section2 = new Section();
        }
        Section.access$002(section2, string2);
        section2.set(string3, string4);
        this.sections.put(string2, section2);
    }

    public void setCharSet(String string2) {
        this.charSet = string2;
    }

    public void setLineSeparator(String string2) {
        this.line_separator = string2;
    }

    public class Section
    implements Serializable {
        private String name;
        private Map<String, String> values = new LinkedHashMap<String, String>();

        static /* synthetic */ String access$002(Section section, String string2) {
            section.name = string2;
            return string2;
        }

        public String get(String string2) {
            return this.values.get(string2);
        }

        public ArrayList<String> getKeys() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.values.keySet());
            return arrayList;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getValues() {
            return this.values;
        }

        public Boolean hasKey(String string2) {
            return this.values.containsKey(string2);
        }

        public void set(String string2, String string3) {
            this.values.put(string2, string3);
        }

        public void setName(String string2) {
            this.name = string2;
        }
    }
}

