/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.LocationManager;
import android.os.Build;
import android.preference.PreferenceManager;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.location.LocationManagerCompat;

public class LocationUtils {
    private static final String PREFS_BLUETOOTH_PERMISSION_REQUESTED = "bluetooth_permission_requested";
    private static final String PREFS_LOCATION_REQUIRED = "location_required";
    private static final String PREFS_PERMISSION_REQUESTED = "permission_requested";

    public static void clearBluetoothPermissionRequested(Context context) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean(PREFS_BLUETOOTH_PERMISSION_REQUESTED, false).apply();
    }

    public static void clearLocationPermissionRequested(Context context) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean(PREFS_PERMISSION_REQUESTED, false).apply();
    }

    public static boolean isBleEnabled() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        boolean bl = bluetoothAdapter != null && bluetoothAdapter.isEnabled();
        return bl;
    }

    public static boolean isBluetoothConnectPermissionGranted(Context context) {
        boolean bl = LocationUtils.isSorAbove();
        boolean bl2 = true;
        if (!bl) {
            return true;
        }
        if (ContextCompat.checkSelfPermission(context, "android.permission.BLUETOOTH_CONNECT") != 0) {
            bl2 = false;
        }
        return bl2;
    }

    public static boolean isBluetoothScanPermissionDeniedForever(Activity activity) {
        boolean bl;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)activity);
        boolean bl2 = LocationUtils.isLocationPermissionGranted((Context)activity);
        boolean bl3 = bl = false;
        if (!bl2) {
            bl3 = bl;
            if (sharedPreferences.getBoolean(PREFS_BLUETOOTH_PERMISSION_REQUESTED, false)) {
                bl3 = bl;
                if (!ActivityCompat.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION")) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    public static boolean isBluetoothScanPermissionGranted(Context context) {
        boolean bl = LocationUtils.isSorAbove();
        boolean bl2 = true;
        if (!bl) {
            return true;
        }
        if (ContextCompat.checkSelfPermission(context, "android.permission.BLUETOOTH_SCAN") != 0) {
            bl2 = false;
        }
        return bl2;
    }

    public static boolean isLocationEnabled(Context context) {
        if (LocationUtils.isMarshmallowOrAbove()) {
            return LocationManagerCompat.isLocationEnabled((LocationManager)context.getSystemService(LocationManager.class));
        }
        return true;
    }

    public static boolean isLocationPermissionDeniedForever(Activity activity) {
        boolean bl;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)activity);
        boolean bl2 = LocationUtils.isLocationPermissionGranted((Context)activity);
        boolean bl3 = bl = false;
        if (!bl2) {
            bl3 = bl;
            if (sharedPreferences.getBoolean(PREFS_PERMISSION_REQUESTED, false)) {
                bl3 = bl;
                if (!ActivityCompat.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION")) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    public static boolean isLocationPermissionGranted(Context context) {
        boolean bl = ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION") == 0;
        return bl;
    }

    public static boolean isLocationPermissionRequired() {
        boolean bl = LocationUtils.isMarshmallowOrAbove() && !LocationUtils.isSorAbove();
        return bl;
    }

    public static boolean isLocationRequired(Context context) {
        context = PreferenceManager.getDefaultSharedPreferences((Context)context);
        boolean bl = LocationUtils.isMarshmallowOrAbove() && !LocationUtils.isSorAbove();
        return context.getBoolean(PREFS_LOCATION_REQUIRED, bl);
    }

    public static boolean isMarshmallowOrAbove() {
        boolean bl = Build.VERSION.SDK_INT >= 23;
        return bl;
    }

    public static boolean isSorAbove() {
        boolean bl = Build.VERSION.SDK_INT >= 31;
        return bl;
    }

    public static void markBluetoothScanPermissionRequested(Context context) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean(PREFS_BLUETOOTH_PERMISSION_REQUESTED, true).apply();
    }

    public static void markLocationNotRequired(Context context) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean(PREFS_LOCATION_REQUIRED, false).apply();
    }

    public static void markLocationPermissionRequested(Context context) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean(PREFS_PERMISSION_REQUESTED, true).apply();
    }
}

