/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.content.Context;
import android.location.Location;
import android.util.Log;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.IniFileUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.vm.base.Favorite;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class MyFavIniFileUtil
extends IniFileUtil {
    private static final String DEVICE_INI_FILENAME = "device.ini";
    public static final String INI_FILE_LOC_SECTION_CTIME = "CTime";
    public static final String INI_FILE_LOC_SECTION_ID = "ID";
    public static final String INI_FILE_LOC_SECTION_INFO = "Info";
    public static final String INI_FILE_LOC_SECTION_LAT = "Lat";
    public static final String INI_FILE_LOC_SECTION_LON = "Lon";
    public static final String INI_FILE_LOC_SECTION_MY_FAV = "IsMyFav";
    public static final String INI_FILE_LOC_SECTION_NAME = "Name";
    public static final String INI_FILE_MY_FAV_SECTION_NUM = "Num";
    public static final String INI_FILE_SECTION_LOC_PREFIX = "Loc";
    public static final String INI_FILE_SECTION_MY_FAV = "MyFavorite";
    private static final String MY_FAV_FOLDER = "myfav";
    private static final String TMP_INI_FILENAME = "tmp.ini";
    private boolean isModified = false;

    public MyFavIniFileUtil() {
    }

    private MyFavIniFileUtil(File file) {
        super(file);
    }

    public static MyFavIniFileUtil craeteEmptyMyFavIni() {
        MyFavIniFileUtil myFavIniFileUtil = new MyFavIniFileUtil();
        myFavIniFileUtil.set(INI_FILE_SECTION_MY_FAV, INI_FILE_MY_FAV_SECTION_NUM, "0");
        return myFavIniFileUtil;
    }

    public static MyFavIniFileUtil createDeviceMyFavIni(Context object) {
        if ((object = MyFavIniFileUtil.getDeviceIniFile((Context)object)) != null && ((File)object).exists()) {
            return new MyFavIniFileUtil((File)object);
        }
        return null;
    }

    private static File getDeviceIniFile(Context object) {
        if (object == null) {
            return null;
        }
        Object object2 = (String)ProfileUtil.getInstance().get("userId");
        if (object2 != null && !((String)object2).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object.getFilesDir());
            stringBuilder.append(File.separator);
            stringBuilder.append((String)object2);
            stringBuilder.append(File.separator);
            stringBuilder.append(MY_FAV_FOLDER);
            stringBuilder.append(File.separator);
            stringBuilder.append(DEVICE_INI_FILENAME);
            object2 = new File(stringBuilder.toString());
            object = ((File)object2).getParentFile();
            if (object != null && !((File)object).exists() && !((File)object).mkdirs()) {
                return null;
            }
            return object2;
        }
        return null;
    }

    public static ArrayList<Favorite> getMyFavListFromDevice(Context object, Location location) {
        int n;
        ArrayList<Favorite> arrayList = new ArrayList<Favorite>();
        MyFavIniFileUtil myFavIniFileUtil = MyFavIniFileUtil.createDeviceMyFavIni((Context)object);
        if (myFavIniFileUtil != null && (object = myFavIniFileUtil.get(INI_FILE_SECTION_MY_FAV)) != null && (n = Integer.parseInt(((IniFileUtil.Section)object).get(INI_FILE_MY_FAV_SECTION_NUM))) > 0) {
            for (int i = 1; i <= n; ++i) {
                Object object2;
                object = new StringBuilder();
                ((StringBuilder)object).append(INI_FILE_SECTION_LOC_PREFIX);
                ((StringBuilder)object).append(i);
                IniFileUtil.Section section = myFavIniFileUtil.get(((StringBuilder)object).toString());
                if (section == null) continue;
                object = section.get(INI_FILE_LOC_SECTION_INFO);
                Object object3 = "";
                if (object != null && !((String)object).isEmpty()) {
                    object2 = ((String)object).split(Pattern.quote("|"));
                    object = ((String[])object2).length >= 1 ? object2[0] : "";
                    if (((String[])object2).length >= 2) {
                        object3 = object2[1];
                    }
                } else {
                    object3 = object = "";
                }
                int n2 = Integer.parseInt(section.get(INI_FILE_LOC_SECTION_ID));
                String string2 = section.get(INI_FILE_LOC_SECTION_LAT);
                object2 = section.get(INI_FILE_LOC_SECTION_LON);
                float f = (float)(Utils.parseDouble(string2, Locale.getDefault()) / 1000000.0);
                float f2 = (float)(Utils.parseDouble((String)object2, Locale.getDefault()) / 1000000.0);
                if (location != null) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(DistanceUtil.distance(f, f2, location.getLatitude(), location.getLongitude(), "K"));
                    ((StringBuilder)object2).append(" km");
                    object2 = ((StringBuilder)object2).toString();
                } else {
                    object2 = "0 km";
                }
                arrayList.add(new Favorite((String)object, (String)object3, n2, f, f2, (String)object2, section.get(INI_FILE_LOC_SECTION_NAME), (long)(Double.parseDouble(section.get(INI_FILE_LOC_SECTION_CTIME)) * 1000.0), false));
            }
        }
        return arrayList;
    }

    private static File getTmpIniFile(Context object) {
        if (object == null) {
            return null;
        }
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        if (string2 != null && !string2.isEmpty()) {
            Comparable<StringBuilder> comparable = new StringBuilder();
            ((StringBuilder)comparable).append(object.getFilesDir());
            ((StringBuilder)comparable).append(File.separator);
            ((StringBuilder)comparable).append(string2);
            ((StringBuilder)comparable).append(File.separator);
            ((StringBuilder)comparable).append(MY_FAV_FOLDER);
            ((StringBuilder)comparable).append(File.separator);
            ((StringBuilder)comparable).append(TMP_INI_FILENAME);
            comparable = new File(((StringBuilder)comparable).toString());
            object = ((File)comparable).getParentFile();
            if (object != null && !((File)object).exists() && !((File)object).mkdirs()) {
                return null;
            }
            return comparable;
        }
        return null;
    }

    public static byte[] readDeviceIniFile(Context object) {
        File file = MyFavIniFileUtil.getDeviceIniFile(object);
        if (file != null && file.exists()) {
            byte[] byArray = new byte[(int)file.length()];
            try {
                InputStream inputStream = new FileInputStream(file);
                object = new BufferedInputStream(inputStream);
                inputStream = new DataInputStream((InputStream)object);
                ((DataInputStream)inputStream).readFully(byArray);
                return byArray;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        return null;
    }

    public static boolean saveToDeviceIni(Context object, byte[] byArray) {
        File file = MyFavIniFileUtil.getDeviceIniFile((Context)object);
        if (file == null) {
            return false;
        }
        if (file.exists() && !file.delete()) {
            return false;
        }
        try {
            if (file.createNewFile()) {
                object = new FileOutputStream(file);
                ((FileOutputStream)object).write(byArray);
                return true;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public void addLocSections(MyFavIniFileUtil objectArray) {
        if (objectArray == null) {
            return;
        }
        Map<String, IniFileUtil.Section> map = objectArray.getSections();
        objectArray = map.keySet().toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            IniFileUtil.Section section = map.get(objectArray[i]);
            if (section == null || (string2 = section.get(INI_FILE_LOC_SECTION_ID)) == null || string2.isEmpty()) continue;
            this.addLocation(section.get(INI_FILE_LOC_SECTION_INFO), section.get(INI_FILE_LOC_SECTION_LAT), section.get(INI_FILE_LOC_SECTION_LON), section.get(INI_FILE_LOC_SECTION_NAME), section.get(INI_FILE_LOC_SECTION_CTIME));
        }
    }

    public void addLocation(String string2, String string3, String string4, String string5, String string6) {
        String string7 = (String)this.get(INI_FILE_SECTION_MY_FAV, INI_FILE_MY_FAV_SECTION_NUM);
        if (string7 != null && !string7.isEmpty()) {
            string7 = Integer.toString(Integer.parseInt(string7) + 1);
            CharSequence charSequence = new StringBuilder();
            charSequence.append(INI_FILE_SECTION_LOC_PREFIX);
            charSequence.append(string7);
            charSequence = charSequence.toString();
            this.set((String)charSequence, INI_FILE_LOC_SECTION_INFO, string2);
            this.set((String)charSequence, INI_FILE_LOC_SECTION_ID, string7);
            this.set((String)charSequence, INI_FILE_LOC_SECTION_LAT, string3);
            this.set((String)charSequence, INI_FILE_LOC_SECTION_LON, string4);
            this.set((String)charSequence, INI_FILE_LOC_SECTION_NAME, string5);
            this.set((String)charSequence, INI_FILE_LOC_SECTION_MY_FAV, "0");
            this.set((String)charSequence, INI_FILE_LOC_SECTION_CTIME, string6);
            this.set(INI_FILE_SECTION_MY_FAV, INI_FILE_MY_FAV_SECTION_NUM, string7);
            this.isModified = true;
        }
    }

    public void deleteLocSection(int n) {
        IniFileUtil.Section section;
        Object object;
        int n2;
        Map<String, IniFileUtil.Section> map;
        if (n <= 0) {
            return;
        }
        Object[] objectArray = Integer.toString(n);
        int n3 = 0;
        n = 0;
        int n4 = 0;
        block0: while (n == 0) {
            map = this.getSections();
            Object object2 = map.keySet().toArray();
            n2 = ((Object[])object2).length;
            for (n = 0; n < n2; ++n) {
                object = object2[n];
                section = map.get(object);
                if (section == null || section.getName().equals(INI_FILE_SECTION_MY_FAV)) continue;
                if (section.getName().startsWith(INI_FILE_SECTION_LOC_PREFIX)) {
                    if (!objectArray.equals(section.get(INI_FILE_LOC_SECTION_ID))) continue;
                    map.remove(object);
                } else {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Strange section : ");
                    ((StringBuilder)object2).append(section.getName());
                    Log.d((String)"MayFavINI", (String)((StringBuilder)object2).toString());
                    map.remove(object);
                }
                n = 0;
                n4 = 1;
                continue block0;
            }
            n = 1;
        }
        if (n4 != 0) {
            this.isModified = true;
            map = this.getSections();
            objectArray = map.keySet().toArray();
            n2 = objectArray.length;
            n4 = 1;
            for (n = n3; n < n2; ++n) {
                section = map.get(objectArray[n]);
                n3 = n4;
                if (section != null) {
                    if (section.getName().equals(INI_FILE_SECTION_MY_FAV)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("");
                        ((StringBuilder)object).append(objectArray.length - 1);
                        section.set(INI_FILE_MY_FAV_SECTION_NUM, ((StringBuilder)object).toString());
                        n3 = n4;
                    } else {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(INI_FILE_SECTION_LOC_PREFIX);
                        ((StringBuilder)object).append(n4);
                        section.setName(((StringBuilder)object).toString());
                        object = new StringBuilder();
                        ((StringBuilder)object).append("");
                        ((StringBuilder)object).append(n4);
                        section.set(INI_FILE_LOC_SECTION_ID, ((StringBuilder)object).toString());
                        n3 = n4 + 1;
                    }
                }
                n4 = n3;
            }
        }
    }

    public void deleteLocSection(ArrayList<Integer> object) {
        if (object != null && ((ArrayList)object).size() > 0) {
            Object object2;
            Object object3;
            int n;
            int n2;
            Object object4;
            Iterator<Integer> iterator = ((ArrayList)object).iterator();
            int n3 = 0;
            int n4 = 0;
            block0: while (iterator.hasNext()) {
                object4 = Integer.toString(iterator.next());
                n2 = n4;
                block1: while (true) {
                    n = 0;
                    while (true) {
                        n4 = n2;
                        if (n != 0) continue block0;
                        object3 = this.getSections();
                        Object object5 = object3.keySet().toArray();
                        n = ((Object[])object5).length;
                        for (n4 = 0; n4 < n; ++n4) {
                            object2 = object5[n4];
                            object = object3.get(object2);
                            if (object == null || ((IniFileUtil.Section)object).getName().equals(INI_FILE_SECTION_MY_FAV)) continue;
                            if (((IniFileUtil.Section)object).getName().startsWith(INI_FILE_SECTION_LOC_PREFIX)) {
                                if (!((String)object4).equals(((IniFileUtil.Section)object).get(INI_FILE_LOC_SECTION_ID))) continue;
                                object3.remove(object2);
                            } else {
                                object5 = new StringBuilder();
                                ((StringBuilder)object5).append("Strange section : ");
                                ((StringBuilder)object5).append(((IniFileUtil.Section)object).getName());
                                Log.d((String)"MayFavINI", (String)((StringBuilder)object5).toString());
                                object3.remove(object2);
                            }
                            n2 = 1;
                            continue block1;
                        }
                        n = 1;
                    }
                    break;
                }
            }
            if (n4 != 0) {
                this.isModified = true;
                object2 = this.getSections();
                object = object2.keySet().toArray();
                int n5 = ((Object[])object).length;
                n = 1;
                for (n2 = n3; n2 < n5; ++n2) {
                    object4 = object2.get(object[n2]);
                    n4 = n;
                    if (object4 != null) {
                        if (((IniFileUtil.Section)object4).getName().equals(INI_FILE_SECTION_MY_FAV)) {
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append("");
                            ((StringBuilder)object3).append(((Object)object).length - 1);
                            ((IniFileUtil.Section)object4).set(INI_FILE_MY_FAV_SECTION_NUM, ((StringBuilder)object3).toString());
                            n4 = n;
                        } else {
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append(INI_FILE_SECTION_LOC_PREFIX);
                            ((StringBuilder)object3).append(n);
                            ((IniFileUtil.Section)object4).setName(((StringBuilder)object3).toString());
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append("");
                            ((StringBuilder)object3).append(n);
                            ((IniFileUtil.Section)object4).set(INI_FILE_LOC_SECTION_ID, ((StringBuilder)object3).toString());
                            n4 = n + 1;
                        }
                    }
                    n = n4;
                }
            }
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public boolean saveToDeviceIniFile(Context object) {
        if ((object = MyFavIniFileUtil.getDeviceIniFile((Context)object)) == null) {
            return false;
        }
        if (((File)object).exists() && !((File)object).delete()) {
            return false;
        }
        this.save((File)object);
        return true;
    }

    public boolean saveToTmpIniFile(Context object) {
        if ((object = MyFavIniFileUtil.getTmpIniFile((Context)object)) == null) {
            return false;
        }
        if (((File)object).exists() && !((File)object).delete()) {
            return false;
        }
        this.save((File)object);
        return true;
    }
}

