/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.james.easydatabase.EasySharedPreference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;

public class NotifyPostUtil {
    private static final String INDICATOR_MAINTAINING = "_*maintaining*_";
    public static final String PACKAGE_PHONE_CALL = "_*phone_call*_";
    public static final String PACKAGE_SMS = "_*sms*_";
    private static final String PREF_WHITE_LIST = "white_list";
    private static final String SHARE_PREF_NAME = "notify_list";
    private static final NotifyPostUtil instance = new NotifyPostUtil();
    private final ArrayList<String> mWhiteList = new ArrayList();

    private NotifyPostUtil() {
    }

    public static NotifyPostUtil getInst() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadWhiteListFromPref(Context object) {
        object = new EasySharedPreference(object, SHARE_PREF_NAME);
        ArrayList<String> arrayList = null;
        String string2 = object.getString(PREF_WHITE_LIST, null);
        object = arrayList;
        if (string2 != null) {
            try {
                object = new JSONArray(string2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                object = arrayList;
            }
        }
        arrayList = this.mWhiteList;
        synchronized (arrayList) {
            if (object != null) {
                int n;
                for (int i = 0; i < (n = object.length()); ++i) {
                    try {
                        string2 = object.getString(i);
                        if (string2 == null || string2.isEmpty()) continue;
                        this.mWhiteList.add(string2);
                        continue;
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void SaveWhiteList(Context object) {
        SharedPreferences.Editor editor = new EasySharedPreference(object, SHARE_PREF_NAME).getEditor();
        JSONArray jSONArray = new JSONArray();
        object = this.mWhiteList;
        synchronized (object) {
            Iterator<String> iterator = this.mWhiteList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1 /* !! */ 
                    editor.putString(PREF_WHITE_LIST, jSONArray.toString());
                    editor.commit();
                    return;
                }
                String string2 = iterator.next();
                if (string2 == null || string2.isEmpty()) continue;
                jSONArray.put((Object)string2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addListening(String string2) {
        ArrayList<String> arrayList = this.mWhiteList;
        synchronized (arrayList) {
            this.mWhiteList.removeAll(Collections.singleton(null));
            boolean bl = true;
            for (String string3 : this.mWhiteList) {
                if (string3.isEmpty()) {
                    this.mWhiteList.remove(string3);
                    continue;
                }
                if (!string3.equals(string2)) continue;
                bl = false;
            }
            if (bl) {
                this.mWhiteList.add(string2);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        ArrayList<String> arrayList = this.mWhiteList;
        synchronized (arrayList) {
            this.mWhiteList.clear();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isListening(String string2) {
        boolean bl = false;
        if (string2 == null) return false;
        if (string2.isEmpty()) {
            return false;
        }
        ArrayList<String> arrayList = this.mWhiteList;
        synchronized (arrayList) {
            Iterator<String> iterator = this.mWhiteList.iterator();
            do {
                boolean bl2 = bl;
                if (!iterator.hasNext()) return bl2;
            } while (!string2.contains(iterator.next()));
            return true;
        }
    }

    public boolean isNewWhiteList() {
        return this.isListening(INDICATOR_MAINTAINING) ^ true;
    }

    public boolean isPhoneCallListening() {
        return this.isListening(PACKAGE_PHONE_CALL);
    }

    public boolean isSMSListening() {
        return this.isListening(PACKAGE_SMS);
    }

    public void loadMaintainedWhiteList(Context context) {
        this.mWhiteList.clear();
        this.loadWhiteListFromPref(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeListening(String string2) {
        ArrayList<String> arrayList = this.mWhiteList;
        synchronized (arrayList) {
            this.mWhiteList.removeAll(Collections.singleton(null));
            if (string2 != null && !string2.isEmpty()) {
                for (String string3 : this.mWhiteList) {
                    if (!string3.equals(string2)) continue;
                    this.mWhiteList.remove(string3);
                    break;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startTrace(Context context) {
        ArrayList<String> arrayList = this.mWhiteList;
        synchronized (arrayList) {
            this.mWhiteList.clear();
            this.mWhiteList.add(INDICATOR_MAINTAINING);
            return;
        }
    }
}

