/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.os.Environment;
import android.os.StatFs;

public class PhoneSpaceSizeUtil {
    public static boolean externalMemoryAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String formatSize(long l) {
        String string2;
        if (l >= 1024L) {
            if ((l /= 1024L) >= 1024L) {
                l /= 1024L;
                string2 = "MB";
            } else {
                string2 = "KB";
            }
        } else {
            string2 = null;
        }
        StringBuilder stringBuilder = new StringBuilder(Long.toString(l));
        for (int i = stringBuilder.length() - 3; i > 0; i -= 3) {
            stringBuilder.insert(i, ',');
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String getAvailableExternalMemorySize() {
        if (PhoneSpaceSizeUtil.externalMemoryAvailable()) {
            StatFs statFs = new StatFs(Environment.getExternalStorageDirectory().getPath());
            long l = statFs.getBlockSizeLong();
            return PhoneSpaceSizeUtil.formatSize(statFs.getAvailableBlocksLong() * l);
        }
        return "ERROR";
    }

    public static String getAvailableInternalMemorySize() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        long l = statFs.getBlockSizeLong();
        return PhoneSpaceSizeUtil.formatSize(statFs.getAvailableBlocksLong() * l);
    }

    public static String getTotalExternalMemorySize() {
        if (PhoneSpaceSizeUtil.externalMemoryAvailable()) {
            StatFs statFs = new StatFs(Environment.getExternalStorageDirectory().getPath());
            long l = statFs.getBlockSizeLong();
            return PhoneSpaceSizeUtil.formatSize(statFs.getBlockCountLong() * l);
        }
        return "ERROR";
    }

    public static String getTotalInternalMemorySize() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        long l = statFs.getBlockSizeLong();
        return PhoneSpaceSizeUtil.formatSize(statFs.getBlockCountLong() * l);
    }
}

