/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.content.Context;
import com.brytonsport.active.utils.JsonUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.i18N;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SettingLanguageUtil {
    public static final String DEVICE_CURRENT_LANGUAGE = "cur_lang";
    public static final String DEVICE_LANG_VER = "lang_ver";
    public static final String DEVICE_MODEL = "model";
    public static final String MAPPING_LANG_ID = "id";
    public static final String MAPPING_LANG_TEXT = "text";
    public static final String PAGE_FROM_APP_LANGUAGE = "app_language";
    public static final String PAGE_FROM_DEVICE_LANGUAGE = "device_language";
    public static final String PAGE_FROM_KEY = "languagePageFrom";
    public static final String PAGE_FROM_VOICE_LANGUAGE = "voice_language";
    public static Map<String, String> appLangMap = new HashMap<String, String>();
    public static Map<String, String> device320LangMap;
    public static DeviceLangMap deviceLangMap;
    public static Map<String, String> gridAppLangMap;
    public static Map<String, String> voiceLangMap;

    static {
        voiceLangMap = new HashMap<String, String>();
        device320LangMap = new HashMap<String, String>();
        gridAppLangMap = null;
        deviceLangMap = new DeviceLangMap();
    }

    public static String getAppGridJSLangId() {
        Object object = SettingLanguageUtil.getAppLanguageId();
        if (gridAppLangMap.get(object) == null) {
            object = ((String[])(object = object.split("-"))).length > 0 && gridAppLangMap.get(object[0]) != null ? object[0] : "en";
        }
        return gridAppLangMap.get(object);
    }

    public static String getAppLanguageId() {
        String string2;
        String string3 = string2 = (String)ProfileUtil.getInstance().get("setting_app_lang");
        if (string2.isEmpty()) {
            string3 = i18N.getCurrentLanguage();
        }
        return string3;
    }

    public static String getAppMappingDefaultVoiceLang(String object, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONObject jSONObject2;
            jSONObject = jSONObject2 = new JSONObject(JsonUtil.readJsonFile(2131689506));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (!jSONObject.has((String)object)) {
            object = ((String[])(object = object.split("-"))).length > 0 && jSONObject.has(object[0]) ? object[0] : "en";
        }
        try {
            object = jSONObject.getJSONObject((String)object).getString(string2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            object = "";
        }
        return object;
    }

    public static String getDeviceLangMapKeyByValue(String string2) {
        if (deviceLangMap.getMap().size() > 0) {
            return SettingLanguageUtil.getKeyByValue(deviceLangMap.getMap(), string2);
        }
        return "";
    }

    public static String getGoogleSearchApiLangCode() {
        String[] stringArray;
        String string2 = SettingLanguageUtil.getAppLanguageId();
        Object object = stringArray = SettingLanguageUtil.getMappingLangCode(string2);
        if (stringArray.isEmpty()) {
            object = string2.split("-");
            object = ((String[])object).length > 0 && !SettingLanguageUtil.getMappingLangCode(object[0]).isEmpty() ? object[0] : "en";
        }
        return object;
    }

    public static <T, E> T getKeyByValue(Map<T, E> entry2, E e) {
        for (Map.Entry<T, E> entry2 : entry2.entrySet()) {
            if (!Objects.equals(e, entry2.getValue())) continue;
            return (T)entry2.getKey();
        }
        return null;
    }

    public static String getMappingLangCode(String string2) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 115813762: {
                if (!string2.equals("zh-TW")) break;
                n2 = 13;
                break;
            }
            case 115813226: {
                if (!string2.equals("zh-CN")) break;
                n2 = 12;
                break;
            }
            case 3645: {
                if (!string2.equals("ro")) break;
                n2 = 11;
                break;
            }
            case 3588: {
                if (!string2.equals("pt")) break;
                n2 = 10;
                break;
            }
            case 3580: {
                if (!string2.equals("pl")) break;
                n2 = 9;
                break;
            }
            case 3518: {
                if (!string2.equals("nl")) break;
                n2 = 8;
                break;
            }
            case 3428: {
                if (!string2.equals("ko")) break;
                n2 = 7;
                break;
            }
            case 3383: {
                if (!string2.equals("ja")) break;
                n2 = 6;
                break;
            }
            case 3371: {
                if (!string2.equals("it")) break;
                n2 = 5;
                break;
            }
            case 3341: {
                if (!string2.equals("hu")) break;
                n2 = 4;
                break;
            }
            case 3276: {
                if (!string2.equals("fr")) break;
                n2 = 3;
                break;
            }
            case 3246: {
                if (!string2.equals("es")) break;
                n2 = 2;
                break;
            }
            case 3241: {
                if (!string2.equals("en")) break;
                n2 = 1;
                break;
            }
            case 3201: {
                if (!string2.equals("de")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                return "";
            }
            case 13: {
                return "zh-TW";
            }
            case 12: {
                return "zh-CN";
            }
            case 11: {
                return "ro";
            }
            case 10: {
                return "pt";
            }
            case 9: {
                return "pl";
            }
            case 8: {
                return "nl";
            }
            case 7: {
                return "ko";
            }
            case 6: {
                return "ja";
            }
            case 5: {
                return "it";
            }
            case 4: {
                return "hu";
            }
            case 3: {
                return "fr";
            }
            case 2: {
                return "es";
            }
            case 1: {
                return "en";
            }
            case 0: 
        }
        return "de";
    }

    public static String getRider320LangKeyByServerStr(String string2) {
        if (device320LangMap.size() == 0) {
            JSONArray jSONArray;
            JSONArray jSONArray2 = new JSONArray();
            try {
                jSONArray2 = jSONArray = new JSONArray(JsonUtil.readJsonFile(2131689475));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            for (int i = 0; i < jSONArray2.length(); ++i) {
                try {
                    jSONArray = jSONArray2.getJSONObject(i);
                    device320LangMap.put(jSONArray.getString("serverStr"), jSONArray.getString("key"));
                    continue;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
        return device320LangMap.get(string2);
    }

    public static String getVoiceLanguageId() {
        String string2;
        String string3 = string2 = (String)ProfileUtil.getInstance().get("setting_voice_lang_id");
        if (string2.isEmpty()) {
            string3 = (String)ProfileUtil.getInstance().get("setting_app_lang");
            string3 = string3.isEmpty() ? SettingLanguageUtil.getAppMappingDefaultVoiceLang(i18N.getCurrentLanguage(), MAPPING_LANG_ID) : SettingLanguageUtil.getAppMappingDefaultVoiceLang(string3, MAPPING_LANG_ID);
        }
        return string3;
    }

    public static String getVoiceLanguageKey() {
        String string2;
        String string3 = string2 = (String)ProfileUtil.getInstance().get("setting_voice_lang_key");
        if (string2.isEmpty()) {
            string3 = (String)ProfileUtil.getInstance().get("setting_app_lang");
            string3 = string3.isEmpty() ? SettingLanguageUtil.getAppMappingDefaultVoiceLang(i18N.getCurrentLanguage(), MAPPING_LANG_TEXT) : SettingLanguageUtil.getAppMappingDefaultVoiceLang(string3, MAPPING_LANG_TEXT);
        }
        return string3;
    }

    public static boolean isAppLanguageChoice(String string2) {
        String string3 = appLangMap.get(string2);
        string2 = (String)ProfileUtil.getInstance().get("setting_app_lang");
        return string2.isEmpty() ? string3.equals("default") : string3.equals(string2);
    }

    public static boolean isDeviceLanguageChoice(String string2, String string3) {
        return string2.equals(string3);
    }

    public static boolean isLanguageChoice(String string2, String string3, String string4) {
        if (string3.equals(PAGE_FROM_APP_LANGUAGE)) {
            return SettingLanguageUtil.isAppLanguageChoice(string2);
        }
        if (string3.equals(PAGE_FROM_VOICE_LANGUAGE)) {
            return SettingLanguageUtil.isVoiceLanguageChoice(string2);
        }
        return SettingLanguageUtil.isDeviceLanguageChoice(string2, string4);
    }

    public static boolean isVoiceLanguageChoice(String string2) {
        return string2.equals(SettingLanguageUtil.getVoiceLanguageKey());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadGridJSLang(Context object) {
        void var0_3;
        gridAppLangMap = new HashMap<String, String>();
        try {
            int n;
            object = object.getResources().openRawResource(0x7F0F0000);
            Object object2 = new StringWriter();
            Object object3 = new char[1024];
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((n = bufferedReader.read((char[])object3)) != -1) {
                ((Writer)object2).write((char[])object3, 0, n);
            }
            ((InputStream)object).close();
            object = object2.toString();
            inputStreamReader = new JSONArray((String)object);
            object = 0;
            while ((Integer)object < inputStreamReader.length()) {
                object2 = inputStreamReader.getJSONObject((Integer)object);
                object3 = object2.getString(MAPPING_LANG_ID);
                object2 = object2.getString("serverStr");
                gridAppLangMap.put((String)object3, (String)object2);
                object = (Integer)object + 1;
            }
            return;
        }
        catch (IOException iOException) {
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        var0_3.printStackTrace();
    }

    public static class DeviceLangMap {
        private Map<String, String> deviceLangMap = new HashMap<String, String>();
        private ArrayList<String> keys = new ArrayList();
        private String modelName = "";

        public ArrayList<String> getKeys() {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator<Map.Entry<String, String>> iterator = this.deviceLangMap.entrySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().getKey());
            }
            return arrayList;
        }

        public Map<String, String> getMap() {
            return this.deviceLangMap;
        }

        public String getModelName() {
            return this.modelName;
        }

        public ArrayList<String> getOrderedKeys() {
            return this.keys;
        }

        public void setMap(String cloneable, Map<String, String> map, ArrayList<String> arrayList) {
            block6: {
                block5: {
                    String string2 = cloneable;
                    if (cloneable == null) {
                        string2 = "";
                    }
                    this.modelName = string2;
                    cloneable = map;
                    if (map == null) {
                        cloneable = new HashMap();
                    }
                    this.deviceLangMap = cloneable;
                    if (cloneable.size() <= 0) break block5;
                    cloneable = arrayList;
                    if (arrayList != null) break block6;
                }
                cloneable = new ArrayList();
            }
            this.keys = cloneable;
        }
    }
}

