/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.content.Context;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewOutlineProvider;
import com.james.utils.MonitorUtils;

public class ShapeUtils {
    public static void getDiamond(View view) {
        if (Build.VERSION.SDK_INT >= 21) {
            view.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    if (Build.VERSION.SDK_INT >= 30) {
                        outline.setPath(new Path());
                    } else {
                        outline.setOval(new Rect(0, 0, view.getWidth(), view.getHeight()));
                    }
                }
            });
            view.setClipToOutline(true);
        }
    }

    public static void getOval(View view) {
        if (Build.VERSION.SDK_INT >= 21) {
            view.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setOval(new Rect(0, 0, view.getWidth(), view.getHeight()));
                }
            });
            view.setClipToOutline(true);
        }
    }

    public static void getRoundedCorner(View view) {
        ShapeUtils.getRoundedCorner(view, 5);
    }

    public static void getRoundedCorner(View view, final int n) {
        if (Build.VERSION.SDK_INT >= 21) {
            view.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setRoundRect(new Rect(0, 0, view.getWidth(), view.getHeight()), (float)MonitorUtils.dp2px((Context)view.getContext(), (float)n));
                }
            });
            view.setClipToOutline(true);
        }
    }

    public static void getRoundedCornerInPixel(View view, final int n) {
        if (Build.VERSION.SDK_INT >= 21) {
            view.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setRoundRect(new Rect(0, 0, view.getWidth(), view.getHeight()), (float)n);
                }
            });
            view.setClipToOutline(true);
        }
    }
}

