/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.LabeledIntent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcelable;
import android.text.Html;
import androidx.core.content.FileProvider;
import com.brytonsport.active.utils.ToastUtil;
import com.brytonsport.active.utils.i18N;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;

public class SocialSharingUtil {
    private static final Map<String, String> MIME_Map;
    private static SocialSharingUtil instance;

    static {
        instance = new SocialSharingUtil();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        MIME_Map = hashMap;
        hashMap.put("3gp", "video/3gpp");
        hashMap.put("apk", "application/vnd.android.package-archive");
        hashMap.put("asf", "video/x-ms-asf");
        hashMap.put("avi", "video/x-msvideo");
        hashMap.put("bin", "application/octet-stream");
        hashMap.put("bmp", "image/bmp");
        hashMap.put("c", "text/plain");
        hashMap.put("class", "application/octet-stream");
        hashMap.put("conf", "text/plain");
        hashMap.put("cpp", "text/plain");
        hashMap.put("doc", "application/msword");
        hashMap.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        hashMap.put("xls", "application/vnd.ms-excel");
        hashMap.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        hashMap.put("exe", "application/octet-stream");
        hashMap.put("gif", "image/gif");
        hashMap.put("gtar", "application/x-gtar");
        hashMap.put("gz", "application/x-gzip");
        hashMap.put("h", "text/plain");
        hashMap.put("htm", "text/html");
        hashMap.put("html", "text/html");
        hashMap.put("jar", "application/java-archive");
        hashMap.put("java", "text/plain");
        hashMap.put("jpeg", "image/jpeg");
        hashMap.put("jpg", "image/*");
        hashMap.put("js", "application/x-javascript");
        hashMap.put("log", "text/plain");
        hashMap.put("m3u", "audio/x-mpegurl");
        hashMap.put("m4a", "audio/mp4a-latm");
        hashMap.put("m4b", "audio/mp4a-latm");
        hashMap.put("m4p", "audio/mp4a-latm");
        hashMap.put("m4u", "video/vnd.mpegurl");
        hashMap.put("m4v", "video/x-m4v");
        hashMap.put("mov", "video/quicktime");
        hashMap.put("mp2", "audio/x-mpeg");
        hashMap.put("mp3", "audio/x-mpeg");
        hashMap.put("mp4", "video/mp4");
        hashMap.put("mpc", "application/vnd.mpohun.certificate");
        hashMap.put("mpe", "video/mpeg");
        hashMap.put("mpeg", "video/mpeg");
        hashMap.put("mpg", "video/mpeg");
        hashMap.put("mpg4", "video/mp4");
        hashMap.put("mpga", "audio/mpeg");
        hashMap.put("msg", "application/vnd.ms-outlook");
        hashMap.put("ogg", "audio/ogg");
        hashMap.put("pdf", "application/pdf");
        hashMap.put("png", "image/png");
        hashMap.put("pps", "application/vnd.ms-powerpoint");
        hashMap.put("ppt", "application/vnd.ms-powerpoint");
        hashMap.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        hashMap.put("prop", "text/plain");
        hashMap.put("rc", "text/plain");
        hashMap.put("rmvb", "audio/x-pn-realaudio");
        hashMap.put("rtf", "application/rtf");
        hashMap.put("sh", "text/plain");
        hashMap.put("tar", "application/x-tar");
        hashMap.put("tgz", "application/x-compressed");
        hashMap.put("txt", "text/plain");
        hashMap.put("wav", "audio/x-wav");
        hashMap.put("wma", "audio/x-ms-wma");
        hashMap.put("wmv", "audio/x-ms-wmv");
        hashMap.put("wps", "application/vnd.ms-works");
        hashMap.put("xml", "text/plain");
        hashMap.put("z", "application/x-compress");
        hashMap.put("zip", "application/x-zip-compressed");
        hashMap.put("", "*/*");
    }

    private SocialSharingUtil() {
    }

    public static SocialSharingUtil getInst() {
        return instance;
    }

    private String getMIMEType(String string2) {
        block1: {
            int n = string2.lastIndexOf(".");
            String string3 = "*/*";
            if (n == -1) {
                return "*/*";
            }
            string2 = string2.substring(n + 1).toLowerCase();
            if ((string2 = MIME_Map.get(string2)) != null) break block1;
            string2 = string3;
        }
        return string2;
    }

    private boolean notEmpty(String string2) {
        boolean bl = string2 != null && !"".equals(string2) && !"null".equalsIgnoreCase(string2);
        return bl;
    }

    private String[] toStringArray(JSONArray jSONArray) throws JSONException {
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    public boolean share(Context context, String object, File file) {
        if (file.exists()) {
            Uri uri = FileProvider.getUriForFile(context, "com.brytonsport.active.fileprovider", file);
            Intent intent = new Intent("android.intent.action.SEND");
            intent.setType(this.getMIMEType(file.getName()));
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            file = Intent.createChooser((Intent)intent, (CharSequence)object);
            object = context.getPackageManager().queryIntentActivities((Intent)file, 65536).iterator();
            while (object.hasNext()) {
                context.grantUriPermission(((ResolveInfo)object.next()).activityInfo.packageName, uri, 3);
            }
            file.setFlags(0x10000000);
            context.startActivity((Intent)file);
            return true;
        }
        ToastUtil.showToast(context.getApplicationContext(), "File does not exist.");
        return false;
    }

    public void sharePlantripUrl(Context context, String string2) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.SUBJECT", i18N.get("B_Share"));
        intent.putExtra("android.intent.extra.TEXT", string2);
        string2 = Intent.createChooser((Intent)intent, (CharSequence)i18N.get("B_Share"));
        string2.setFlags(0x10000000);
        context.startActivity((Intent)string2);
    }

    public void shareTextUrl(Context context, String string2) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.SUBJECT", i18N.get("InvitedtojoinGR_1"));
        intent.putExtra("android.intent.extra.TEXT", string2);
        string2 = Intent.createChooser((Intent)intent, (CharSequence)i18N.get("GroupCode"));
        string2.setFlags(0x10000000);
        context.startActivity((Intent)string2);
    }

    public boolean shareViaMail(Context context, String object, String object2, String object3, File iterator) {
        Object object4 = new Intent("android.intent.action.SENDTO");
        if (this.notEmpty((String)object2)) {
            object4.putExtra("android.intent.extra.SUBJECT", (String)object2);
        }
        if (this.notEmpty((String)object3)) {
            if (Pattern.compile(".*\\<[^>]+>.*", 32).matcher((CharSequence)object3).matches()) {
                object4.putExtra("android.intent.extra.TEXT", (CharSequence)Html.fromHtml((String)object3));
                object4.setType("text/html");
            } else {
                object4.putExtra("android.intent.extra.TEXT", (String)object3);
                object4.setType("text/plain");
            }
        }
        object2 = new ArrayList();
        if (iterator != null) {
            if (((File)((Object)iterator)).exists()) {
                ((ArrayList)object2).add(FileProvider.getUriForFile(context, "com.brytonsport.active.fileprovider", (File)((Object)iterator)));
            } else {
                ToastUtil.showToast(context.getApplicationContext(), "File does not exist.");
            }
        }
        if (((ArrayList)object2).size() > 0) {
            object4.putExtra("android.intent.extra.STREAM", (Serializable)object2);
        }
        object4.setData(Uri.parse((String)"mailto:"));
        iterator = context.getPackageManager().queryIntentActivities(object4, 0);
        object3 = new ArrayList();
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            iterator = (ResolveInfo)iterator2.next();
            object4.setAction("android.intent.action.SEND_MULTIPLE");
            object4.setType("application/octet-stream");
            ((ArrayList)object3).add(new LabeledIntent(object4, ((ResolveInfo)iterator).activityInfo.packageName, iterator.loadLabel(context.getPackageManager()), ((ResolveInfo)iterator).icon));
        }
        if (((ArrayList)object3).size() > 0) {
            object3 = Intent.createChooser((Intent)object4, (CharSequence)object);
            iterator = context.getPackageManager().queryIntentActivities((Intent)object3, 0).iterator();
            while (iterator.hasNext()) {
                object4 = ((ResolveInfo)iterator.next()).activityInfo.packageName;
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    context.grantUriPermission((String)object4, (Uri)object.next(), 3);
                }
            }
            object3.setFlags(0x10000000);
            context.startActivity((Intent)object3);
            return true;
        }
        ToastUtil.showToast(context.getApplicationContext(), "Could not find any Mail app");
        return false;
    }
}

