/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.text.format.DateFormat;
import android.util.Log;
import com.brytonsport.active.base.App;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtilByLee {
    public static String getAllDate(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l * 1000L);
        return DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (Calendar)calendar).toString();
    }

    public static int getCurrentMonth() {
        return Calendar.getInstance().get(2);
    }

    public static int getCurrentUtcTime() {
        return (int)(new Date().getTime() / 1000L);
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static String getDate(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l * 1000L);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        return DateFormat.format((CharSequence)"yyyy-MMM", (Calendar)calendar).toString();
    }

    public static String getDateFormatForResultList(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l * 1000L);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        return DateFormat.format((CharSequence)"yyyy/MM/dd", (Calendar)calendar).toString();
    }

    public static String getDateHour(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l * 1000L);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        return DateFormat.format((CharSequence)"ddHHmm", (Calendar)calendar).toString();
    }

    public static String getDateTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l * 1000L);
        return DateFormat.format((CharSequence)"HH:mm:ss", (Calendar)calendar).toString();
    }

    public static int getFirstDayTimeStampByWeek(Date cloneable) {
        Comparable<Calendar> comparable = Calendar.getInstance();
        ((Calendar)comparable).setTime((Date)cloneable);
        ((Calendar)comparable).set(11, 0);
        ((Calendar)comparable).set(12, 0);
        ((Calendar)comparable).set(13, 0);
        if (App.isFirstDayMonday()) {
            ((Calendar)comparable).add(5, 2 - ((Calendar)comparable).get(7));
        } else {
            ((Calendar)comparable).add(5, 1 - ((Calendar)comparable).get(7));
        }
        cloneable = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        comparable = ((Calendar)comparable).getTime();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("getFirstDayTimeStampByWeek: ");
        stringBuilder.append(((java.text.DateFormat)cloneable).format((Date)comparable));
        stringBuilder.append(", timestamp: ");
        stringBuilder.append(TimeUtilByLee.millisecondToSeconds(((Date)comparable).getTime()));
        Log.d((String)"TAG", (String)stringBuilder.toString());
        return TimeUtilByLee.millisecondToSeconds(((Date)comparable).getTime());
    }

    public static int getFirstDayTimeStampByYearMonth(int n, int n2) {
        Comparable<Calendar> comparable = Calendar.getInstance();
        ((Calendar)comparable).set(1, n);
        ((Calendar)comparable).set(2, n2);
        ((Calendar)comparable).set(5, 1);
        ((Calendar)comparable).set(11, 0);
        ((Calendar)comparable).set(12, 0);
        ((Calendar)comparable).set(13, 0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        comparable = ((Calendar)comparable).getTime();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("getFirstDayTimeStampByYearMonth: ");
        stringBuilder.append(simpleDateFormat.format((Date)comparable));
        stringBuilder.append(", timestamp: ");
        stringBuilder.append(TimeUtilByLee.millisecondToSeconds(((Date)comparable).getTime()));
        Log.d((String)"TAG", (String)stringBuilder.toString());
        return TimeUtilByLee.millisecondToSeconds(((Date)comparable).getTime());
    }

    public static int getLastDayByMonth(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, n2 + 1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.add(13, -1);
        return calendar.get(5);
    }

    public static int getLastDayTimeStampByMonth(int n, int n2) {
        Comparable<Calendar> comparable = Calendar.getInstance();
        ((Calendar)comparable).set(1, n);
        ((Calendar)comparable).set(2, n2 + 1);
        ((Calendar)comparable).set(5, 1);
        ((Calendar)comparable).set(11, 0);
        ((Calendar)comparable).set(12, 0);
        ((Calendar)comparable).set(13, 0);
        ((Calendar)comparable).add(13, -1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        comparable = ((Calendar)comparable).getTime();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("getLastDayTimeStampByMonth: ");
        stringBuilder.append(simpleDateFormat.format((Date)comparable));
        stringBuilder.append(", timestamp: ");
        stringBuilder.append(TimeUtilByLee.millisecondToSeconds(((Date)comparable).getTime()));
        Log.d((String)"TAG", (String)stringBuilder.toString());
        return TimeUtilByLee.millisecondToSeconds(((Date)comparable).getTime());
    }

    public static int getLastDayTimeStampByWeek(Date cloneable) {
        Comparable<Calendar> comparable = Calendar.getInstance();
        ((Calendar)comparable).setTime((Date)cloneable);
        ((Calendar)comparable).set(11, 0);
        ((Calendar)comparable).set(12, 0);
        ((Calendar)comparable).set(13, 0);
        if (App.isFirstDayMonday()) {
            ((Calendar)comparable).add(5, 2 - ((Calendar)comparable).get(7));
        } else {
            ((Calendar)comparable).add(5, 1 - ((Calendar)comparable).get(7));
        }
        ((Calendar)comparable).add(7, 7);
        ((Calendar)comparable).add(13, -1);
        cloneable = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = ((Calendar)comparable).getTime();
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append("getLastDayTimeStampByWeek: ");
        ((StringBuilder)comparable).append(((java.text.DateFormat)cloneable).format(date));
        ((StringBuilder)comparable).append(", timestamp: ");
        ((StringBuilder)comparable).append(TimeUtilByLee.millisecondToSeconds(date.getTime()));
        Log.d((String)"TAG", (String)((StringBuilder)comparable).toString());
        return TimeUtilByLee.millisecondToSeconds(date.getTime());
    }

    public static int getLastDayTimeStampByYearMonth(int n, int n2) {
        Comparable<Calendar> comparable = Calendar.getInstance();
        ((Calendar)comparable).set(1, n + 1);
        ((Calendar)comparable).set(2, n2);
        ((Calendar)comparable).set(5, 1);
        ((Calendar)comparable).set(11, 0);
        ((Calendar)comparable).set(12, 0);
        ((Calendar)comparable).set(13, 0);
        ((Calendar)comparable).add(13, -1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        comparable = ((Calendar)comparable).getTime();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("getLastDayTimeStampByYearMonth: ");
        stringBuilder.append(simpleDateFormat.format((Date)comparable));
        stringBuilder.append(", timestamp: ");
        stringBuilder.append(TimeUtilByLee.millisecondToSeconds(((Date)comparable).getTime()));
        Log.d((String)"TAG", (String)stringBuilder.toString());
        return TimeUtilByLee.millisecondToSeconds(((Date)comparable).getTime());
    }

    public static String getMillon(long l) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(l);
    }

    public static Long getTimeStampPlusZoneBySec(long l) {
        Object object = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        ((java.text.DateFormat)object).setTimeZone(TimeZone.getDefault());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        object = ((java.text.DateFormat)object).format(new Date(l));
        try {
            l = simpleDateFormat.parse((String)object).getTime() / 1000L;
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            l = 0L;
        }
        return l;
    }

    public static String getYearDate(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l * 1000L);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        return DateFormat.format((CharSequence)"yyyy/MM/dd", (Calendar)calendar).toString();
    }

    public static int millisecondToSeconds(long l) {
        return (int)(l / 1000L);
    }

    public static String millisecondToTime(long l) {
        return TimeUtilByLee.secondsToTime((int)(l / 1000L));
    }

    public static String secondsToTime(int n) {
        int n2;
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 0;
        if (n >= 60) {
            n3 = n / 60;
            n2 = n % 60;
            n = n3;
        } else {
            n3 = 0;
            n2 = n;
            n = n3;
        }
        n3 = n;
        if (n >= 60) {
            n4 = n / 60;
            n3 = n % 60;
        }
        if (n4 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n4);
        stringBuilder.append(":");
        if (n3 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n3);
        stringBuilder.append(":");
        if (n2 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }
}

