/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import android.text.TextUtils;
import com.brytonsport.active.utils.i18N;
import com.google.android.gms.common.util.Strings;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeUtils {
    public static long DAY = 86400000L;
    public static long WEEK = 604800000L;

    public static boolean checkBirthday(String object) {
        Cloneable cloneable = new SimpleDateFormat("yyyy/MM/dd");
        try {
            object = cloneable.parse((String)object);
            cloneable = new Date();
            boolean bl = ((Date)object).before((Date)cloneable);
            return bl;
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return false;
        }
    }

    public static Date getDate(String object) {
        if (!Strings.isEmptyOrWhitespace((String)object) && ((String)object).contains("/")) {
            String[] stringArray = ((String)object).split("/");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
            if (stringArray.length == 3) {
                try {
                    object = simpleDateFormat.parse((String)object);
                    if (object != null) {
                        return object;
                    }
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
        }
        return new Date();
    }

    public static String getDisplayLast(long l) {
        l = System.currentTimeMillis() / 1000L - l / 1000L;
        if (l > 3599L) {
            long l2 = (l /= 60L) / 60L;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(i18N.get("Updatetimes"));
            stringBuilder.append(" ");
            stringBuilder.append(l2);
            stringBuilder.append(" ");
            stringBuilder.append(i18N.get("h"));
            stringBuilder.append(" ");
            stringBuilder.append(l % 60L);
            stringBuilder.append(i18N.get("UnitMins"));
            return stringBuilder.toString();
        }
        if (l > 59L) {
            long l3 = l / 60L;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(i18N.get("Updatetimes"));
            stringBuilder.append(" ");
            stringBuilder.append(l3);
            stringBuilder.append(" ");
            stringBuilder.append(i18N.get("UnitMins"));
            stringBuilder.append(" ");
            stringBuilder.append(l % 60L);
            stringBuilder.append(i18N.get("UnitSecs"));
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(i18N.get("Updatetimes"));
        stringBuilder.append(l);
        stringBuilder.append(i18N.get("UnitSecs"));
        return stringBuilder.toString();
    }

    public static String getDisplayLastUpdateTimeString(int n) {
        if (n > 59) {
            int n2 = n / 60;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(i18N.get("Updatetimes"));
            stringBuilder.append(" ");
            stringBuilder.append(n2);
            stringBuilder.append(" ");
            stringBuilder.append(i18N.get("h"));
            stringBuilder.append(" ");
            stringBuilder.append(n % 60);
            stringBuilder.append(i18N.get("UnitMins"));
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(i18N.get("Updatetimes"));
        stringBuilder.append(" ");
        stringBuilder.append(n);
        stringBuilder.append(i18N.get("UnitMins"));
        return stringBuilder.toString();
    }

    public static String hmsToMSTime(String object) {
        String string2 = object;
        if (object == null) {
            string2 = "00:00:00";
        }
        try {
            object = new SimpleDateFormat("HH:mm:ss");
            Date date = ((DateFormat)object).parse(string2);
            object = new SimpleDateFormat("mm:ss");
            if (!TextUtils.isEmpty((CharSequence)string2) && string2.substring(0, 2).equals("00")) {
                object = ((DateFormat)object).format(date);
                return object;
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return string2;
    }

    public static String msToDate(long l) {
        return new SimpleDateFormat("yyyy/MM/dd").format(l);
    }

    public static String msToTime(long l) {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        DecimalFormat decimalFormat2 = new DecimalFormat("#0");
        long l2 = l % 60000L / 1000L;
        long l3 = l % 3600000L / 60000L;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(decimalFormat2.format(l /= 3600000L));
        stringBuilder.append(":");
        stringBuilder.append(decimalFormat.format(l3));
        stringBuilder.append(":");
        stringBuilder.append(decimalFormat.format(l2));
        return stringBuilder.toString();
    }

    public static long timeTosMs(String stringArray) {
        stringArray = stringArray.split(":");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        return (long)(n * 60 * 60) * 1000L + (long)(n2 * 60) * 1000L + (long)n3 * 1000L;
    }
}

