/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import com.brytonsport.active.base.App;
import com.brytonsport.active.db.result.entity.ActivityEntity;
import com.brytonsport.active.utils.AppUnitUtil;
import com.brytonsport.active.utils.NumberFormatUtil;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.vm.base.TimeUnit;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class Utils {
    public static final String KM = "km";
    public static final String MILE = "mi";

    public static float convertCM(float f) {
        if (App.profile.timeUnit.isMetricUnit()) {
            return f;
        }
        return (float)NumberFormatUtil.doubleValueFormatDigit(f * 0.033f, 1);
    }

    public static float convertKG(float f) {
        if (App.profile.timeUnit.isMetricUnit()) {
            return f;
        }
        return Utils.trimTo2(f * 2.2f);
    }

    public static double convertKM(double d) {
        if (App.profile.timeUnit.isMetricUnit()) {
            return d;
        }
        return Utils.trimTo2New(d * 0.6214);
    }

    public static float convertKM(float f) {
        TimeUnit timeUnit = App.profile.timeUnit;
        if (AppUnitUtil.isAppUnitMetric()) {
            return f;
        }
        return Utils.trimTo2(f * 0.6214f);
    }

    public static float convertKMByImperial(float f) {
        float f2 = f;
        if (App.profile.timeUnit.isMetricUnit()) {
            f2 = Utils.trimTo2(f / 0.62137f);
        }
        return f2;
    }

    public static String convertKMStr(float f) {
        TimeUnit timeUnit = App.profile.timeUnit;
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        if (timeUnit.isMetricUnit()) {
            return decimalFormat.format(f);
        }
        return decimalFormat.format(Utils.trimTo2(f * 0.6214f));
    }

    public static float convertKmH(float f) {
        if (App.profile.timeUnit.isMetricUnit()) {
            return f;
        }
        return AppUnitUtil.paceKmToMi(f);
    }

    public static double convertM(double d) {
        if (App.profile.timeUnit.isMetricUnit()) {
            return d;
        }
        return AppUnitUtil.meterToFeet(d);
    }

    public static float convertM(float f) {
        if (App.profile.timeUnit.isMetricUnit()) {
            return f;
        }
        return AppUnitUtil.meterToFeet(f);
    }

    public static String convertMStr(float f) {
        TimeUnit timeUnit = App.profile.timeUnit;
        DecimalFormat decimalFormat = new DecimalFormat("#");
        if (timeUnit.isMetricUnit()) {
            return decimalFormat.format(f);
        }
        return decimalFormat.format(Utils.trimTo2(f * 0.6214f));
    }

    public static float convertTemperatureC(float f) {
        if (App.profile.timeUnit.isMetricUnit()) {
            return f;
        }
        return AppUnitUtil.temperatureCToF(f);
    }

    public static Long getDisplayLocalStartTime(ActivityEntity serializable) {
        Long l;
        Long l2 = 0L;
        Serializable serializable2 = l = serializable.getLocalStartTime();
        if (l == null) {
            if ((serializable = serializable.getStartTime()) == null) {
                serializable = l2;
            }
            serializable2 = serializable;
        }
        return serializable2;
    }

    public static long getFileSize(String object) {
        if (((File)(object = new File((String)object))).exists() && ((File)object).isFile()) {
            return ((File)object).length();
        }
        return -1L;
    }

    public static String getUnitByBpm() {
        return i18N.get("bpm");
    }

    public static String getUnitByCM() {
        TimeUnit timeUnit = App.profile != null ? App.profile.timeUnit : new TimeUnit();
        if (timeUnit.isMetricUnit()) {
            return i18N.get("cm");
        }
        return i18N.get("ft");
    }

    public static String getUnitByKG() {
        if (App.profile.timeUnit.isMetricUnit()) {
            return i18N.get("kg");
        }
        return i18N.get("lb");
    }

    public static String getUnitByKM() {
        if (App.profile.timeUnit.isMetricUnit()) {
            return i18N.get(KM);
        }
        return i18N.get(MILE);
    }

    public static String getUnitByKcal() {
        return i18N.get("Kcal");
    }

    public static String getUnitByKmH() {
        if (App.profile.timeUnit.isMetricUnit()) {
            return i18N.get("kmh");
        }
        return i18N.get("mih");
    }

    public static String getUnitByM() {
        if (App.profile.timeUnit.isMetricUnit()) {
            return i18N.get("meter");
        }
        return i18N.get("ft");
    }

    public static String getUnitByPower() {
        return i18N.get("watts");
    }

    public static String getUnitByRpm() {
        return i18N.get("rpm");
    }

    public static String getUnitByTemperatureC() {
        if (App.profile.timeUnit.isMetricUnit()) {
            return "\u00b0C";
        }
        return "\u00b0F";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double parseDouble(String string2, Locale locale) {
        if (string2 == null) return Double.NaN;
        if (string2.isEmpty()) {
            return Double.NaN;
        }
        try {
            return NumberFormat.getNumberInstance(locale).parse(string2).doubleValue();
        }
        catch (ParseException parseException) {
            try {
                return NumberFormat.getNumberInstance(Locale.US).parse(string2).doubleValue();
            }
            catch (ParseException parseException2) {
                return Double.NaN;
            }
        }
    }

    public static float reconvertCMStr(float f) {
        if (App.profile.timeUnit.isMetricUnit()) {
            return f;
        }
        return Utils.trimTo2(f / 0.033f);
    }

    public static float reconvertKG(float f) {
        if (App.profile.timeUnit.isMetricUnit()) {
            return f;
        }
        return Utils.trimTo2(f / 2.2f);
    }

    private static double trimTo2(double d) {
        return (float)((int)(d * 100.0)) / 100.0f;
    }

    private static float trimTo2(float f) {
        return (float)((int)(f * 100.0f)) / 100.0f;
    }

    private static double trimTo2New(double d) {
        return d * 100.0 / 100.0;
    }
}

