/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils;

import com.brytonsport.active.bleplugin.ParserUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class WavUtil {
    private static final short CHANNELS = 1;
    private static final String CODEC_NAME = "ADPCM";
    private static final byte[] IndexTable;
    private static final int SAMPLING_FREQ = 8000;
    private static final short[] StepSizeTable;
    private short adpcm_index_in = (short)0;
    private int adpcm_predsample_in = 0;
    private short index = (short)0;
    private boolean intra_flag = false;
    private int predsample = 0;

    static {
        StepSizeTable = new short[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
        IndexTable = new byte[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
    }

    private short decode(byte by) {
        int n;
        if (this.intra_flag) {
            this.predsample = this.adpcm_predsample_in;
            this.index = this.adpcm_index_in;
            this.reinit();
        }
        short[] sArray = StepSizeTable;
        short s = this.index;
        short s2 = sArray[s];
        int n2 = n = s2 >> 3;
        if ((by & 4) != 0) {
            n2 = n + s2;
        }
        n = n2;
        if ((by & 2) != 0) {
            n = n2 + (s2 >> 1);
        }
        n2 = n;
        if ((by & 1) != 0) {
            n2 = n + (s2 >> 2);
        }
        this.predsample = (by & 8) != 0 ? (this.predsample -= n2) : (this.predsample += n2);
        n = this.predsample;
        if (n > Short.MAX_VALUE) {
            this.predsample = Short.MAX_VALUE;
        } else if (n < Short.MIN_VALUE) {
            this.predsample = Short.MIN_VALUE;
        }
        by = (byte)(s + IndexTable[by]);
        this.index = by;
        if (by < 0) {
            this.index = (short)0;
        }
        if (this.index > 88) {
            this.index = (short)88;
        }
        return (short)this.predsample;
    }

    private void writeBytes(byte[] byArray, int n, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[i + n] = byArray2[i];
        }
    }

    public byte[] create(short[] sArray) {
        int n = sArray.length;
        Object object = ByteBuffer.allocate(44).order(ByteOrder.LITTLE_ENDIAN);
        int n2 = n * 2;
        object = ((ByteBuffer)object).putInt(4, n2 + 36).putInt(16, 16).putShort(20, (short)1).putShort(22, (short)1).putInt(24, 8000).putInt(28, 16000).putShort(32, (short)2).putShort(34, (short)16).putInt(40, n2).array();
        Object object2 = "RIFF".getBytes();
        this.writeBytes((byte[])object, 0, (byte[])object2);
        this.writeBytes((byte[])object, 8, "WAVE".getBytes());
        this.writeBytes((byte[])object, 12, "fmt ".getBytes());
        this.writeBytes((byte[])object, 36, "data".getBytes());
        object2 = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; n > i; ++i) {
            ((ByteBuffer)object2).putShort(sArray[i]);
        }
        return ParserUtil.joinByteArray((byte[])object, ((ByteBuffer)object2).array());
    }

    public short[] decode(byte[] byArray) {
        short[] sArray = new short[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = i * 2;
            sArray[n] = this.decode((byte)(byArray[i] & 0xF));
            sArray[n + 1] = this.decode((byte)(byArray[i] >> 4 & 0xF));
        }
        return sArray;
    }

    public void reinit() {
        this.intra_flag = false;
    }
}

