/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.utils.xml;

import android.util.Log;
import com.brytonsport.active.utils.xml.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlToJson {
    private static final String DEFAULT_CONTENT_NAME = "content";
    private static final boolean DEFAULT_EMPTY_BOOLEAN = false;
    private static final double DEFAULT_EMPTY_DOUBLE = 0.0;
    private static final int DEFAULT_EMPTY_INTEGER = 0;
    private static final long DEFAULT_EMPTY_LONG = 0L;
    private static final String DEFAULT_EMPTY_STRING = "";
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final String DEFAULT_INDENTATION = "   ";
    private static final String TAG = "XmlToJson";
    private HashMap<String, String> mAttributeNameReplacements;
    private HashMap<String, String> mContentNameReplacements;
    private HashMap<String, Class> mForceClassForPath;
    private HashSet<String> mForceListPaths;
    private HashSet<Pattern> mForceListPatterns = new HashSet();
    private String mIndentationPattern = "   ";
    private String mInputEncoding;
    private InputStream mInputStreamSource;
    private JSONObject mJsonObject;
    private HashSet<String> mSkippedAttributes = new HashSet();
    private HashSet<String> mSkippedTags = new HashSet();
    private StringReader mStringSource;

    private XmlToJson(Builder builder) {
        this.mStringSource = builder.mStringSource;
        this.mInputStreamSource = builder.mInputStreamSource;
        this.mInputEncoding = builder.mInputEncoding;
        this.mForceListPaths = builder.mForceListPaths;
        this.mForceListPatterns = builder.mForceListPatterns;
        this.mAttributeNameReplacements = builder.mAttributeNameReplacements;
        this.mContentNameReplacements = builder.mContentNameReplacements;
        this.mForceClassForPath = builder.mForceClassForPath;
        this.mSkippedAttributes = builder.mSkippedAttributes;
        this.mSkippedTags = builder.mSkippedTags;
        this.mJsonObject = this.convertToJSONObject();
    }

    private JSONObject convertTagToJson(Tag object, boolean bl) {
        Object object2;
        JSONObject jSONObject = new JSONObject();
        if (((Tag)((Object)object)).getContent() != null) {
            object2 = ((Tag)((Object)object)).getPath();
            this.putContent((String)object2, jSONObject, this.getContentNameReplacement((String)object2, DEFAULT_CONTENT_NAME), ((Tag)((Object)object)).getContent());
        }
        try {
            for (ArrayList<Tag> arrayList : ((Tag)((Object)object)).getGroupedElements().values()) {
                JSONArray jSONArray;
                if (arrayList.size() == 1) {
                    object2 = arrayList.get(0);
                    if (this.isForcedList((Tag)object2)) {
                        jSONArray = new JSONArray();
                        jSONArray.put((Object)this.convertTagToJson((Tag)object2, true));
                        jSONObject.put(((Tag)object2).getName(), (Object)jSONArray);
                        continue;
                    }
                    if (((Tag)object2).hasChildren()) {
                        jSONArray = this.convertTagToJson((Tag)object2, false);
                        jSONObject.put(((Tag)object2).getName(), (Object)jSONArray);
                        continue;
                    }
                    this.putContent(((Tag)object2).getPath(), jSONObject, ((Tag)object2).getName(), ((Tag)object2).getContent());
                    continue;
                }
                jSONArray = new JSONArray();
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    jSONArray.put((Object)this.convertTagToJson(object2.next(), true));
                }
                jSONObject.put(arrayList.get(0).getName(), (Object)jSONArray);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject convertToJSONObject() {
        void var1_4;
        try {
            Tag tag = new Tag(DEFAULT_EMPTY_STRING, "xml");
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(false);
            xmlPullParserFactory = xmlPullParserFactory.newPullParser();
            this.setInput((XmlPullParser)xmlPullParserFactory);
            int n = xmlPullParserFactory.getEventType();
            while (true) {
                if (n == 0) {
                    this.readTags(tag, (XmlPullParser)xmlPullParserFactory);
                    this.unsetInput();
                    return this.convertTagToJson(tag, false);
                }
                n = xmlPullParserFactory.next();
            }
        }
        catch (IOException iOException) {
        }
        catch (XmlPullParserException xmlPullParserException) {
            // empty catch block
        }
        var1_4.printStackTrace();
        return null;
    }

    private void format(JSONObject jSONObject, StringBuilder stringBuilder, String string2) {
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            Object object;
            Object object2 = (String)iterator.next();
            stringBuilder.append(string2);
            stringBuilder.append(this.mIndentationPattern);
            stringBuilder.append("\"");
            stringBuilder.append((String)object2);
            stringBuilder.append("\": ");
            object2 = jSONObject.opt((String)object2);
            if (object2 instanceof JSONObject) {
                object2 = (JSONObject)object2;
                stringBuilder.append(string2);
                stringBuilder.append("{\n");
                object = new StringBuilder();
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(this.mIndentationPattern);
                this.format((JSONObject)object2, stringBuilder, ((StringBuilder)object).toString());
                stringBuilder.append(string2);
                stringBuilder.append(this.mIndentationPattern);
                stringBuilder.append("}");
            } else if (object2 instanceof JSONArray) {
                object = (JSONArray)object2;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(string2);
                ((StringBuilder)object2).append(this.mIndentationPattern);
                this.formatArray((JSONArray)object, stringBuilder, ((StringBuilder)object2).toString());
            } else {
                this.formatValue(object2, stringBuilder);
            }
            if (iterator.hasNext()) {
                stringBuilder.append(",\n");
                continue;
            }
            stringBuilder.append("\n");
        }
    }

    private void formatArray(JSONArray jSONArray, StringBuilder stringBuilder, String string2) {
        stringBuilder.append("[\n");
        for (int i = 0; i < jSONArray.length(); ++i) {
            Object object;
            Object object2 = jSONArray.opt(i);
            if (object2 instanceof JSONObject) {
                object2 = (JSONObject)object2;
                stringBuilder.append(string2);
                stringBuilder.append(this.mIndentationPattern);
                stringBuilder.append("{\n");
                object = new StringBuilder();
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(this.mIndentationPattern);
                this.format((JSONObject)object2, stringBuilder, ((StringBuilder)object).toString());
                stringBuilder.append(string2);
                stringBuilder.append(this.mIndentationPattern);
                stringBuilder.append("}");
            } else if (object2 instanceof JSONArray) {
                object = (JSONArray)object2;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(string2);
                ((StringBuilder)object2).append(this.mIndentationPattern);
                this.formatArray((JSONArray)object, stringBuilder, ((StringBuilder)object2).toString());
            } else {
                this.formatValue(object2, stringBuilder);
            }
            if (i < jSONArray.length() - 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append(string2);
        stringBuilder.append("]");
    }

    private void formatValue(Object object, StringBuilder stringBuilder) {
        if (object instanceof String) {
            object = ((String)object).replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", Matcher.quoteReplacement("\\\"")).replaceAll("/", "\\\\/").replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t").replaceAll("\r", "\\\\r");
            stringBuilder.append("\"");
            stringBuilder.append((String)object);
            stringBuilder.append("\"");
        } else if (object instanceof Long) {
            stringBuilder.append((Long)object);
        } else if (object instanceof Integer) {
            stringBuilder.append((Integer)object);
        } else if (object instanceof Boolean) {
            stringBuilder.append((Boolean)object);
        } else if (object instanceof Double) {
            stringBuilder.append((Double)object);
        } else {
            stringBuilder.append(object.toString());
        }
    }

    private String getAttributeNameReplacement(String string2, String string3) {
        if ((string2 = this.mAttributeNameReplacements.get(string2)) != null) {
            return string2;
        }
        return string3;
    }

    private String getContentNameReplacement(String string2, String string3) {
        if ((string2 = this.mContentNameReplacements.get(string2)) != null) {
            return string2;
        }
        return string3;
    }

    private boolean isForcedList(Tag object) {
        if (this.mForceListPaths.contains(object = ((Tag)object).getPath())) {
            return true;
        }
        Iterator<Pattern> iterator = this.mForceListPatterns.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().matcher((CharSequence)object).find()) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void putContent(String var1_1, JSONObject var2_6, String var3_7, String var4_8) {
        block18: {
            try {
                var1_1 = this.mForceClassForPath.get(var1_1);
                if (var1_1 == null) {
                    var1_1 = var4_8;
                    if (var4_8 == null) {
                        var1_1 = "";
                    }
                    var2_6.put(var3_7, var1_1);
                    return;
                }
                if (var1_1 == Integer.class) {
                    try {
                        var2_6.put(var3_7, (Object)Integer.parseInt(var4_8));
                        return;
                    }
                    catch (NumberFormatException var1_2) {
                        var2_6.put(var3_7, 0);
                        return;
                    }
                }
                if (var1_1 != Long.class) break block18;
                try {
                    var2_6.put(var3_7, (Object)Long.parseLong(var4_8));
                    return;
                }
                catch (NumberFormatException var1_3) {
                    var2_6.put(var3_7, 0L);
                    return;
                }
            }
            catch (JSONException var1_5) {
                return;
            }
        }
        if (var1_1 == Double.class) {
            try {
                var2_6.put(var3_7, (Object)Double.parseDouble(var4_8));
                return;
            }
            catch (NumberFormatException var1_4) {
                var2_6.put(var3_7, 0.0);
                return;
            }
        }
        if (var1_1 != Boolean.class) return;
        if (var4_8 != null) ** GOTO lbl47
        var2_6.put(var3_7, false);
        return;
lbl47:
        // 1 sources

        if (var4_8.equalsIgnoreCase("true")) {
            var2_6.put(var3_7, true);
            return;
        }
        if (var4_8.equalsIgnoreCase("false")) {
            var2_6.put(var3_7, false);
            return;
        }
        var2_6.put(var3_7, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readTags(Tag tag, XmlPullParser xmlPullParser) {
        void var1_5;
        try {
            int n;
            do {
                int n2;
                CharSequence charSequence;
                Object object;
                String string2;
                if ((n = xmlPullParser.next()) == 2) {
                    string2 = xmlPullParser.getName();
                    object = new StringBuilder();
                    ((StringBuilder)object).append(tag.getPath());
                    ((StringBuilder)object).append("/");
                    ((StringBuilder)object).append(string2);
                    charSequence = ((StringBuilder)object).toString();
                    boolean bl = this.mSkippedTags.contains(charSequence);
                    object = new Tag((String)charSequence, string2);
                    if (!bl) {
                        tag.addChild((Tag)object);
                    }
                    n2 = xmlPullParser.getAttributeCount();
                } else {
                    if (n == 4) {
                        tag.setContent(xmlPullParser.getText());
                        continue;
                    }
                    if (n == 3) {
                        return;
                    }
                    if (n == 1) {
                        return;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("unknown xml eventType ");
                    ((StringBuilder)object).append(n);
                    Log.i((String)TAG, (String)((StringBuilder)object).toString());
                    continue;
                }
                for (int i = 0; i < n2; ++i) {
                    String string3 = xmlPullParser.getAttributeName(i);
                    string2 = xmlPullParser.getAttributeValue(i);
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append(tag.getPath());
                    ((StringBuilder)charSequence).append("/");
                    ((StringBuilder)charSequence).append(((Tag)object).getName());
                    ((StringBuilder)charSequence).append("/");
                    ((StringBuilder)charSequence).append(string3);
                    charSequence = ((StringBuilder)charSequence).toString();
                    if (this.mSkippedAttributes.contains(charSequence)) continue;
                    string3 = this.getAttributeNameReplacement((String)charSequence, string3);
                    Tag tag2 = new Tag((String)charSequence, string3);
                    tag2.setContent(string2);
                    ((Tag)object).addChild(tag2);
                }
                this.readTags((Tag)object, xmlPullParser);
            } while (n != 1);
            return;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException iOException) {
        }
        catch (XmlPullParserException xmlPullParserException) {
            // empty catch block
        }
        var1_5.printStackTrace();
    }

    private void setInput(XmlPullParser xmlPullParser) {
        StringReader stringReader = this.mStringSource;
        if (stringReader != null) {
            try {
                xmlPullParser.setInput((Reader)stringReader);
            }
            catch (XmlPullParserException xmlPullParserException) {
                xmlPullParserException.printStackTrace();
            }
        } else {
            try {
                xmlPullParser.setInput(this.mInputStreamSource, this.mInputEncoding);
            }
            catch (XmlPullParserException xmlPullParserException) {
                xmlPullParserException.printStackTrace();
            }
        }
    }

    private void unsetInput() {
        StringReader stringReader = this.mStringSource;
        if (stringReader != null) {
            stringReader.close();
        }
    }

    public String toFormattedString() {
        if (this.mJsonObject != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{\n");
            this.format(this.mJsonObject, stringBuilder, DEFAULT_EMPTY_STRING);
            stringBuilder.append("}\n");
            return stringBuilder.toString();
        }
        return null;
    }

    public String toFormattedString(String string2) {
        this.mIndentationPattern = string2 == null ? DEFAULT_INDENTATION : string2;
        return this.toFormattedString();
    }

    public JSONObject toJson() {
        return this.mJsonObject;
    }

    public String toString() {
        JSONObject jSONObject = this.mJsonObject;
        if (jSONObject != null) {
            return jSONObject.toString();
        }
        return null;
    }

    public static class Builder {
        private HashMap<String, String> mAttributeNameReplacements;
        private HashMap<String, String> mContentNameReplacements;
        private HashMap<String, Class> mForceClassForPath;
        private HashSet<String> mForceListPaths = new HashSet();
        private HashSet<Pattern> mForceListPatterns = new HashSet();
        private String mInputEncoding = "utf-8";
        private InputStream mInputStreamSource;
        private HashSet<String> mSkippedAttributes;
        private HashSet<String> mSkippedTags;
        private StringReader mStringSource;

        public Builder(InputStream inputStream, String string2) {
            this.mAttributeNameReplacements = new HashMap();
            this.mContentNameReplacements = new HashMap();
            this.mForceClassForPath = new HashMap();
            this.mSkippedAttributes = new HashSet();
            this.mSkippedTags = new HashSet();
            this.mInputStreamSource = inputStream;
            if (string2 == null) {
                string2 = XmlToJson.DEFAULT_ENCODING;
            }
            this.mInputEncoding = string2;
        }

        public Builder(String string2) {
            this.mAttributeNameReplacements = new HashMap();
            this.mContentNameReplacements = new HashMap();
            this.mForceClassForPath = new HashMap();
            this.mSkippedAttributes = new HashSet();
            this.mSkippedTags = new HashSet();
            this.mStringSource = new StringReader(string2);
        }

        public XmlToJson build() {
            return new XmlToJson(this);
        }

        public Builder forceBooleanForPath(String string2) {
            this.mForceClassForPath.put(string2, Boolean.class);
            return this;
        }

        public Builder forceDoubleForPath(String string2) {
            this.mForceClassForPath.put(string2, Double.class);
            return this;
        }

        public Builder forceIntegerForPath(String string2) {
            this.mForceClassForPath.put(string2, Integer.class);
            return this;
        }

        public Builder forceList(String string2) {
            this.mForceListPaths.add(string2);
            return this;
        }

        public Builder forceListPattern(String object) {
            object = Pattern.compile((String)object, 32);
            this.mForceListPatterns.add((Pattern)object);
            return this;
        }

        public Builder forceLongForPath(String string2) {
            this.mForceClassForPath.put(string2, Long.class);
            return this;
        }

        public Builder setAttributeName(String string2, String string3) {
            this.mAttributeNameReplacements.put(string2, string3);
            return this;
        }

        public Builder setContentName(String string2, String string3) {
            this.mContentNameReplacements.put(string2, string3);
            return this;
        }

        public Builder skipAttribute(String string2) {
            this.mSkippedAttributes.add(string2);
            return this;
        }

        public Builder skipTag(String string2) {
            this.mSkippedTags.add(string2);
            return this;
        }
    }
}

