/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.views.adapter;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;

public abstract class FreeRecyclerViewAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public Activity activity;
    private ArrayList<T> items = new ArrayList();

    public FreeRecyclerViewAdapter(Activity activity, ArrayList<T> arrayList) {
        this.activity = activity;
        if (arrayList != null) {
            this.items = arrayList;
        }
    }

    public void addItem(T t) {
        this.items.add(t);
        this.notifyItemInserted(this.items.size() - 1);
    }

    public void addItems(ArrayList<T> arrayList) {
        int n = this.items.size();
        int n2 = arrayList.size();
        this.items.addAll(arrayList);
        this.notifyItemRangeInserted(n, n2 + n);
    }

    public void clearItems() {
        this.items.clear();
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.items.size();
    }

    public T getItem(int n) {
        return this.items.get(n);
    }

    @Override
    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public int getItemViewType(int n) {
        return this.getViewType(n);
    }

    public ArrayList<T> getItems() {
        return this.items;
    }

    public abstract int getViewType(int var1);

    public abstract View initView(int var1);

    public void notifyItem(T t) {
        if (this.items.contains(t)) {
            this.notifyItemChanged(this.items.indexOf(t));
        }
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n) {
        this.setView(n, this.getItemViewType(n), ((BaseViewHolder)viewHolder).itemView);
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        return new BaseViewHolder(this.activity, this.initView(n));
    }

    public void removeItem(T t) {
        if (this.items.contains(t)) {
            this.notifyItemRemoved(this.items.indexOf(t));
            this.items.remove(t);
        }
    }

    public void removeRange(int n, int n2) {
        --n2;
        while (n2 >= n) {
            this.items.remove(n2);
            --n2;
        }
        this.notifyDataSetChanged();
    }

    public abstract void setView(int var1, int var2, View var3);

    public void swapItems(ArrayList<T> arrayList) {
        this.items.clear();
        this.items.addAll(arrayList);
        this.notifyDataSetChanged();
    }

    public static class BaseViewHolder
    extends RecyclerView.ViewHolder {
        private Activity activity;
        public View itemView;

        public BaseViewHolder(Activity activity, View view) {
            super(view);
            this.activity = activity;
            this.itemView = view;
        }
    }
}

