/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.views.adapter.callback;

import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;

public class ItemMoveCallback
extends ItemTouchHelper.Callback {
    private final ItemTouchHelperContract mAdapter;

    public ItemMoveCallback(ItemTouchHelperContract itemTouchHelperContract) {
        this.mAdapter = itemTouchHelperContract;
    }

    @Override
    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        this.mAdapter.onRowClear(viewHolder);
    }

    @Override
    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        if (this.isLongPressDragEnabled(viewHolder.getAdapterPosition())) {
            return ItemMoveCallback.makeMovementFlags(3, 0);
        }
        return ItemMoveCallback.makeMovementFlags(0, 0);
    }

    @Override
    public boolean isItemViewSwipeEnabled() {
        return false;
    }

    @Override
    public boolean isLongPressDragEnabled() {
        return true;
    }

    public boolean isLongPressDragEnabled(int n) {
        return true;
    }

    @Override
    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder viewHolder2) {
        if (this.mAdapter.canRowMoved(viewHolder)) {
            this.mAdapter.onRowMoved(viewHolder.getAdapterPosition(), viewHolder2.getAdapterPosition());
            return true;
        }
        return false;
    }

    @Override
    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int n) {
        if (n != 0) {
            this.mAdapter.onRowSelected(viewHolder);
        }
        super.onSelectedChanged(viewHolder, n);
    }

    @Override
    public void onSwiped(RecyclerView.ViewHolder viewHolder, int n) {
    }

    public static interface ItemTouchHelperContract {
        public boolean canRowMoved(RecyclerView.ViewHolder var1);

        public void onRowClear(RecyclerView.ViewHolder var1);

        public void onRowMoved(int var1, int var2);

        public void onRowSelected(RecyclerView.ViewHolder var1);
    }
}

