/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.views.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;
import com.james.utils.MonitorUtils;

public class ShapeImageView
extends AppCompatImageView {
    public static int SHAPE_DIAMOND = 4098;
    public static int SHAPE_OVAL = 4097;
    private int color = -7829368;
    protected Path outlinePath;
    private Paint paint;
    private int shape = SHAPE_OVAL;

    public ShapeImageView(Context context) {
        super(context);
        this.paint = new Paint();
        this.outlinePath = new Path();
        this.init();
    }

    public ShapeImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.paint = new Paint();
        this.outlinePath = new Path();
        this.init();
    }

    public ShapeImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.paint = new Paint();
        this.outlinePath = new Path();
        this.init();
    }

    private void generateOutlinePath() {
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        int n3 = Math.min(n, n2);
        this.outlinePath.reset();
        int n4 = this.shape;
        if (n4 == SHAPE_OVAL) {
            this.outlinePath.addOval(new RectF((float)(n - n3), (float)(n2 - n3), (float)(n + n3), (float)(n2 + n3)), Path.Direction.CW);
        } else if (n4 == SHAPE_DIAMOND) {
            n4 = MonitorUtils.dp2px((Context)this.getContext(), (float)8.0f);
            int n5 = n2 - n3 + n4;
            double d = n4;
            int n6 = (int)(Math.cos(0.7853981633974483) * d);
            int n7 = (int)(Math.sin(0.7853981633974483) * d);
            this.outlinePath.moveTo((float)(n - n6), (float)(n5 - n7));
            Path path = this.outlinePath;
            float f = n - n4;
            float f2 = n5 - n4;
            float f3 = n + n4;
            path.arcTo(new RectF(f, f2, f3, (float)(n5 + n4)), -135.0f, 90.0f);
            n5 = n + n3 - n4;
            n6 = (int)(Math.cos(0.7853981633974483) * d);
            n7 = (int)(Math.sin(0.7853981633974483) * d);
            this.outlinePath.lineTo((float)(n6 + n5), (float)(n2 - n7));
            path = this.outlinePath;
            float f4 = n5 - n4;
            float f5 = n2 - n4;
            float f6 = n5 + n4;
            f2 = n2 + n4;
            path.arcTo(new RectF(f4, f5, f6, f2), -45.0f, 90.0f);
            n5 = n2 + n3 - n4;
            n6 = (int)(d * Math.cos(0.7853981633974483));
            n7 = (int)(d * Math.sin(0.7853981633974483));
            this.outlinePath.lineTo((float)(n6 + n), (float)(n7 + n5));
            this.outlinePath.arcTo(new RectF(f, (float)(n5 - n4), f3, (float)(n5 + n4)), 45.0f, 90.0f);
            n = n - n3 + n4;
            n6 = (int)(Math.cos(0.7853981633974483) * d);
            n3 = (int)(d * Math.sin(0.7853981633974483));
            this.outlinePath.lineTo((float)(n - n6), (float)(n2 + n3));
            this.outlinePath.arcTo(new RectF((float)(n - n4), f5, (float)(n + n4), f2), 135.0f, 90.0f);
            this.outlinePath.close();
        }
    }

    private void init() {
        this.paint.setStrokeWidth((float)MonitorUtils.dp2px((Context)this.getContext(), (float)4.0f));
        this.paint.setStyle(Paint.Style.STROKE);
    }

    protected void onDraw(Canvas canvas) {
        canvas.clipPath(this.outlinePath);
        super.onDraw(canvas);
        this.paint.setColor(this.color);
        canvas.drawPath(this.outlinePath, this.paint);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.generateOutlinePath();
    }

    public void setColor(int n) {
        this.color = n;
        this.generateOutlinePath();
        this.postInvalidate();
        this.requestLayout();
    }

    public void setShape(int n) {
        this.shape = n;
        this.generateOutlinePath();
        this.postInvalidate();
        this.requestLayout();
    }
}

