/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.account;

import android.util.Patterns;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.account.vo.AccountUserInfo;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.repo.account.LoginRepository;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.i18N;
import javax.inject.Inject;
import org.json.JSONObject;

public class LoginViewModel
extends BaseViewModel {
    private final MutableLiveData<String> loginCheckMsgLiveData = new MutableLiveData();
    @Inject
    LoginRepository loginRepository;

    @Inject
    public LoginViewModel() {
    }

    public void createDefaultUserProfileToDb() {
        this.loginRepository.createDefaultUserProfileToDb("Barringer", false);
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.loginRepository.getLiveAccountErrorResponse();
    }

    public MutableLiveData<String> getLoginCheckMsgLiveData() {
        return this.loginCheckMsgLiveData;
    }

    public void getUserInfoWithVerified() {
        this.loginRepository.getUserInfoWithVerified();
    }

    public void getUserProfile() {
        this.loginRepository.getUserProfile();
    }

    public MutableLiveData<JSONObject> getUserProfileForLoginResultLiveData() {
        return this.loginRepository.getUserProfileForLoginResultLiveData();
    }

    public MutableLiveData<Boolean> isLoginSuccessLiveData() {
        return this.loginRepository.isLoginSuccessLiveData();
    }

    public MutableLiveData<Boolean> isUserInfoSuccessLiveData() {
        return this.loginRepository.isUserInfoSuccessLiveData();
    }

    public MutableLiveData<AccountUserInfo> isUserInfoVerifiedLiveData() {
        return this.loginRepository.isUserInfoVerifiedLiveData();
    }

    public MutableLiveData<Boolean> isUserProfileSuccessLiveData() {
        return this.loginRepository.isUserProfileSuccessLiveData();
    }

    public void login(String string2, String string3) {
        if (!string2.isEmpty() && Patterns.EMAIL_ADDRESS.matcher(string2).matches()) {
            if (string3.isEmpty()) {
                this.loginCheckMsgLiveData.postValue(i18N.get("M_EmptyPassword"));
                return;
            }
            this.loginRepository.login(string2, string3);
            return;
        }
        this.loginCheckMsgLiveData.postValue(i18N.get("M_EnterValidEmail"));
    }

    public void resetUserId() {
        ProfileUtil.getInstance().set("userId", "");
        ProfileUtil.getInstance().set("com.brytonsport.active.loginToken", "");
        ProfileUtil.getInstance().set("nickName", "");
        ProfileUtil.getInstance().set("avatar", "");
        ProfileUtil.getInstance().set("groupRideId", "");
    }
}

