/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.account;

import android.util.Patterns;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.repo.account.LoginRepository;
import com.brytonsport.active.utils.i18N;
import javax.inject.Inject;
import org.json.JSONException;
import org.json.JSONObject;

public class SignUpViewModel
extends BaseViewModel {
    @Inject
    LoginRepository loginRepository;
    private final MutableLiveData<String> signCheckMsgLiveData = new MutableLiveData();
    public String userProfileNickName = "Barringer";

    @Inject
    public SignUpViewModel() {
    }

    public void createDefaultUserProfileToDb() {
        this.loginRepository.createDefaultUserProfileToDb(this.userProfileNickName);
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.loginRepository.getLiveAccountErrorResponse();
    }

    public String getPrivacyPolicyUrl() {
        return String.format("https://www.brytonsport.com/#/privacyPolicy", i18N.getCurrentLanguage());
    }

    public MutableLiveData<String> getSignCheckMsgLiveData() {
        return this.signCheckMsgLiveData;
    }

    public void getUserInfo() {
        this.loginRepository.getUserInfo();
    }

    public void getUserProfile() {
        this.loginRepository.getUserProfile();
    }

    public MutableLiveData<Boolean> isLoginSuccessLiveData() {
        return this.loginRepository.isLoginSuccessLiveData();
    }

    public MutableLiveData<Boolean> isSetUserProfileSuccessLiveData() {
        return this.loginRepository.isSetUserProfileSuccessLiveData();
    }

    public MutableLiveData<Boolean> isSignSuccessLiveData() {
        return this.loginRepository.isSignSuccessLiveData();
    }

    public MutableLiveData<Boolean> isUserInfoSuccessLiveData() {
        return this.loginRepository.isUserInfoSuccessLiveData();
    }

    public MutableLiveData<Boolean> isUserProfileSuccessLiveData() {
        return this.loginRepository.isUserProfileSuccessLiveData();
    }

    public void login(String string2, String string3) {
        if (!string2.isEmpty() && Patterns.EMAIL_ADDRESS.matcher(string2).matches()) {
            if (string3.isEmpty()) {
                this.signCheckMsgLiveData.postValue(i18N.get("M_EmptyPassword"));
                return;
            }
            this.loginRepository.login(string2, string3);
            return;
        }
        this.signCheckMsgLiveData.postValue(i18N.get("M_EnterValidEmail"));
    }

    public void sign(String string2, String string3, String string4, String string5) {
        if (string2.isEmpty()) {
            this.signCheckMsgLiveData.postValue("\u8acb\u8f38\u5165\u66b1\u7a31");
            return;
        }
        if (!string3.isEmpty() && Patterns.EMAIL_ADDRESS.matcher(string3).matches()) {
            if (string4.isEmpty()) {
                this.signCheckMsgLiveData.postValue(i18N.get("M_EmptyPassword"));
                return;
            }
            if (string5.isEmpty()) {
                this.signCheckMsgLiveData.postValue("\u8acb\u8f38\u5165\u78ba\u8a8d\u5bc6\u78bc");
                return;
            }
            if (!string4.equals(string5)) {
                this.signCheckMsgLiveData.postValue(i18N.get("M_PasswordNotMatch"));
                return;
            }
            this.userProfileNickName = string2;
            this.loginRepository.sign(string3, string4);
            return;
        }
        this.signCheckMsgLiveData.postValue(i18N.get("M_EnterValidEmail"));
    }

    public void updatePrivacyPolicyAgree(boolean bl) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("data", bl);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.loginRepository.setAgreeToUserInfo(jSONObject);
    }
}

