/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.base;

import android.util.Pair;
import com.brytonsport.active.utils.i18N;
import com.garmin.fit.Intensity;
import com.garmin.fit.WktStepDuration;
import com.garmin.fit.WktStepTarget;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class PlanDetail {
    public static final String DURATION_DISTANCE;
    public static final String DURATION_TIME;
    public static final int TYPE_COOL_DOWN = 3;
    public static final int TYPE_NONE = -1;
    public static final int TYPE_RECOVERY = 2;
    public static final int TYPE_WARM_UP = 0;
    public static final int TYPE_WORK = 1;
    public String cadenceRange;
    public String durationText;
    public WktStepDuration durationType;
    public int group;
    public int intensityType;
    public Pair<Float, Float> intensityValue;
    public float percentage;
    public WktStepTarget targetType;
    private String uuid;

    static {
        DURATION_TIME = i18N.get("Time");
        DURATION_DISTANCE = i18N.get("Distance");
    }

    public PlanDetail(int n, int n2) {
        Float f = Float.valueOf(0.0f);
        this.intensityValue = new Pair((Object)f, (Object)f);
        this.intensityType = n;
        this.group = n2;
        this.durationType = WktStepDuration.Time;
        this.durationText = "00:10:00";
        this.targetType = WktStepTarget.FTP;
        this.intensityValue = new Pair((Object)Float.valueOf(100.0f), (Object)Float.valueOf(200.0f));
        this.cadenceRange = null;
        this.uuid = UUID.randomUUID().toString();
    }

    public PlanDetail(int n, int n2, String string2, String string3, WktStepTarget wktStepTarget, Pair<Float, Float> pair, String string4) {
        Float f = Float.valueOf(0.0f);
        this.intensityValue = new Pair((Object)f, (Object)f);
        this.intensityType = n;
        this.group = n2;
        this.durationType = string2.equals(DURATION_DISTANCE) ? WktStepDuration.Distance : (string2.equals(DURATION_TIME) ? WktStepDuration.Time : WktStepDuration.INVALID);
        this.durationText = string3;
        this.targetType = wktStepTarget;
        this.intensityValue = pair;
        this.cadenceRange = string4;
        this.uuid = UUID.randomUUID().toString();
    }

    public PlanDetail(WktStepDuration wktStepDuration, WktStepTarget wktStepTarget, Intensity intensity, Pair<Float, Float> pair, int n) {
        Float f = Float.valueOf(0.0f);
        this.intensityValue = new Pair((Object)f, (Object)f);
        this.durationType = wktStepDuration;
        this.group = n;
        this.targetType = wktStepTarget;
        this.setIntensityType(intensity);
        this.intensityValue = pair;
        this.uuid = UUID.randomUUID().toString();
    }

    public PlanDetail(String string2) {
        Float f = Float.valueOf(0.0f);
        this.intensityValue = new Pair((Object)f, (Object)f);
        this.uuid = string2;
    }

    public PlanDetail copy() {
        PlanDetail planDetail = new PlanDetail(this.uuid);
        planDetail.intensityType = this.intensityType;
        planDetail.group = this.group;
        planDetail.durationType = this.durationType;
        planDetail.durationText = this.durationText;
        planDetail.targetType = this.targetType;
        planDetail.intensityValue = this.intensityValue;
        planDetail.cadenceRange = this.cadenceRange;
        return planDetail;
    }

    public JSONObject createInfoJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        String[] stringArray = this.cadenceRange;
        if (stringArray != null && !stringArray.isEmpty()) {
            jSONObject.put("target_type", (Object)"cadence");
            stringArray = this.cadenceRange.split("-");
            if (stringArray[0].equals(stringArray[1])) {
                jSONObject.put("target_value", (Object)stringArray[0]);
            } else {
                jSONObject.put("target_high", Integer.parseInt(stringArray[1]));
                jSONObject.put("target_low", Integer.parseInt(stringArray[0]));
            }
        } else {
            jSONObject.put("target_type", (Object)"");
        }
        return jSONObject;
    }

    public float durationDistance() {
        return Float.parseFloat(this.durationText);
    }

    public float durationTime() {
        String[] stringArray = this.durationText.split(":");
        return Float.parseFloat(stringArray[0]) * 3600.0f + Float.parseFloat(stringArray[1]) * 60.0f + Float.parseFloat(stringArray[2]);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PlanDetail)) {
            return false;
        }
        return ((PlanDetail)object).uuid.equals(this.uuid);
    }

    public int getColor() {
        float f = this.percentage;
        if (f <= 0.1f) {
            return -2102538;
        }
        if (f <= 0.2f) {
            return -2102538;
        }
        if (f <= 0.3f) {
            return -7360266;
        }
        if (f <= 0.4f) {
            return -7360266;
        }
        if (f <= 0.5f) {
            return -1184943;
        }
        if (f <= 0.6f) {
            return -1184943;
        }
        if (f <= 0.7f) {
            return -1005761;
        }
        if (f <= 0.8f) {
            return -1005761;
        }
        return -1153177;
    }

    public String getTypeName() {
        int n = this.intensityType;
        if (n == 0) {
            return i18N.get("WarmUp");
        }
        if (n == 1) {
            return i18N.get("WoWork");
        }
        if (n == 2) {
            return i18N.get("Recovery");
        }
        if (n == 3) {
            return i18N.get("CoolDown");
        }
        return i18N.get("WarmUp");
    }

    public String getUuid() {
        return this.uuid;
    }

    public Intensity intensityType() {
        int n = this.intensityType;
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        return Intensity.INVALID;
                    }
                    return Intensity.COOLDOWN;
                }
                return Intensity.REST;
            }
            return Intensity.ACTIVE;
        }
        return Intensity.WARMUP;
    }

    public void resetDurationValue() {
        WktStepDuration wktStepDuration = this.durationType;
        Object object = WktStepDuration.Time;
        String string2 = "00:10:00";
        object = wktStepDuration == object ? "00:10:00" : "999";
        this.durationText = object;
        int n = this.intensityType;
        if (n != 0) {
            if (n != 1) {
                object = "5";
                if (n != 2) {
                    if (n == 3) {
                        if (this.durationType != WktStepDuration.Time) {
                            string2 = "5";
                        }
                        this.durationText = string2;
                    }
                } else {
                    string2 = object;
                    if (this.durationType == WktStepDuration.Time) {
                        string2 = "00:5:00";
                    }
                    this.durationText = string2;
                }
            } else {
                if (this.durationType != WktStepDuration.Time) {
                    string2 = "8";
                }
                this.durationText = string2;
            }
        } else {
            string2 = this.durationType == WktStepDuration.Time ? "00:20:00" : "3";
            this.durationText = string2;
        }
    }

    public void resetIntensityValue(Boolean comparable) {
        boolean bl = comparable;
        comparable = Float.valueOf(0.0f);
        if (bl) {
            this.intensityValue = new Pair((Object)comparable, (Object)comparable);
            int n = 1.$SwitchMap$com$garmin$fit$WktStepTarget[this.targetType.ordinal()];
            if (n != 1 && n != 2 && n != 3) {
                if (n != 4) {
                    if (n == 5) {
                        this.intensityValue = new Pair((Object)Float.valueOf(80.0f), (Object)Float.valueOf(90.0f));
                    }
                } else {
                    n = this.intensityType;
                    if (n != 0) {
                        if (n != 1) {
                            if (n != 2) {
                                if (n == 3) {
                                    this.intensityValue = new Pair((Object)Float.valueOf(10.0f), (Object)Float.valueOf(15.0f));
                                }
                            } else {
                                this.intensityValue = new Pair((Object)Float.valueOf(15.0f), (Object)Float.valueOf(20.0f));
                            }
                        } else {
                            this.intensityValue = new Pair((Object)Float.valueOf(25.0f), (Object)Float.valueOf(25.0f));
                        }
                    } else {
                        this.intensityValue = new Pair((Object)Float.valueOf(10.0f), (Object)Float.valueOf(15.0f));
                    }
                }
            } else {
                n = this.intensityType;
                if (n != 0) {
                    if (n != 1) {
                        if (n != 2) {
                            if (n == 3) {
                                this.intensityValue = new Pair((Object)Float.valueOf(40.0f), (Object)Float.valueOf(50.0f));
                            }
                        } else {
                            this.intensityValue = new Pair((Object)Float.valueOf(50.0f), (Object)Float.valueOf(60.0f));
                        }
                    } else {
                        this.intensityValue = new Pair((Object)Float.valueOf(70.0f), (Object)Float.valueOf(80.0f));
                    }
                } else {
                    this.intensityValue = new Pair((Object)Float.valueOf(40.0f), (Object)Float.valueOf(50.0f));
                }
            }
        } else {
            this.intensityValue = new Pair((Object)comparable, (Object)comparable);
            int n = 1.$SwitchMap$com$garmin$fit$WktStepTarget[this.targetType.ordinal()];
            if (n != 1 && n != 2 && n != 3) {
                if (n != 4) {
                    if (n == 5) {
                        this.intensityValue = new Pair((Object)Float.valueOf(85.0f), (Object)Float.valueOf(85.0f));
                    }
                } else {
                    n = this.intensityType;
                    if (n != 0) {
                        if (n != 1) {
                            if (n != 2) {
                                if (n == 3) {
                                    this.intensityValue = new Pair((Object)Float.valueOf(13.0f), (Object)Float.valueOf(13.0f));
                                }
                            } else {
                                this.intensityValue = new Pair((Object)Float.valueOf(18.0f), (Object)Float.valueOf(18.0f));
                            }
                        } else {
                            this.intensityValue = new Pair((Object)Float.valueOf(28.0f), (Object)Float.valueOf(28.0f));
                        }
                    } else {
                        this.intensityValue = new Pair((Object)Float.valueOf(13.0f), (Object)Float.valueOf(13.0f));
                    }
                }
            } else {
                n = this.intensityType;
                if (n != 0) {
                    if (n != 1) {
                        if (n != 2) {
                            if (n == 3) {
                                this.intensityValue = new Pair((Object)Float.valueOf(45.0f), (Object)Float.valueOf(45.0f));
                            }
                        } else {
                            this.intensityValue = new Pair((Object)Float.valueOf(55.0f), (Object)Float.valueOf(55.0f));
                        }
                    } else {
                        this.intensityValue = new Pair((Object)Float.valueOf(75.0f), (Object)Float.valueOf(75.0f));
                    }
                } else {
                    this.intensityValue = new Pair((Object)Float.valueOf(45.0f), (Object)Float.valueOf(45.0f));
                }
            }
        }
    }

    public void setIntensityType(Intensity intensity) {
        int n = 1.$SwitchMap$com$garmin$fit$Intensity[intensity.ordinal()];
        this.intensityType = n != 1 ? (n != 2 ? (n != 3 ? (n != 4 ? -1 : 3) : 2) : 1) : 0;
    }
}

