/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.base;

import com.brytonsport.active.vm.base.analysis.Analysis;
import java.util.ArrayList;

public class Zone
extends Analysis {
    public int ftp;
    public float max;
    public float min;
    public float percentage;
    public long time;

    public Zone(long l, float f, float f2, float f3) {
        this.time = l;
        this.min = f;
        this.max = f2;
        this.percentage = f3;
    }

    public Zone(long l, float f, float f2, float f3, int n) {
        this.time = l;
        this.min = f;
        this.max = f2;
        this.percentage = f3;
        this.ftp = n;
    }

    public static ArrayList<Zone> mockHeartRateZoneList() {
        ArrayList<Zone> arrayList = new ArrayList<Zone>();
        arrayList.add(new Zone(3600000L, 70.1f, 77.2f, 0.12f));
        arrayList.add(new Zone(4200000L, 77.2f, 84.4f, 0.14f));
        arrayList.add(new Zone(4080000L, 84.4f, 91.5f, 0.136f));
        arrayList.add(new Zone(4680000L, 91.5f, 98.6f, 0.156f));
        arrayList.add(new Zone(4620000L, 98.6f, 105.7f, 0.154f));
        arrayList.add(new Zone(5100000L, 105.7f, 112.8f, 0.17f));
        arrayList.add(new Zone(3720000L, 112.8f, 119.9f, 0.124f));
        return arrayList;
    }

    public static ArrayList<Zone> mockPowerZoneList() {
        ArrayList<Zone> arrayList = new ArrayList<Zone>();
        arrayList.add(new Zone(4140000L, 100.1f, 102.9f, 0.138f));
        arrayList.add(new Zone(3960000L, 102.9f, 105.7f, 0.132f));
        arrayList.add(new Zone(4620000L, 105.7f, 108.6f, 0.154f));
        arrayList.add(new Zone(5040000L, 108.6f, 111.4f, 0.168f));
        arrayList.add(new Zone(4440000L, 111.4f, 114.3f, 0.148f));
        arrayList.add(new Zone(2940000L, 114.3f, 117.1f, 0.098f));
        arrayList.add(new Zone(4860000L, 117.1f, 119.9f, 0.162f));
        return arrayList;
    }

    public float getPercent() {
        return this.percentage * 100.0f;
    }

    public String getRangeString() {
        if (this.ftp == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Math.round(this.min));
            stringBuilder.append(" - ");
            stringBuilder.append(Math.round(this.max));
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Math.round(this.min * (float)this.ftp / 100.0f));
        stringBuilder.append(" - ");
        stringBuilder.append(Math.round(this.max * (float)this.ftp / 100.0f));
        return stringBuilder.toString();
    }

    public String getRangeStringForZ5C() {
        if (this.ftp == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Math.round(this.min));
            stringBuilder.append(" - ");
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Math.round(this.min * (float)this.ftp / 100.0f));
        stringBuilder.append(" - ");
        return stringBuilder.toString();
    }

    public String getRangeStringForZ7() {
        if (this.ftp == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Math.round(this.min));
            stringBuilder.append(" - ");
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Math.round(this.min * (float)this.ftp / 100.0f));
        stringBuilder.append(" - ");
        return stringBuilder.toString();
    }

    public long getTime() {
        return this.time;
    }
}

