/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.calendar;

import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.db.result.entity.ActivityEntity;
import com.brytonsport.active.repo.result.ActivityRepository;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.TimeUtilByLee;
import com.brytonsport.active.vm.base.DayActivity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.json.JSONException;
import org.json.JSONObject;

public class CalendarMonthViewModel
extends BaseViewModel {
    private static final String DEFAULT_ACTIVITY_NAME = "new activity";
    @Inject
    ActivityRepository activityRepository;
    private List<DayActivity> dayActivityList;
    private ArrayList<MonthActivity> list = new ArrayList();
    private final LiveData<List<ActivityEntity>> listLiveData;
    private final MutableLiveData<JSONObject> queryStartAndEndTsObj;

    @Inject
    public CalendarMonthViewModel() {
        MutableLiveData mutableLiveData = new MutableLiveData();
        this.queryStartAndEndTsObj = mutableLiveData;
        this.listLiveData = Transformations.switchMap(mutableLiveData, new Function<JSONObject, LiveData<List<ActivityEntity>>>(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public LiveData<List<ActivityEntity>> apply(JSONObject jSONObject) {
                void var1_4;
                int n;
                int n2;
                block4: {
                    n2 = 0;
                    try {
                        n = jSONObject.getInt("startTimestamp");
                    }
                    catch (JSONException jSONException) {
                        n = 0;
                        break block4;
                    }
                    try {
                        int n3;
                        n2 = n3 = jSONObject.getInt("endTimestamp");
                        return CalendarMonthViewModel.this.activityRepository.getActivityListStartAndEndTimeFromDb(n, n2);
                    }
                    catch (JSONException jSONException) {}
                }
                var1_4.printStackTrace();
                return CalendarMonthViewModel.this.activityRepository.getActivityListStartAndEndTimeFromDb(n, n2);
            }
        });
    }

    private String displayActivityName(ActivityEntity activityEntity) {
        String string2 = activityEntity.getName();
        CharSequence charSequence = string2;
        if (string2.equals(DEFAULT_ACTIVITY_NAME)) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("bike");
            ((StringBuilder)charSequence).append(TimeUtilByLee.getDateHour(activityEntity.getLocalStartTime()));
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public LiveData<List<ActivityEntity>> getListLiveData() {
        return this.listLiveData;
    }

    public ArrayList<MonthActivity> getMonthActivityList(int n, int n2) {
        ArrayList<MonthActivity> arrayList = new ArrayList<MonthActivity>();
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get((int)i).year != n || this.list.get((int)i).month != n2) continue;
            arrayList.add(this.list.get(i));
        }
        return arrayList;
    }

    public void init() {
        this.list = new ArrayList();
        for (DayActivity dayActivity : this.dayActivityList) {
            MonthActivity monthActivity;
            MonthActivity monthActivity2 = null;
            int n = 0;
            while (true) {
                monthActivity = monthActivity2;
                if (n >= this.list.size()) break;
                if (dayActivity.getYear() == this.list.get((int)n).year && dayActivity.getMonth() == this.list.get((int)n).month && dayActivity.getDateByMonth() == this.list.get((int)n).dateOfMonth) {
                    monthActivity = this.list.get(n);
                    break;
                }
                ++n;
            }
            if (monthActivity != null) {
                if (dayActivity.type == DayActivity.TYPE_RUN) {
                    ++monthActivity.runNumber;
                }
                if (dayActivity.type == DayActivity.TYPE_RIDE) {
                    ++monthActivity.rideNumber;
                }
                monthActivity.distance = (float)((double)monthActivity.distance + dayActivity.distance);
                monthActivity.duration += dayActivity.duration;
                continue;
            }
            n = dayActivity.type == DayActivity.TYPE_RUN ? 1 : 0;
            int n2 = dayActivity.type == DayActivity.TYPE_RIDE ? 1 : 0;
            monthActivity = new MonthActivity(dayActivity.getYear(), dayActivity.getMonth(), dayActivity.getDateByMonth(), n, n2, (float)dayActivity.distance, dayActivity.duration);
            this.list.add(monthActivity);
        }
    }

    public void prepareDataToView(List<ActivityEntity> object) {
        this.dayActivityList = new ArrayList<DayActivity>();
        object = object.iterator();
        while (object.hasNext()) {
            ActivityEntity activityEntity = (ActivityEntity)object.next();
            Object object2 = activityEntity.get_id();
            long l = activityEntity.getLocalStartTime();
            long l2 = activityEntity.getLocalStartTime();
            int n = DayActivity.TYPE_RIDE;
            String string2 = this.displayActivityName(activityEntity);
            double d = activityEntity.getSummary().getTotalDistance() == null ? 0.0 : DistanceUtil.distanceMeteor2Km(activityEntity.getSummary().getTotalDistance());
            int n2 = activityEntity.getSummary().getTotalMovingTime() != null ? activityEntity.getSummary().getTotalMovingTime().intValue() : 0;
            object2 = new DayActivity((String)object2, l * 1000L, l2, 0, n, string2, d, n2, activityEntity.getSummary().getTotalAscent(), activityEntity.getMapImage());
            this.dayActivityList.add((DayActivity)object2);
        }
        this.init();
    }

    public void searchRepo(int n, int n2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("startTimestamp", n);
            jSONObject.put("endTimestamp", n2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.queryStartAndEndTsObj.setValue(jSONObject);
    }

    public static class MonthActivity {
        public int dateOfMonth;
        public float distance;
        public int duration;
        public int month;
        public int rideNumber;
        public int runNumber;
        public int year;

        public MonthActivity(int n, int n2, int n3, int n4, int n5, float f, int n6) {
            this.year = n;
            this.month = n2;
            this.dateOfMonth = n3;
            this.runNumber = n4;
            this.rideNumber = n5;
            this.distance = f;
            this.duration = n6;
        }

        public Date getDate() {
            return new Date(this.year - 1900, this.month - 1, this.dateOfMonth);
        }

        public int getSticker() {
            int n = this.rideNumber;
            if (n != 0 && this.runNumber != 0) {
                return 0x7F0700F0;
            }
            if (n != 0) {
                return 0x7F0700F7;
            }
            if (this.runNumber != 0) {
                return 2131165436;
            }
            return 2131165723;
        }
    }
}

