/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.calendar;

import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.db.result.entity.ActivityEntity;
import com.brytonsport.active.repo.result.ActivityRepository;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.TimeUtilByLee;
import com.brytonsport.active.vm.base.DayActivity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.json.JSONException;
import org.json.JSONObject;

public class CalendarWeekViewModel
extends BaseViewModel {
    private static final String DEFAULT_ACTIVITY_NAME = "new activity";
    @Inject
    ActivityRepository activityRepository;
    private List<DayActivity> dayActivityList;
    private final LiveData<List<ActivityEntity>> listLiveData;
    private final MutableLiveData<JSONObject> queryStartAndEndTsObj;

    @Inject
    public CalendarWeekViewModel() {
        MutableLiveData mutableLiveData = new MutableLiveData();
        this.queryStartAndEndTsObj = mutableLiveData;
        this.dayActivityList = new ArrayList<DayActivity>();
        this.listLiveData = Transformations.switchMap(mutableLiveData, new Function<JSONObject, LiveData<List<ActivityEntity>>>(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public LiveData<List<ActivityEntity>> apply(JSONObject jSONObject) {
                void var1_4;
                int n;
                int n2;
                block4: {
                    n2 = 0;
                    try {
                        n = jSONObject.getInt("startTimestamp");
                    }
                    catch (JSONException jSONException) {
                        n = 0;
                        break block4;
                    }
                    try {
                        int n3;
                        n2 = n3 = jSONObject.getInt("endTimestamp");
                        return CalendarWeekViewModel.this.activityRepository.getActivityListStartAndEndTimeFromDb(n, n2);
                    }
                    catch (JSONException jSONException) {}
                }
                var1_4.printStackTrace();
                return CalendarWeekViewModel.this.activityRepository.getActivityListStartAndEndTimeFromDb(n, n2);
            }
        });
    }

    private String displayActivityName(ActivityEntity activityEntity) {
        String string2 = activityEntity.getName();
        CharSequence charSequence = string2;
        if (string2.equals(DEFAULT_ACTIVITY_NAME)) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("bike");
            ((StringBuilder)charSequence).append(TimeUtilByLee.getDateHour(activityEntity.getLocalStartTime()));
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public ArrayList<Object> getDayListByWeek(Date cloneable) {
        Date date = new Date(((Date)cloneable).getTime() + 604800000L);
        Object object = new ArrayList();
        for (DayActivity dayActivity : this.dayActivityList) {
            if (((Date)cloneable).getTime() > dayActivity.time || dayActivity.time > date.getTime()) continue;
            ((ArrayList)object).add(dayActivity);
        }
        Collections.sort(object, new Comparator<DayActivity>(){

            @Override
            public int compare(DayActivity dayActivity, DayActivity dayActivity2) {
                return Long.compare(dayActivity.time, dayActivity2.time);
            }
        });
        cloneable = new ArrayList();
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            DayActivity dayActivity = (DayActivity)object.next();
            if (((ArrayList)cloneable).isEmpty()) {
                ((ArrayList)cloneable).add(dayActivity.getDateForTitle());
            } else if (!dayActivity.isSameDate((DayActivity)((ArrayList)cloneable).get(((ArrayList)cloneable).size() - 1))) {
                ((ArrayList)cloneable).add(dayActivity.getDateForTitle());
            }
            ((ArrayList)cloneable).add(dayActivity);
        }
        return cloneable;
    }

    public ArrayList<DayActivity> getListByWeek(Date date) {
        Date date2 = new Date(date.getTime() + 604800000L);
        ArrayList<DayActivity> arrayList = new ArrayList<DayActivity>();
        for (DayActivity dayActivity : this.dayActivityList) {
            if (date.getTime() > dayActivity.time || dayActivity.time > date2.getTime()) continue;
            arrayList.add(dayActivity);
        }
        return arrayList;
    }

    public LiveData<List<ActivityEntity>> getListLiveData() {
        return this.listLiveData;
    }

    public void prepareDataToView(List<ActivityEntity> object) {
        this.dayActivityList = new ArrayList<DayActivity>();
        object = object.iterator();
        while (object.hasNext()) {
            ActivityEntity activityEntity = (ActivityEntity)object.next();
            String string2 = activityEntity.get_id();
            long l = activityEntity.getLocalStartTime();
            long l2 = activityEntity.getLocalStartTime();
            int n = DayActivity.TYPE_RIDE;
            Object object2 = this.displayActivityName(activityEntity);
            double d = activityEntity.getSummary().getTotalDistance() == null ? 0.0 : DistanceUtil.distanceMeteor2Km(activityEntity.getSummary().getTotalDistance());
            int n2 = activityEntity.getSummary().getTotalMovingTime() != null ? activityEntity.getSummary().getTotalMovingTime().intValue() : 0;
            object2 = new DayActivity(string2, l * 1000L, l2, 0, n, (String)object2, d, n2, activityEntity.getSummary().getTotalAscent(), activityEntity.getMapImage());
            this.dayActivityList.add((DayActivity)object2);
        }
    }

    public void searchRepo(int n, int n2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("startTimestamp", n);
            jSONObject.put("endTimestamp", n2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.queryStartAndEndTsObj.setValue(jSONObject);
    }
}

