/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.calendar;

import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.db.result.entity.ActivityEntity;
import com.brytonsport.active.repo.result.ActivityRepository;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.TimeUtilByLee;
import com.brytonsport.active.vm.base.DayActivity;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.json.JSONException;
import org.json.JSONObject;

public class CalendarYearViewModel
extends BaseViewModel {
    private static final String DEFAULT_ACTIVITY_NAME = "new activity";
    @Inject
    ActivityRepository activityRepository;
    private List<DayActivity> dayActivityList;
    public ArrayList<YearActivity> list;
    private final LiveData<List<ActivityEntity>> listLiveData;
    private final MutableLiveData<JSONObject> queryStartAndEndTsObj;
    private Date startDate = new Date(new Date().getTime());
    public int year = 2022;

    @Inject
    public CalendarYearViewModel() {
        MutableLiveData mutableLiveData = new MutableLiveData();
        this.queryStartAndEndTsObj = mutableLiveData;
        this.listLiveData = Transformations.switchMap(mutableLiveData, new Function<JSONObject, LiveData<List<ActivityEntity>>>(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public LiveData<List<ActivityEntity>> apply(JSONObject jSONObject) {
                void var1_4;
                int n;
                int n2;
                block4: {
                    n2 = 0;
                    try {
                        n = jSONObject.getInt("startTimestamp");
                    }
                    catch (JSONException jSONException) {
                        n = 0;
                        break block4;
                    }
                    try {
                        int n3;
                        n2 = n3 = jSONObject.getInt("endTimestamp");
                        return CalendarYearViewModel.this.activityRepository.getActivityListStartAndEndTimeFromDb(n, n2);
                    }
                    catch (JSONException jSONException) {}
                }
                var1_4.printStackTrace();
                return CalendarYearViewModel.this.activityRepository.getActivityListStartAndEndTimeFromDb(n, n2);
            }
        });
        this.initYearActivityList();
    }

    private String displayActivityName(ActivityEntity activityEntity) {
        String string2 = activityEntity.getName();
        CharSequence charSequence = string2;
        if (string2.equals(DEFAULT_ACTIVITY_NAME)) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("bike");
            ((StringBuilder)charSequence).append(TimeUtilByLee.getDateHour(activityEntity.getLocalStartTime()));
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public ArrayList<YearActivity> getListByYear() {
        ArrayList<YearActivity> arrayList = new ArrayList<YearActivity>();
        for (YearActivity yearActivity : this.list) {
            if (yearActivity.year != this.year) continue;
            arrayList.add(yearActivity);
        }
        return arrayList;
    }

    public LiveData<List<ActivityEntity>> getListLiveData() {
        return this.listLiveData;
    }

    public void initYearActivityList() {
        this.list = new ArrayList();
        for (int i = 1; i <= 12; ++i) {
            if (this.year >= this.startDate.getYear() + 1900 && (this.year != this.startDate.getYear() + 1900 || i > this.startDate.getMonth() + 1)) continue;
            YearActivity yearActivity = new YearActivity(this.year, i, 0, 0, 0.0f, 0L);
            this.list.add(yearActivity);
        }
    }

    public void prepareDataToView(List<ActivityEntity> object) {
        this.dayActivityList = new ArrayList<DayActivity>();
        for (YearActivity object2 : this.list) {
            object2.runNumber = 0;
            object2.rideNumber = 0;
            object2.distance = 0.0f;
            object2.duration = 0L;
        }
        Iterator<YearActivity> iterator = object.iterator();
        while (iterator.hasNext()) {
            ActivityEntity activityEntity = (ActivityEntity)((Object)iterator.next());
            object = activityEntity.get_id();
            long l = activityEntity.getLocalStartTime();
            long l2 = activityEntity.getLocalStartTime();
            int n = DayActivity.TYPE_RIDE;
            Object object2 = this.displayActivityName(activityEntity);
            double d = activityEntity.getSummary().getTotalDistance() == null ? 0.0 : DistanceUtil.distanceMeteor2Km(activityEntity.getSummary().getTotalDistance());
            int n2 = activityEntity.getSummary().getTotalMovingTime() != null ? activityEntity.getSummary().getTotalMovingTime().intValue() : 0;
            object2 = new DayActivity((String)object, l * 1000L, l2, 0, n, (String)object2, d, n2, activityEntity.getSummary().getTotalAscent(), activityEntity.getMapImage());
            this.dayActivityList.add((DayActivity)object2);
            Object var3_6 = null;
            n2 = 0;
            while (true) {
                object = var3_6;
                if (n2 >= this.list.size()) break;
                if (((DayActivity)object2).getYear() == this.list.get((int)n2).year && ((DayActivity)object2).getMonth() == this.list.get((int)n2).month) {
                    object = this.list.get(n2);
                    break;
                }
                ++n2;
            }
            if (object == null) continue;
            if (((DayActivity)object2).type == DayActivity.TYPE_RUN) {
                ++((YearActivity)object).runNumber;
            }
            if (((DayActivity)object2).type == DayActivity.TYPE_RIDE) {
                ++((YearActivity)object).rideNumber;
            }
            ((YearActivity)object).distance = (float)((double)((YearActivity)object).distance + ((DayActivity)object2).distance);
            ((YearActivity)object).duration += (long)((DayActivity)object2).duration;
        }
    }

    public void searchRepo(int n, int n2) {
        this.initYearActivityList();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("startTimestamp", n);
            jSONObject.put("endTimestamp", n2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.queryStartAndEndTsObj.setValue(jSONObject);
    }

    public static class YearActivity {
        public float distance;
        public long duration;
        public int month;
        public int rideNumber;
        public int runNumber;
        public int year;

        public YearActivity(int n, int n2, int n3, int n4, float f, long l) {
            this.year = n;
            this.month = n2;
            this.runNumber = n3;
            this.rideNumber = n4;
            this.distance = f;
            this.duration = l;
        }
    }
}

