/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.course;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.base.SyncBLEViewModel;
import com.brytonsport.active.utils.MyFavIniFileUtil;
import com.brytonsport.active.vm.base.Favorite;
import java.util.ArrayList;
import javax.inject.Inject;

public class CourseFavoriteViewModel
extends SyncBLEViewModel {
    public ArrayList<Favorite> favorites;
    public MutableLiveData<Boolean> mIsMyFavSynced = new MutableLiveData();

    @Inject
    public CourseFavoriteViewModel() {
        this.favorites = Favorite.loadMockData();
    }

    public void deleteDeviceFavorites(final Context context, ArrayList<Favorite> object) {
        if (context != null && object != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                arrayList.add(((Favorite)object.next()).id);
            }
            object = MyFavIniFileUtil.createDeviceMyFavIni(context);
            if (object != null) {
                ((MyFavIniFileUtil)object).deleteLocSection(arrayList);
            }
            if (((MyFavIniFileUtil)object).isModified() && ((MyFavIniFileUtil)object).saveToDeviceIniFile(context)) {
                this.mIsLoading.setValue(true);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        byte[] byArray = MyFavIniFileUtil.readDeviceIniFile(context);
                        if (byArray == null && byArray.length <= 0) {
                            CourseFavoriteViewModel.this.mIsMyFavSynced.postValue(false);
                        }
                        CourseFavoriteViewModel.this.bleRepository.postData(14, byArray);
                    }
                }).start();
            }
        }
    }

    public void loadFavorites(Context context, Location location) {
        this.favorites = MyFavIniFileUtil.getMyFavListFromDevice(context, location);
    }

    @Override
    protected IntentFilter makeGattUpdateIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.brytonsport.active.SERVICE_POST_DATA");
        return intentFilter;
    }

    @Override
    protected void onBLEReceive(Context context, Intent intent) {
        CharSequence charSequence = intent.getAction();
        if (charSequence != null && ((String)charSequence).equals("com.brytonsport.active.SERVICE_POST_DATA")) {
            int n = intent.getIntExtra("com.brytonsport.active.SERVICE_POST_FILE_TYPE", 0);
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("onReceive post data ok, postDataContentType -> ");
            ((StringBuilder)charSequence).append(n);
            Log.d((String)"MarkPosVM", (String)((StringBuilder)charSequence).toString());
            if (n == 14) {
                this.mIsLoading.postValue(false);
                this.mIsMyFavSynced.postValue(true);
            } else {
                super.onBLEReceive(context, intent);
            }
        } else {
            super.onBLEReceive(context, intent);
        }
    }
}

