/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.course;

import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.repo.course.PlaceRepository;
import com.brytonsport.active.repo.course.PlanTripRepository;
import com.brytonsport.active.utils.RouteModeConstantsUtil;
import com.brytonsport.active.vm.base.SearchResult;
import com.brytonsport.active.vm.base.analysis.Altitude;
import java.util.ArrayList;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONObject;

public class CourseNavigationInfoViewModel
extends BaseViewModel {
    public ArrayList<Altitude> altitudeList;
    @Inject
    BleRepository bleRepository;
    @Inject
    PlaceRepository placeRepository;
    private String planTripName = "loriTrip";
    @Inject
    PlanTripRepository planTripRepository;
    public String routeMode = RouteModeConstantsUtil.ROUTE_MODE_RACING_BIKE;
    public SearchResult searchResult;
    public double totalDistance = 0.0;
    public JSONObject turnByTurnResultObj = new JSONObject();

    @Inject
    public CourseNavigationInfoViewModel() {
        this.altitudeList = new ArrayList();
        this.altitudeList = new ArrayList();
        for (int i = 0; i < 100; ++i) {
            float f = (float)(Math.random() * 30.0);
            this.altitudeList.add(new Altitude((float)10 + f));
        }
    }

    public void getTurnByTurn(double d, double d2, double d3, double d4) {
        this.placeRepository.getTurnByTurn(0, d, d2, d3, d4, this.routeMode);
    }

    public MutableLiveData<JSONObject> getTurnByTurnResultLiveData() {
        return this.placeRepository.getTurnByTurnResultLiveData();
    }

    public void sendPlanTripNameToDevice() {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.plantrip.name");
        jSONArray.put((Object)this.planTripName);
        this.bleRepository.passSettingCommand(jSONArray);
    }

    public void sendPlanTripToDevice() {
        Object object = this.turnByTurnResultObj;
        if (object != null) {
            PlanTripRepository planTripRepository = this.planTripRepository;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.planTripName);
            stringBuilder.append(".fit");
            planTripRepository.encodePlanTripToFit((JSONObject)object, stringBuilder.toString());
            object = this.planTripRepository.loadPlanTripFit2ByteArray(this.planTripName);
            if (((JSONObject)object).length > 0) {
                this.bleRepository.postData(11, (byte[])object);
            }
        }
    }
}

