/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.course;

import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.repo.course.PlaceRepository;
import com.brytonsport.active.repo.course.PlanTripRepository;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.PlanTripUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.vm.base.ClimbGrade;
import com.brytonsport.active.vm.base.Route;
import com.brytonsport.active.vm.base.RouteClimb;
import com.brytonsport.active.vm.base.RouteClimbFitData;
import com.brytonsport.active.vm.base.RoutePoint;
import com.brytonsport.active.vm.base.RouteTurn;
import com.brytonsport.active.vm.base.analysis.Altitude;
import com.github.mikephil.charting.data.Entry;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CourseRouteDetailViewModel
extends BaseViewModel {
    static final String TAG = "CourseRouteDetailViewModel";
    public ArrayList<Altitude> altitudeList;
    private ArrayList<RoutePoint> arrayListConvertedTurns;
    private ArrayList<JSONArray> arrayListJsonPoints;
    private ArrayList<Integer> arrayListStartIdx;
    @Inject
    BleRepository bleRepository;
    private int currentGetTurnByTurnIdx = -1;
    public JSONObject decodeObj;
    private String filenameToUpload = "";
    public JSONObject graphhopperTurnCombineObj;
    public boolean mIsClimbModified = false;
    public boolean mIsPOIModified = false;
    private ArrayList<Integer> partStartIdxList;
    @Inject
    PlaceRepository placeRepository;
    private MutableLiveData<Boolean> planTripDecodeLiveData = new MutableLiveData();
    @Inject
    PlanTripRepository planTripRepository;
    public ArrayList<ClimbGrade> pointsArray;
    public Route route;
    public ArrayList<RouteClimbFitData> routeClimbFitData;
    public ArrayList<RouteClimb> routeClimbs;
    public ArrayList<RoutePoint> routePoints;
    public ArrayList<RouteTurn> routeTurns;
    public JSONObject turnByTurnDecodeObj;

    @Inject
    public CourseRouteDetailViewModel() {
        this.partStartIdxList = new ArrayList();
        this.arrayListJsonPoints = new ArrayList();
        this.arrayListStartIdx = new ArrayList();
        this.arrayListConvertedTurns = new ArrayList();
        this.decodeObj = new JSONObject();
        this.altitudeList = new ArrayList();
        this.routeTurns = new ArrayList();
        this.routePoints = new ArrayList();
        this.routeClimbs = new ArrayList();
        this.routeClimbFitData = new ArrayList();
    }

    private JSONObject getAbstract(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("ver", 1);
        Date date = new Date();
        jSONObject2.put("updateAt", date.getTime());
        jSONObject2.put("altGain", jSONObject.getDouble("gain"));
        jSONObject2.put("distance", jSONObject.getDouble("distance"));
        date = new JSONObject();
        jSONObject = jSONObject.getJSONArray("points");
        int n = 0;
        while (true) {
            if (n >= jSONObject.length()) break;
            if (jSONObject.getJSONObject(n).has("position_lat") && jSONObject.getJSONObject(n).has("position_long")) {
                date.put("lat", jSONObject.getJSONObject(n).getDouble("position_lat"));
                date.put("lng", jSONObject.getJSONObject(n).getDouble("position_long"));
                break;
            }
            ++n;
            continue;
            break;
        }
        try {
            jSONObject2.put("startPoint", (Object)date);
            return jSONObject2;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    private Entry getEntry(int n) {
        Entry entry = new Entry();
        entry.setX((float)n);
        entry.setY(this.altitudeList.get((int)n).meter);
        return entry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepareChart(JSONArray jSONArray) {
        if (jSONArray == null) {
            return;
        }
        ArrayList<Altitude> arrayList = new ArrayList<Altitude>();
        ArrayList<ClimbGrade> arrayList2 = new ArrayList<ClimbGrade>();
        int n = 0;
        while (true) {
            if (n >= jSONArray.length()) {
                this.altitudeList = arrayList;
                this.pointsArray = arrayList2;
                return;
            }
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(n);
                double d = jSONObject.getDouble("altitude");
                double d2 = 0.0;
                double d3 = jSONObject.getDouble("position_lat");
                double d4 = jSONObject.getDouble("position_long");
                if (n > 0) {
                    int n2 = n - 1;
                    JSONObject jSONObject2 = jSONArray.getJSONObject(n2);
                    d2 = DistanceUtil.distance(jSONObject2.getDouble("position_lat"), jSONObject2.getDouble("position_long"), d3, d4) + (double)((Altitude)arrayList.get((int)n2)).distance;
                }
                Altitude altitude = new Altitude((float)d, (float)d2);
                arrayList.add(altitude);
                ClimbGrade climbGrade = new ClimbGrade(n, d4, d3, d);
                arrayList2.add(climbGrade);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            ++n;
        }
    }

    private boolean saveAsFitFile(String string2, JSONObject jSONObject) {
        if (!string2.isEmpty()) {
            this.planTripRepository.encodePlanTripToFit(jSONObject, string2);
            return true;
        }
        return false;
    }

    private boolean updateFitData(String string2, String string3, String string4, String string5, JSONObject jSONObject) {
        if (!string3.isEmpty()) {
            this.planTripRepository.updatePlanTripToServer(string2, string3, string4, string5, jSONObject);
            return true;
        }
        return false;
    }

    public JSONObject concatPointAndTurn(JSONObject jSONObject, JSONArray jSONArray) {
        try {
            jSONArray = new JSONObject(this.graphhopperTurnCombineObj.toString());
            jSONArray.put("version", (Object)jSONObject.getJSONObject("version"));
            jSONArray.put("points", (Object)this.graphhopperTurnCombineObj.getJSONArray("points"));
            jSONArray.put("distance", jSONObject.getDouble("distance"));
            jSONArray.put("steps", (Object)this.graphhopperTurnCombineObj.getJSONArray("steps"));
            jSONArray.put("gain", jSONObject.getDouble("gain"));
            jSONArray.put("loss", jSONObject.getDouble("loss"));
            jSONObject = jSONArray;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            jSONObject = null;
        }
        return jSONObject;
    }

    public void concatTurnByTurn(JSONObject jSONObject) {
        block18: {
            JSONObject jSONObject2 = this.graphhopperTurnCombineObj;
            if (jSONObject2 == null) {
                this.graphhopperTurnCombineObj = jSONObject;
            } else {
                int n;
                int n2;
                JSONArray jSONArray;
                block17: {
                    block16: {
                        block15: {
                            boolean bl = jSONObject2.has("points");
                            jSONObject2 = null;
                            if (!bl) break block15;
                            jSONArray = this.graphhopperTurnCombineObj.getJSONArray("points");
                            n2 = jSONArray.length();
                            break block16;
                        }
                        jSONArray = null;
                        n2 = 0;
                    }
                    if (this.graphhopperTurnCombineObj.has("steps")) {
                        jSONObject2 = this.graphhopperTurnCombineObj.getJSONArray("steps");
                    }
                    if (!jSONObject.has("points")) break block17;
                    JSONArray jSONArray2 = jSONObject.getJSONArray("points");
                    if (jSONArray == null) break block17;
                    if (jSONArray2.length() <= 0) break block17;
                    n = 0;
                    while (true) {
                        if (n >= jSONArray2.length()) break;
                        jSONArray.put((Object)jSONArray2.getJSONObject(n));
                        ++n;
                        continue;
                        break;
                    }
                }
                if (!jSONObject.has("steps")) break block18;
                jSONArray = jSONObject.getJSONArray("steps");
                if (jSONObject2 == null) break block18;
                try {
                    if (jSONArray.length() <= 0) break block18;
                    n = 0;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                while (true) {
                    if (n < jSONArray.length()) {
                        jSONObject = jSONArray.getJSONArray(n);
                        jSONObject.put(0, jSONObject.getInt(0) + n2);
                        jSONObject2.put((Object)jSONObject);
                        ++n;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public void concatTurnByTurnToDecodeObj(JSONObject jSONObject) {
    }

    public void countClimbGrade(int[] nArray) {
        int n;
        int n2;
        ArrayList<ClimbGrade> arrayList = new ArrayList<ClimbGrade>();
        int n3 = nArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n2];
            arrayList.add(new ClimbGrade(n, this.pointsArray.get((int)n).lng, this.pointsArray.get((int)n).lat, this.pointsArray.get((int)n).alt));
        }
        for (n2 = 1; n2 < arrayList.size(); ++n2) {
            int n4 = n2 - 1;
            n = ((ClimbGrade)arrayList.get((int)n2)).trackIndex;
            double d = this.altitudeList.get((int)n).distance - this.altitudeList.get((int)n3).distance;
            d = Math.abs(((ClimbGrade)arrayList.get((int)n2)).alt - ((ClimbGrade)arrayList.get((int)n4)).alt) * 100.0 / d;
            for (n3 = ((ClimbGrade)arrayList.get((int)n4)).trackIndex; n3 < n; ++n3) {
                this.pointsArray.get((int)n3).grade = d;
            }
            if (n2 != arrayList.size() - 1) continue;
            this.pointsArray.get((int)n2).grade = d;
        }
    }

    public void decodePlanTripFitForDetail(Route object) {
        String string2 = ((Route)object).id;
        String string3 = ProfileUtil.getInstance().getPrefString("userId");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append("/plantrip");
        stringBuilder.append(File.separator);
        stringBuilder.append(string2);
        stringBuilder.append(".fit");
        String string4 = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(App.getInstance().getFilesDir());
        stringBuilder.append(File.separator);
        stringBuilder.append(string4);
        if (new File(stringBuilder.toString()).exists()) {
            object = this.planTripRepository;
            stringBuilder = new StringBuilder();
            stringBuilder.append(string3);
            stringBuilder.append("/plantrip");
            string2 = ((PlanTripRepository)object).decodePlanTripFitForDetail(string2, stringBuilder.toString(), string2);
            this.decodeObj = string2;
            if (string2.has("distance")) {
                try {
                    double d = string2.getDouble("distance");
                    this.route.distance = (float)d;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            new DecimalFormat("####.#");
            object = this.route;
            ((Route)object).altitude = ((Route)object).altitude;
            object = null;
            try {
                string2 = string2.getJSONArray("points");
                object = string2;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.prepareChart((JSONArray)object);
            Log.d((String)TAG, (String)"decodePlanTripFitForDetail: \u6709\u8def\u7dda Fit \u6a94\uff0cdecode \u5b8c\u6210");
            this.planTripDecodeLiveData.postValue(true);
        } else {
            this.planTripDecodeLiveData.postValue(false);
            Log.d((String)TAG, (String)"decodePlanTripFitForDetail: \u6c92\u6709\u8def\u7dda Fit \u6a94\uff0c\u53bb\u4e0b\u8f09");
            this.planTripRepository.getPlanTripFile(string2, ((Route)object).url);
        }
    }

    public void deleteCurrentFitFile(String object) {
        CharSequence charSequence = ProfileUtil.getInstance().getPrefString("userId");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)charSequence);
        stringBuilder.append("/plantrip");
        stringBuilder.append(File.separator);
        stringBuilder.append((String)object);
        stringBuilder.append(".fit");
        object = stringBuilder.toString();
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(App.getInstance().getFilesDir());
        ((StringBuilder)charSequence).append(File.separator);
        ((StringBuilder)charSequence).append((String)object);
        object = new File(((StringBuilder)charSequence).toString());
        if (((File)object).exists()) {
            ((File)object).delete();
        }
    }

    public void deletePlanTrip() {
        Route route = this.route;
        if (route != null) {
            this.planTripRepository.deletePlanTrip(route);
        }
    }

    public boolean encodeAndUploadTurnByTrunFit() {
        this.arrayListJsonPoints.clear();
        this.arrayListStartIdx.clear();
        this.currentGetTurnByTurnIdx = -1;
        this.arrayListConvertedTurns.clear();
        JSONObject jSONObject = this.decodeObj;
        if (jSONObject != null && jSONObject.has("points")) {
            jSONObject = null;
            try {
                JSONArray jSONArray = this.decodeObj.getJSONArray("points");
                jSONObject = jSONArray;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            if (jSONObject != null && jSONObject.length() > 0) {
                if (jSONObject.length() <= 700) {
                    this.arrayListJsonPoints.add((JSONArray)jSONObject);
                } else {
                    int n = jSONObject.length();
                    int n2 = 0;
                    boolean bl = false;
                    int n3 = 0;
                    while (n2 == 0 && !bl) {
                        int n4;
                        int n5 = this.arrayListJsonPoints.size() == 0 ? 0 : n3 - 2;
                        n3 = n5 + 700;
                        if (n3 >= n) {
                            n3 = n;
                        }
                        JSONArray jSONArray = new JSONArray();
                        for (n4 = n5; n4 < n3; ++n4) {
                            try {
                                jSONArray.put(jSONObject.get(n4));
                                continue;
                            }
                            catch (JSONException jSONException) {
                                jSONException.printStackTrace();
                                bl = true;
                            }
                        }
                        n4 = n2;
                        if (!bl) {
                            this.arrayListJsonPoints.add(jSONArray);
                            this.arrayListStartIdx.add(n5);
                            n4 = n2;
                            if (n3 >= n) {
                                n4 = 1;
                            }
                        }
                        n2 = n4;
                    }
                    if (bl) {
                        Log.e((String)"=======", (String)"Failed to separate fit point");
                    }
                }
                return this.runNextTurnByTurnConvert();
            }
        }
        return false;
    }

    public ArrayList<RoutePoint> getConvertedTurnList() {
        return this.arrayListConvertedTurns;
    }

    public String getFilenameToUpload() {
        return this.filenameToUpload;
    }

    public MutableLiveData<Boolean> getIsPlanTripUpdateLiveData() {
        return this.planTripRepository.getIsPlanTripUpdateLiveData();
    }

    public MutableLiveData<Boolean> getIsPlanTripUploadLiveData() {
        return this.planTripRepository.getIsPlanTripUploadLiveData();
    }

    public RouteClimb getNewRouteClimb(Entry entry, Entry entry2) {
        double d = DistanceUtil.distanceMeteor2Km(this.altitudeList.get((int)((int)entry.getX())).distance);
        double d2 = DistanceUtil.distanceMeteor2Km(this.altitudeList.get((int)((int)entry2.getX())).distance);
        float f = Float.valueOf((float)d).floatValue();
        float f2 = Float.valueOf((float)(d2 - d)).floatValue();
        float f3 = entry2.getY();
        float f4 = entry.getY();
        return new RouteClimb(Utils.convertKM(f), Utils.getUnitByKM(), Utils.convertKM(f2), Utils.getUnitByKM(), Utils.convertM(f3 - f4), Utils.getUnitByM(), entry, entry2);
    }

    public MutableLiveData<Boolean> getPlanTripDecodeLiveData() {
        return this.planTripDecodeLiveData;
    }

    public MutableLiveData<Boolean> getPlanTripDeleteResultLive() {
        return this.planTripRepository.getPlanTripDeleteResultLive();
    }

    public MutableLiveData<Boolean> getPlanTripFitDownloadLiveData() {
        return this.planTripRepository.getPlanTripFitDownloadLiveData();
    }

    public int getRunningTurnByTurnStartIdx() {
        if (this.currentGetTurnByTurnIdx >= this.arrayListStartIdx.size()) {
            return 0;
        }
        return this.arrayListStartIdx.get(this.currentGetTurnByTurnIdx);
    }

    public int getRunningTurnByTurnStartIdxByResult() {
        Object object = this.partStartIdxList;
        int n = 0;
        int n2 = 0;
        int n3 = n;
        if (object != null) {
            n3 = n;
            if (((ArrayList)object).size() > 0) {
                object = this.partStartIdxList.iterator();
                while (true) {
                    n3 = n2;
                    if (!object.hasNext()) break;
                    n2 += ((Integer)object.next()).intValue();
                }
            }
        }
        return n3;
    }

    public MutableLiveData<JSONObject> getTurnByTurnResultLiveData() {
        return this.placeRepository.getTurnByTurnResultLiveData();
    }

    public boolean isRouteAlreadyTurnByTurn() {
        Object object = this.route;
        boolean bl = object != null && ((Route)object).provider != null && !this.route.provider.isEmpty() ? this.route.isRouteAlreadyTurnByTurn() : false;
        object = PlanTripUtil.readPlanTripTurnFromPref(this.route.id);
        if (object != null) {
            bl = (Boolean)object;
        }
        return bl;
    }

    public boolean runNextTurnByTurnConvert() {
        boolean bl;
        block4: {
            int n = this.currentGetTurnByTurnIdx++;
            boolean bl2 = true;
            int n2 = this.arrayListJsonPoints.size();
            bl = false;
            if (n + 1 >= n2) {
                return false;
            }
            Object object = new JSONObject();
            object.put("points", (Object)this.arrayListJsonPoints.get(this.currentGetTurnByTurnIdx));
            object = this.placeRepository.decodeJson2GpxStr((JSONObject)object);
            if (object == null) break block4;
            try {
                if (((String)object).isEmpty()) break block4;
                this.placeRepository.gpx2TurnByTurnJson((String)object);
                bl = bl2;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        bl = false;
        return bl;
    }

    public void sendPlanTripNameToDevice() {
        String string2 = this.route.name;
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.plantrip.name");
        jSONArray.put((Object)string2);
        this.bleRepository.passSettingCommand(jSONArray);
    }

    public void sendPlanTripToDevice(int n) {
        Object object = this.route.name;
        object = this.route.id;
        JSONObject jSONObject = this.decodeObj;
        if (jSONObject != null) {
            PlanTripRepository planTripRepository = this.planTripRepository;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)object);
            stringBuilder.append(".fit");
            planTripRepository.encodePlanTripToFit(jSONObject, stringBuilder.toString());
            object = this.planTripRepository.loadPlanTripFit2ByteArray((String)object);
            if (((Object)object).length > 0) {
                this.bleRepository.postData(11, (byte[])object);
            }
        }
    }

    public void setClimbsData(String object) {
        int n;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        block10: {
            arrayList2 = new ArrayList<String>();
            arrayList = new ArrayList<String>();
            String string2 = (String)ProfileUtil.getInstance().get((String)object);
            int n2 = 0;
            if (string2 != null && !string2.isEmpty()) {
                try {
                    object = new JSONArray(string2);
                    n = 0;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                while (true) {
                    block12: {
                        int n3;
                        block11: {
                            if (n >= object.length()) break block10;
                            string2 = object.getJSONArray(n);
                            int n4 = string2.getInt(0);
                            n3 = string2.getInt(1);
                            string2 = new Entry();
                            string2.setX((float)n4);
                            float f = this.altitudeList.size() > n4 ? this.altitudeList.get((int)n4).meter : 0.0f;
                            string2.setY(f);
                            if (n3 != 190) break block11;
                            arrayList2.add(string2);
                            break block12;
                        }
                        if (n3 == 191) {
                            arrayList.add(string2);
                        }
                    }
                    ++n;
                }
            }
        }
        Collections.sort(arrayList2, new Comparator<Entry>(){

            @Override
            public int compare(Entry entry, Entry entry2) {
                int n = entry.getX() > entry2.getX() ? 1 : -1;
                return n;
            }
        });
        Collections.sort(arrayList, new Comparator<Entry>(){

            @Override
            public int compare(Entry entry, Entry entry2) {
                int n = entry.getX() > entry2.getX() ? 1 : -1;
                return n;
            }
        });
        for (n = n2; n < arrayList2.size(); ++n) {
            object = this.getNewRouteClimb((Entry)arrayList2.get(n), (Entry)arrayList.get(n));
            this.routeClimbs.add((RouteClimb)object);
        }
    }

    public void setClimbsData(ArrayList<ArrayList<Double>> arrayList) {
        this.routeClimbs.clear();
        this.routeClimbs.add(null);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object = arrayList.get(i);
            object = this.getNewRouteClimb(this.getEntry((int)Math.round(((ArrayList)object).get(0))), this.getEntry((int)Math.round(((ArrayList)object).get(1))));
            this.routeClimbs.add((RouteClimb)object);
        }
    }

    public void setFilenameToUpload(String string2) {
        this.filenameToUpload = string2;
    }

    public CourseRouteDetailViewModel setRoute(Route route) {
        this.route = route;
        return this;
    }

    public void setRunningTurnByTurnStartIdx(JSONObject jSONObject) {
        int n;
        block3: {
            if (jSONObject != null && jSONObject.has("points")) {
                try {
                    n = jSONObject.getJSONArray("points").length();
                    break block3;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            n = 0;
        }
        this.partStartIdxList.add(n);
    }

    public boolean updateFit(final JSONObject jSONObject) {
        final JSONObject jSONObject2 = this.getAbstract(jSONObject);
        if (jSONObject2 != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Object object = ProfileUtil.getInstance().getPrefString("userId");
                    Object object2 = new StringBuilder();
                    ((StringBuilder)object2).append((String)object);
                    ((StringBuilder)object2).append(File.separator);
                    ((StringBuilder)object2).append("plantrip");
                    ((StringBuilder)object2).append(File.separator);
                    ((StringBuilder)object2).append(CourseRouteDetailViewModel.this.route.id);
                    String string2 = ((StringBuilder)object2).toString();
                    object2 = CourseRouteDetailViewModel.this;
                    object = new StringBuilder();
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append(".fit");
                    boolean bl = ((CourseRouteDetailViewModel)object2).saveAsFitFile(((StringBuilder)object).toString(), jSONObject);
                    boolean bl2 = true;
                    if (bl) {
                        object = CourseRouteDetailViewModel.this;
                        bl2 = true ^ ((CourseRouteDetailViewModel)object).updateFitData(((CourseRouteDetailViewModel)object).route.id, CourseRouteDetailViewModel.this.route.name, CourseRouteDetailViewModel.this.route.provider, CourseRouteDetailViewModel.this.route.orgID, jSONObject2);
                    }
                    if (bl2) {
                        Log.e((String)"RouteDetail", (String)"Could not update fit");
                    }
                }
            }).start();
        }
        return true;
    }

    public boolean uploadFit(String charSequence, final JSONObject jSONObject) {
        final JSONObject jSONObject2 = this.getAbstract(jSONObject);
        final String string2 = charSequence;
        if (((String)charSequence).isEmpty()) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(this.route.name);
            ((StringBuilder)charSequence).append("-1");
            string2 = ((StringBuilder)charSequence).toString();
        }
        if (jSONObject2 != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    CourseRouteDetailViewModel courseRouteDetailViewModel = CourseRouteDetailViewModel.this;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string2);
                    stringBuilder.append(".fit");
                    boolean bl = courseRouteDetailViewModel.saveAsFitFile(stringBuilder.toString(), jSONObject);
                    boolean bl2 = true;
                    if (bl) {
                        bl2 = true ^ CourseRouteDetailViewModel.this.uploadFitData(string2, jSONObject2);
                    }
                    if (bl2) {
                        Log.e((String)"=======", (String)"Could not upload fit");
                    }
                }
            }).start();
        }
        return true;
    }

    public boolean uploadFitData(String string2, JSONObject jSONObject) {
        if (!string2.isEmpty()) {
            this.planTripRepository.uploadToServer(string2, PlanTripUtil.getTurnByTurnProvider(this.route.provider), this.route.orgID, jSONObject);
            return true;
        }
        return false;
    }
}

