/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.course;

import android.content.Context;
import android.location.Location;
import android.util.Log;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.db.course.entity.CourseSearchHistoryEntity;
import com.brytonsport.active.repo.course.PlaceRepository;
import com.brytonsport.active.repo.course.SearchHistoryRepository;
import com.brytonsport.active.utils.MyFavIniFileUtil;
import com.brytonsport.active.utils.SettingLanguageUtil;
import com.brytonsport.active.vm.base.Favorite;
import com.brytonsport.active.vm.base.SearchResult;
import com.james.easyinternet.EasyResponseObjectParser;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.json.JSONObject;

public class CourseSearchViewModel
extends BaseViewModel {
    static final String TAG = "CourseSearchViewModel";
    public static final int TYPE_OFFSET = 3;
    public static final int TYPE_SEARCH = 2;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_TITLE = 0;
    public ArrayList<SearchResult> mDefaultsList;
    @Inject
    PlaceRepository placeRepository;
    @Inject
    SearchHistoryRepository searchHistoryRepository;
    private SearchObj searchObj = new SearchObj();

    @Inject
    public CourseSearchViewModel() {
        this.mDefaultsList = new ArrayList();
        this.searchObj = new SearchObj();
    }

    public void addNewSearchHistory(String string2) {
        if (string2 != null && !string2.isEmpty()) {
            string2 = string2.trim();
            this.searchHistoryRepository.addNewSearchHistory(string2);
        }
    }

    public ArrayList<SearchResult> getDefaultResults() {
        return this.searchObj.defaults;
    }

    public MutableLiveData<JSONObject> getSearchPoiListLiveData() {
        return this.placeRepository.getSearchPoiListLiveData();
    }

    public ArrayList<SearchResult> getSearchResults(String string2) {
        return this.searchObj.searches;
    }

    public LiveData<List<CourseSearchHistoryEntity>> loadSearchHistoryListLive() {
        return this.searchHistoryRepository.loadSearchHistoryListLive();
    }

    public void searchPoiUseTextSearch(double d, double d2, String string2) {
        String string3 = SettingLanguageUtil.getGoogleSearchApiLangCode();
        String string4 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("searchPoiUseTextSearch \u641c\u5c0b: ");
        stringBuilder.append(string2);
        stringBuilder.append(", langCode: ");
        stringBuilder.append(string3);
        Log.d((String)string4, (String)stringBuilder.toString());
        new Date().getTime();
        this.placeRepository.searchPoiUseTextSearch(d, d2, string2, string3);
    }

    public void updateDefaults(Context object, Location location) {
        if (((ArrayList)(object = MyFavIniFileUtil.getMyFavListFromDevice((Context)object, location))).size() > 0) {
            this.searchObj.defaults.add(new SearchResult(0, 2131165510, App.get("Favorites"), "", ""));
        }
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            Favorite favorite = (Favorite)iterator.next();
            object = favorite.distance.split(" ");
            if (object != null && ((Object)object).length > 0) {
                String string2 = new DecimalFormat("#####.##").format(Double.parseDouble((String)object[0]));
                object = ((Object)object).length > 1 ? object[1] : "km";
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2);
                stringBuilder.append(" ");
                stringBuilder.append((String)object);
                object = stringBuilder.toString();
            } else {
                object = favorite.distance;
            }
            this.searchObj.defaults.add(new SearchResult(1, -1, favorite.name, favorite.address, (String)object, true, favorite.lat, favorite.lon, location.getLatitude(), location.getLongitude()));
        }
        if (this.mDefaultsList.size() != 0 && this.searchObj.defaults.size() != 0) {
            this.mDefaultsList.clear();
        }
        this.mDefaultsList.addAll(this.searchObj.defaults);
    }

    public void updateSearchResult(String string2) {
        SearchObj searchObj;
        this.searchObj = searchObj = new SearchObj();
        try {
            EasyResponseObjectParser.startParsing((String)string2, (Object)searchObj);
            Log.d((String)TAG, (String)"updateSearchResult: ");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class SearchObj {
        public ArrayList<SearchResult> defaults = new ArrayList();
        public ArrayList<SearchResult> searches = new ArrayList();
    }
}

