/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.course;

import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.repo.course.WorkoutRepository;
import com.brytonsport.active.repo.course.WorkoutRepositoryHandler;
import com.brytonsport.active.vm.base.TrainingPlan;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONObject;

public class CourseWorkoutPlanEditViewModel
extends BaseViewModel {
    @Inject
    BleRepository bleRepository;
    public JSONObject decodeObj = new JSONObject();
    public TrainingPlan trainingPlan;
    @Inject
    WorkoutRepository workoutRepository;

    @Inject
    public CourseWorkoutPlanEditViewModel() {
    }

    public void createWorkout(WorkoutRepositoryHandler workoutRepositoryHandler) {
        this.workoutRepository.createWorkout(this.trainingPlan, workoutRepositoryHandler);
    }

    public void loadWorkoutDetail(final TrainingPlan trainingPlan, final WorkoutRepositoryHandler workoutRepositoryHandler) {
        this.trainingPlan = trainingPlan;
        this.workoutRepository.downloadWorkoutFile(trainingPlan, new WorkoutRepositoryHandler(){

            @Override
            public void onComplete() {
                trainingPlan.loadWorkoutJSON();
                workoutRepositoryHandler.onComplete();
            }

            @Override
            public void onFail() {
                workoutRepositoryHandler.onFail();
            }
        });
    }

    public void sendWorkoutEndingNotifyToDevice(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.workout.send_end");
        jSONArray.put(n);
        jSONArray.put(0);
        this.bleRepository.passSettingCommand(jSONArray);
    }

    public void sendWorkoutJsonToDevice() {
        Object object = this.trainingPlan.name;
        JSONObject jSONObject = this.decodeObj;
        if (jSONObject != null) {
            this.workoutRepository.encodeWorkoutToFit(jSONObject, (String)object);
            object = this.workoutRepository.loadWorkoutFit2ByteArray((String)object);
            if (((Object)object).length > 0) {
                this.bleRepository.postData(15, (byte[])object);
            }
        }
    }

    public void sendWorkoutToDevice() {
        Object object = this.trainingPlan.name;
        JSONObject jSONObject = this.decodeObj;
        if (jSONObject != null) {
            this.workoutRepository.encodeWorkoutToFit(jSONObject, (String)object);
            object = this.workoutRepository.loadWorkoutFit2ByteArray((String)object);
            if (((Object)object).length > 0) {
                this.bleRepository.postData(9, (byte[])object);
            }
        }
    }

    public void updateWorkout(Boolean bl, WorkoutRepositoryHandler workoutRepositoryHandler) {
        this.workoutRepository.updateWorkout(this.trainingPlan, bl, workoutRepositoryHandler);
    }
}

