/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.course;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.repo.BleBroadcastReceiver;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.repo.course.WorkoutRepository;
import com.brytonsport.active.repo.course.WorkoutRepositoryHandler;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.utils.FeatureUtil;
import com.brytonsport.active.vm.base.TrainingPlan;
import com.brytonsport.active.vm.course.CourseWorkoutPlanViewModel$$ExternalSyntheticLambda0;
import java.io.UnsupportedEncodingException;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CourseWorkoutPlanViewModel
extends BaseViewModel {
    @Inject
    BleRepository bleRepository;
    private final BleBroadcastReceiver mGattUpdateReceiver;
    private SyncListener syncListener = null;
    private SyncToDeviceStep syncStep = SyncToDeviceStep.idle;
    public TrainingPlan trainingPlan;
    @Inject
    WorkoutRepository workoutRepository;

    @Inject
    public CourseWorkoutPlanViewModel() {
        this.mGattUpdateReceiver = new BleBroadcastReceiver(){

            @Override
            public void onCommandAck(int n) {
                if (n == 70) {
                    if (CourseWorkoutPlanViewModel.this.syncStep == SyncToDeviceStep.sendingStart) {
                        CourseWorkoutPlanViewModel.access$002(CourseWorkoutPlanViewModel.this, SyncToDeviceStep.sendingWorkout);
                        CourseWorkoutPlanViewModel.this.sendWorkoutToDevice();
                    } else if (CourseWorkoutPlanViewModel.this.syncStep == SyncToDeviceStep.sendingEnd) {
                        CourseWorkoutPlanViewModel.access$002(CourseWorkoutPlanViewModel.this, SyncToDeviceStep.idle);
                        CourseWorkoutPlanViewModel.this.syncListener.onComplete();
                        CourseWorkoutPlanViewModel.access$202(CourseWorkoutPlanViewModel.this, null);
                    }
                }
            }

            @Override
            public void onDataPost(int n) {
                if (n == 9) {
                    if (CourseWorkoutPlanViewModel.this.syncStep == SyncToDeviceStep.sendingWorkout) {
                        CourseWorkoutPlanViewModel.this.sendWorkoutJsonToDevice();
                    } else {
                        CourseWorkoutPlanViewModel.this.sendWorkoutEnd();
                    }
                } else if (n == 15) {
                    CourseWorkoutPlanViewModel.this.sendWorkoutEnd();
                }
            }
        };
    }

    static /* synthetic */ SyncToDeviceStep access$002(CourseWorkoutPlanViewModel courseWorkoutPlanViewModel, SyncToDeviceStep syncToDeviceStep) {
        courseWorkoutPlanViewModel.syncStep = syncToDeviceStep;
        return syncToDeviceStep;
    }

    static /* synthetic */ SyncListener access$202(CourseWorkoutPlanViewModel courseWorkoutPlanViewModel, SyncListener syncListener) {
        courseWorkoutPlanViewModel.syncListener = syncListener;
        return syncListener;
    }

    private void sendWorkoutEnd() {
        if (this.syncStep == SyncToDeviceStep.sendingWorkout) {
            this.syncStep = SyncToDeviceStep.sendingEnd;
            this.sendWorkoutEndingNotifyToDevice(0);
        } else {
            this.syncStep = SyncToDeviceStep.idle;
            SyncListener syncListener = this.syncListener;
            if (syncListener != null) {
                syncListener.onComplete();
                this.syncListener = null;
            }
        }
    }

    private void sendWorkoutEndingNotifyToDevice(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.workout.send_end");
        jSONArray.put(n);
        jSONArray.put(0);
        this.bleRepository.passSettingCommand(jSONArray);
    }

    private void sendWorkoutJsonToDevice() {
        Object object = this.trainingPlan.createInfoJson();
        try {
            object = object.toString().getBytes("utf-8");
            if (((JSONObject)object).length > 0) {
                this.bleRepository.postData(15, (byte[])object);
            } else {
                this.sendWorkoutEnd();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    private void sendWorkoutToDevice() {
        this.workoutRepository.downloadWorkoutFit2ByteArray(this.trainingPlan, new WorkoutRepositoryHandler(){

            @Override
            public void onDownloadedWorkoutFitBytes(byte[] byArray) {
                if (byArray.length > 0) {
                    CourseWorkoutPlanViewModel.this.bleRepository.postData(9, byArray);
                } else {
                    CourseWorkoutPlanViewModel.this.sendWorkoutEnd();
                }
            }
        });
    }

    public /* synthetic */ void lambda$sendWorkoutsToDevice$0$com-brytonsport-active-vm-course-CourseWorkoutPlanViewModel() {
        if (DeviceRepository.getInstance().deviceFeatureSupportSync(FeatureUtil.FeatureType.WorkoutJson) > 0) {
            this.syncStep = SyncToDeviceStep.sendingStart;
            this.sendWorkoutEndingNotifyToDevice(1);
        } else {
            this.syncStep = SyncToDeviceStep.sendingWorkoutWithoutJson;
            this.sendWorkoutToDevice();
        }
    }

    public void registerBLEReceiver(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.brytonsport.active.SERVICE_SETTING_COMMAND_RETURN");
        intentFilter.addAction("com.brytonsport.active.SERVICE_POST_DATA");
        context.registerReceiver((BroadcastReceiver)this.mGattUpdateReceiver, intentFilter);
    }

    public void sendWorkoutsToDevice(SyncListener syncListener) {
        this.syncListener = syncListener;
        new Thread(new CourseWorkoutPlanViewModel$$ExternalSyntheticLambda0(this)).start();
    }

    public void unregisterBLEReceiver(Context context) {
        context.unregisterReceiver((BroadcastReceiver)this.mGattUpdateReceiver);
    }

    public static class SyncListener {
        public void onComplete() {
        }
    }

    public static final class SyncToDeviceStep
    extends Enum<SyncToDeviceStep> {
        private static final /* synthetic */ SyncToDeviceStep[] $VALUES;
        public static final /* enum */ SyncToDeviceStep idle;
        public static final /* enum */ SyncToDeviceStep sendingEnd;
        public static final /* enum */ SyncToDeviceStep sendingStart;
        public static final /* enum */ SyncToDeviceStep sendingWorkout;
        public static final /* enum */ SyncToDeviceStep sendingWorkoutWithoutJson;

        static {
            SyncToDeviceStep syncToDeviceStep;
            SyncToDeviceStep syncToDeviceStep2;
            SyncToDeviceStep syncToDeviceStep3;
            SyncToDeviceStep syncToDeviceStep4;
            SyncToDeviceStep syncToDeviceStep5;
            idle = syncToDeviceStep5 = new SyncToDeviceStep();
            sendingStart = syncToDeviceStep4 = new SyncToDeviceStep();
            sendingWorkout = syncToDeviceStep3 = new SyncToDeviceStep();
            sendingEnd = syncToDeviceStep2 = new SyncToDeviceStep();
            sendingWorkoutWithoutJson = syncToDeviceStep = new SyncToDeviceStep();
            $VALUES = new SyncToDeviceStep[]{syncToDeviceStep5, syncToDeviceStep4, syncToDeviceStep3, syncToDeviceStep2, syncToDeviceStep};
        }

        public static SyncToDeviceStep valueOf(String string2) {
            return Enum.valueOf(SyncToDeviceStep.class, string2);
        }

        public static SyncToDeviceStep[] values() {
            return (SyncToDeviceStep[])$VALUES.clone();
        }
    }
}

