/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.course;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.account.vo.AccountUserInfo;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.repo.BleBroadcastReceiver;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.repo.account.LoginRepository;
import com.brytonsport.active.repo.course.WorkoutRepository;
import com.brytonsport.active.repo.course.WorkoutRepositoryHandler;
import com.brytonsport.active.repo.profile.Connect3rdPartyRepository;
import com.brytonsport.active.repo.profile.Connect3rdPartyRepositoryHandler;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.utils.FeatureUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.vm.base.TrainingPlan;
import com.brytonsport.active.vm.course.CourseWorkoutViewModel$$ExternalSyntheticLambda0;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CourseWorkoutViewModel
extends BaseViewModel {
    @Inject
    BleRepository bleRepository;
    @Inject
    Connect3rdPartyRepository connect3rdPartyRepository;
    public ArrayList<TrainingPlan> defaultWorkouts;
    @Inject
    DeviceRepository deviceRepository;
    @Inject
    LoginRepository loginRepository;
    private final BleBroadcastReceiver mGattUpdateReceiver;
    private ArrayList<TrainingPlan> sendingPlans;
    private SyncListener syncListener = null;
    private SyncToDeviceStep syncStep;
    private ArrayList<TrainingPlan> uploadingTrainingPeaksWorkouts;
    @Inject
    WorkoutRepository workoutRepository;
    public ArrayList<TrainingPlan> workouts = new ArrayList();

    @Inject
    public CourseWorkoutViewModel() {
        this.defaultWorkouts = new ArrayList();
        this.sendingPlans = new ArrayList();
        this.uploadingTrainingPeaksWorkouts = new ArrayList();
        this.syncStep = SyncToDeviceStep.idle;
        this.mGattUpdateReceiver = new BleBroadcastReceiver(){

            @Override
            public void onCommandAck(int n) {
                if (n == 70) {
                    if (CourseWorkoutViewModel.this.syncStep == SyncToDeviceStep.sendingStart) {
                        CourseWorkoutViewModel.access$002(CourseWorkoutViewModel.this, SyncToDeviceStep.sendingWorkout);
                        CourseWorkoutViewModel.this.sendWorkoutToDevice();
                    } else if (CourseWorkoutViewModel.this.syncStep == SyncToDeviceStep.sendingEnd) {
                        CourseWorkoutViewModel.access$002(CourseWorkoutViewModel.this, SyncToDeviceStep.idle);
                        CourseWorkoutViewModel.this.syncListener.onComplete();
                        CourseWorkoutViewModel.access$202(CourseWorkoutViewModel.this, null);
                    }
                }
            }

            @Override
            public void onDataPost(int n) {
                if (n == 9) {
                    if (CourseWorkoutViewModel.this.syncStep == SyncToDeviceStep.sendingWorkout) {
                        CourseWorkoutViewModel.this.sendWorkoutJsonToDevice();
                    } else {
                        CourseWorkoutViewModel.this.sendWorkoutToDevice();
                    }
                } else if (n == 15) {
                    CourseWorkoutViewModel.this.sendWorkoutToDevice();
                }
            }
        };
    }

    static /* synthetic */ SyncToDeviceStep access$002(CourseWorkoutViewModel courseWorkoutViewModel, SyncToDeviceStep syncToDeviceStep) {
        courseWorkoutViewModel.syncStep = syncToDeviceStep;
        return syncToDeviceStep;
    }

    static /* synthetic */ SyncListener access$202(CourseWorkoutViewModel courseWorkoutViewModel, SyncListener syncListener) {
        courseWorkoutViewModel.syncListener = syncListener;
        return syncListener;
    }

    static /* synthetic */ ArrayList access$302(CourseWorkoutViewModel courseWorkoutViewModel, ArrayList arrayList) {
        courseWorkoutViewModel.uploadingTrainingPeaksWorkouts = arrayList;
        return arrayList;
    }

    private void createTrainingPeaksWorkout(final String string2, TrainingPlan trainingPlan) {
        this.workoutRepository.createWorkout(trainingPlan, new WorkoutRepositoryHandler(){

            @Override
            public void onComplete() {
                CourseWorkoutViewModel.this.uploadTrainingPeaksWorkout(string2);
            }

            @Override
            public void onFail() {
                CourseWorkoutViewModel.this.uploadingTrainingPeaksWorkouts.clear();
                CourseWorkoutViewModel.this.getWorkoutList();
            }
        });
    }

    private void sendWorkoutEnd() {
        if (this.syncStep == SyncToDeviceStep.sendingWorkout) {
            this.syncStep = SyncToDeviceStep.sendingEnd;
            this.sendWorkoutEndingNotifyToDevice(0);
        } else {
            this.syncStep = SyncToDeviceStep.idle;
            SyncListener syncListener = this.syncListener;
            if (syncListener != null) {
                syncListener.onComplete();
                this.syncListener = null;
            }
        }
    }

    private void sendWorkoutEndingNotifyToDevice(int n) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.workout.send_end");
        jSONArray.put(n);
        jSONArray.put(1);
        this.bleRepository.passSettingCommand(jSONArray);
    }

    private void sendWorkoutToDevice() {
        if (this.sendingPlans.size() == 0) {
            this.sendWorkoutEnd();
            return;
        }
        TrainingPlan trainingPlan = this.syncStep == SyncToDeviceStep.sendingWorkoutWithoutJson ? this.sendingPlans.remove(0) : this.sendingPlans.get(0);
        this.workoutRepository.downloadWorkoutFit2ByteArray(trainingPlan, new WorkoutRepositoryHandler(){

            @Override
            public void onDownloadedWorkoutFitBytes(byte[] byArray) {
                if (byArray.length > 0) {
                    CourseWorkoutViewModel.this.bleRepository.postData(9, byArray);
                } else {
                    CourseWorkoutViewModel.this.sendWorkoutEnd();
                }
            }
        });
    }

    private void uploadTrainingPeaksWorkout(final String string2) {
        if (this.uploadingTrainingPeaksWorkouts.size() == 0) {
            this.getWorkoutList();
            return;
        }
        final TrainingPlan trainingPlan = this.uploadingTrainingPeaksWorkouts.remove(0);
        this.connect3rdPartyRepository.getTrainingPeaksWorkoutFit(string2, trainingPlan.orgId, new Connect3rdPartyRepositoryHandler(){

            @Override
            public void onComplete() {
                if (trainingPlan.hasZwo.booleanValue()) {
                    CourseWorkoutViewModel.this.connect3rdPartyRepository.getTrainingPeaksWorkoutZwo(string2, trainingPlan.orgId, new Connect3rdPartyRepositoryHandler(){

                        @Override
                        public void onComplete() {
                            String string2 = ProfileUtil.getInstance().getPrefString("userId");
                            CharSequence charSequence = new StringBuilder();
                            charSequence.append(App.getInstance().getFilesDir());
                            charSequence.append(File.separator);
                            charSequence.append(string2);
                            charSequence.append("/workout_tp");
                            charSequence.append(File.separator);
                            charSequence.append(trainingPlan.orgId);
                            charSequence.append(".zwo");
                            charSequence = charSequence.toString();
                            trainingPlan.id = trainingPlan.orgId;
                            trainingPlan.loadWorkoutJSON();
                            trainingPlan.loadTPZwo((String)charSequence);
                            CourseWorkoutViewModel.this.createTrainingPeaksWorkout(string2, trainingPlan);
                        }

                        @Override
                        public void onFail() {
                        }
                    });
                } else {
                    TrainingPlan trainingPlan2 = trainingPlan;
                    trainingPlan2.id = trainingPlan2.orgId;
                    trainingPlan.loadWorkoutJSON();
                    CourseWorkoutViewModel.this.createTrainingPeaksWorkout(string2, trainingPlan);
                }
            }

            @Override
            public void onFail() {
            }
        });
    }

    public void deleteWorkoutList(List<TrainingPlan> list) {
        this.workoutRepository.deleteWorkoutList(list);
    }

    public MutableLiveData<ArrayList<TrainingPlan>> getDefaultWorkoutListLiveData() {
        return this.workoutRepository.getDefaultWorkoutLiveData();
    }

    public void getDefaultWorkouts() {
        this.workoutRepository.getDefaultWorkouts();
    }

    public MutableLiveData<Boolean> getGetWorkoutDecodeJsonSaveLiveData() {
        return this.workoutRepository.getGetWorkoutDecodeJsonSaveLiveData();
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.workoutRepository.getLiveAccountErrorResponse();
    }

    public MutableLiveData<Connect3rdPartyRepository.Token2ServerResult> getToken2ServerLiveData() {
        return this.connect3rdPartyRepository.getToken2ServerLiveData();
    }

    public MutableLiveData<Boolean> getTrainingPeaksNeedRefreshToken() {
        return this.connect3rdPartyRepository.getTrainingPeaksNeedRefreshToken();
    }

    public MutableLiveData<ArrayList<TrainingPlan>> getTrainingPeaksResultLiveData() {
        return this.connect3rdPartyRepository.getTrainingPeaksLiveData();
    }

    public MutableLiveData<List<TrainingPlan>> getTrainingPlanListResultLiveData() {
        return this.workoutRepository.getTrainingPlanListResultLiveData();
    }

    public void getUserInfo() {
        this.loginRepository.getUserInfo();
    }

    public LiveData<AccountUserInfo> getUserInfoFromDb() {
        return this.loginRepository.loadUserInfoFromDb();
    }

    public MutableLiveData<Boolean> getWorkoutDeleteResultLive() {
        return this.workoutRepository.getWorkoutDeleteResultLive();
    }

    public void getWorkoutFile(String string2, String string3) {
        this.workoutRepository.getWorkoutFile(string2, string3, null);
    }

    public void getWorkoutList() {
        this.workoutRepository.getWorkoutList(null);
    }

    public Boolean isDeviceConnected() {
        return this.deviceRepository.isDeviceAlreadyConnectedSync();
    }

    public boolean isPlanTripFileExist(String string2) {
        String string3 = ProfileUtil.getInstance().getPrefString("userId");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append("/workout");
        stringBuilder.append(File.separator);
        stringBuilder.append(string2);
        stringBuilder.append(".fit");
        string2 = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(App.getInstance().getFilesDir());
        stringBuilder.append(File.separator);
        stringBuilder.append(string2);
        return new File(stringBuilder.toString()).exists();
    }

    public MutableLiveData<Boolean> isUserInfoSuccessLiveData() {
        return this.loginRepository.isUserInfoSuccessLiveData();
    }

    public /* synthetic */ void lambda$sendWorkoutsToDevice$0$com-brytonsport-active-vm-course-CourseWorkoutViewModel() {
        if (DeviceRepository.getInstance().deviceFeatureSupportSync(FeatureUtil.FeatureType.WorkoutJson) > 0) {
            this.syncStep = SyncToDeviceStep.sendingStart;
            this.sendWorkoutEndingNotifyToDevice(1);
        } else {
            this.syncStep = SyncToDeviceStep.sendingWorkoutWithoutJson;
            this.sendWorkoutToDevice();
        }
    }

    public void loadWorkoutDetail(TrainingPlan trainingPlan, WorkoutRepositoryHandler workoutRepositoryHandler) {
        this.workoutRepository.downloadWorkoutFile(trainingPlan, workoutRepositoryHandler);
    }

    public void refreshTrainingPeaksToken(String string2) {
        this.connect3rdPartyRepository.refreshTrainingPeaksToken(string2);
    }

    public void registerBLEReceiver(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.brytonsport.active.SERVICE_SETTING_COMMAND_RETURN");
        intentFilter.addAction("com.brytonsport.active.SERVICE_POST_DATA");
        context.registerReceiver((BroadcastReceiver)this.mGattUpdateReceiver, intentFilter);
    }

    public void sendWorkoutJsonToDevice() {
        Object object = this.sendingPlans.remove(0).createInfoJson();
        try {
            object = object.toString().getBytes("utf-8");
            if (((JSONObject)object).length > 0) {
                this.bleRepository.postData(15, (byte[])object);
            } else {
                this.sendWorkoutEnd();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void sendWorkoutsToDevice(ArrayList<TrainingPlan> arrayList, SyncListener syncListener) {
        this.sendingPlans = arrayList;
        this.syncListener = syncListener;
        new Thread(new CourseWorkoutViewModel$$ExternalSyntheticLambda0(this)).start();
    }

    public void syncTrainingPeaks(String string2) {
        String string3 = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        this.connect3rdPartyRepository.getTrainingPeaksWorkoutList(string2, string3);
    }

    public void unregisterBLEReceiver(Context context) {
        context.unregisterReceiver((BroadcastReceiver)this.mGattUpdateReceiver);
    }

    public void updateWorkout(TrainingPlan trainingPlan, WorkoutRepositoryHandler workoutRepositoryHandler) {
        this.workoutRepository.updateWorkout(trainingPlan, true, workoutRepositoryHandler);
    }

    public void uploadTrainingPeaksWorkouts(final String string2, final ArrayList<TrainingPlan> arrayList) {
        this.workoutRepository.getWorkoutList(new WorkoutRepositoryHandler(){

            @Override
            public void onComplete() {
                super.onComplete();
                ArrayList<TrainingPlan> arrayList2 = new ArrayList<TrainingPlan>();
                for (TrainingPlan trainingPlan : arrayList) {
                    Boolean bl;
                    block4: {
                        Boolean bl2;
                        Iterator<TrainingPlan> iterator;
                        block3: {
                            bl = false;
                            iterator = CourseWorkoutViewModel.this.workouts.iterator();
                            do {
                                bl2 = bl;
                                if (!iterator.hasNext()) break block3;
                            } while (!iterator.next().orgId.equals(trainingPlan.orgId));
                            bl2 = true;
                        }
                        iterator = CourseWorkoutViewModel.this.uploadingTrainingPeaksWorkouts.iterator();
                        do {
                            bl = bl2;
                            if (!iterator.hasNext()) break block4;
                        } while (!iterator.next().orgId.equals(trainingPlan.orgId));
                        bl = true;
                    }
                    if (bl.booleanValue()) continue;
                    arrayList2.add(trainingPlan);
                }
                CourseWorkoutViewModel.access$302(CourseWorkoutViewModel.this, arrayList2);
                CourseWorkoutViewModel.this.uploadTrainingPeaksWorkout(string2);
            }
        });
    }

    public void uploadWorkout(TrainingPlan trainingPlan, WorkoutRepositoryHandler workoutRepositoryHandler) {
        this.workoutRepository.updateWorkout(trainingPlan, false, workoutRepositoryHandler);
    }

    public static class SyncListener {
        public void onComplete() {
        }
    }

    public static final class SyncToDeviceStep
    extends Enum<SyncToDeviceStep> {
        private static final /* synthetic */ SyncToDeviceStep[] $VALUES;
        public static final /* enum */ SyncToDeviceStep idle;
        public static final /* enum */ SyncToDeviceStep sendingEnd;
        public static final /* enum */ SyncToDeviceStep sendingStart;
        public static final /* enum */ SyncToDeviceStep sendingWorkout;
        public static final /* enum */ SyncToDeviceStep sendingWorkoutWithoutJson;

        static {
            SyncToDeviceStep syncToDeviceStep;
            SyncToDeviceStep syncToDeviceStep2;
            SyncToDeviceStep syncToDeviceStep3;
            SyncToDeviceStep syncToDeviceStep4;
            SyncToDeviceStep syncToDeviceStep5;
            idle = syncToDeviceStep5 = new SyncToDeviceStep();
            sendingStart = syncToDeviceStep4 = new SyncToDeviceStep();
            sendingWorkout = syncToDeviceStep3 = new SyncToDeviceStep();
            sendingEnd = syncToDeviceStep2 = new SyncToDeviceStep();
            sendingWorkoutWithoutJson = syncToDeviceStep = new SyncToDeviceStep();
            $VALUES = new SyncToDeviceStep[]{syncToDeviceStep5, syncToDeviceStep4, syncToDeviceStep3, syncToDeviceStep2, syncToDeviceStep};
        }

        public static SyncToDeviceStep valueOf(String string2) {
            return Enum.valueOf(SyncToDeviceStep.class, string2);
        }

        public static SyncToDeviceStep[] values() {
            return (SyncToDeviceStep[])$VALUES.clone();
        }
    }
}

