/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.notification;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.lifecycle.LiveData;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.db.notification.entity.NotificationEntity;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.repo.notification.NotificationRepository;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.utils.ActivityFileUtil;
import com.brytonsport.active.utils.NotificationConstantsUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.vm.notification.NotificationViewModel$$ExternalSyntheticLambda0;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NotificationViewModel
extends BaseViewModel {
    @Inject
    BleRepository bleRepository;
    @Inject
    DeviceRepository deviceRepository;
    public List<NotificationEntity> list;
    private LiveData<List<NotificationEntity>> notificationListLive;
    @Inject
    NotificationRepository notificationRepository;

    @Inject
    public NotificationViewModel() {
    }

    public void checkExpireNotify() {
        new Thread(new NotificationViewModel$$ExternalSyntheticLambda0(this)).start();
    }

    public void clickForRead(NotificationEntity notificationEntity) {
        notificationEntity.setRead(true);
        this.notificationRepository.update(notificationEntity);
    }

    public boolean deleteFitFile(int n) {
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        App app = App.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("/fit/unsave/");
        stringBuilder.append(n);
        stringBuilder.append(".fit");
        return ActivityFileUtil.deleteFile((Context)app, stringBuilder.toString());
    }

    public void deleteNotifications(List<NotificationEntity> object) {
        Iterator<NotificationEntity> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.notificationRepository.deleteNotification((NotificationEntity)object);
        }
    }

    public LiveData<List<NotificationEntity>> getNotificationListLive() {
        return this.notificationListLive;
    }

    public void initMockData() {
        ArrayList<NotificationEntity> arrayList = new ArrayList<NotificationEntity>();
        arrayList.add(new NotificationEntity(NotificationConstantsUtil.CATEGORY_UPLOAD_FIT_SUCCESS, i18N.get("FitToServer"), null, new Date().getTime(), NotificationConstantsUtil.NOTIFICATION_EXPIRE_FIT));
        arrayList.add(new NotificationEntity(NotificationConstantsUtil.CATEGORY_UPLOAD_FIT_BAD_TRACK, i18N.get("M_UploadFail"), null, new Date().getTime(), NotificationConstantsUtil.NOTIFICATION_EXPIRE_FIT));
        arrayList.add(new NotificationEntity(NotificationConstantsUtil.CATEGORY_MAINTENANCE, "Server Maintenance", null, new Date().getTime(), NotificationConstantsUtil.NOTIFICATION_EXPIRE_FIT));
        arrayList.add(new NotificationEntity(NotificationConstantsUtil.CATEGORY_FIRMWARE, "New firmware available for RS500", null, new Date().getTime(), NotificationConstantsUtil.NOTIFICATION_EXPIRE_FIRMWARE));
        arrayList.add(new NotificationEntity(NotificationConstantsUtil.CATEGORY_UPLOAD_FIT_NOT_UPLOAD_TO_SERVER, i18N.get("M_notupdatedtocloud"), null, new Date().getTime(), NotificationConstantsUtil.NOTIFICATION_EXPIRE_FIT));
        arrayList.add(new NotificationEntity(NotificationConstantsUtil.CATEGORY_ANNOUNCEMENT, "Official Announcement", null, new Date().getTime(), NotificationConstantsUtil.NOTIFICATION_EXPIRE_FIT));
        arrayList.add(new NotificationEntity(NotificationConstantsUtil.CATEGORY_ANNOUNCEMENT, "\u6e2c\u8a66", null, new Date().getTime(), 600000L));
        this.notificationRepository.insert(arrayList);
    }

    public /* synthetic */ void lambda$checkExpireNotify$0$com-brytonsport-active-vm-notification-NotificationViewModel() {
        Serializable serializable = new ArrayList();
        Object object = this.notificationRepository.loadNotificationList();
        if (object != null) {
            long l = new Date().getTime();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (NotificationEntity)iterator.next();
                if (((NotificationEntity)object).getExpire() == -1L || ((NotificationEntity)object).getPushDate() + ((NotificationEntity)object).getExpire() >= l) continue;
                serializable.add(object);
            }
        }
        object = serializable.iterator();
        while (object.hasNext()) {
            serializable = (NotificationEntity)object.next();
            this.notificationRepository.deleteNotification((NotificationEntity)serializable);
        }
    }

    public DeviceManagerEntity loadDeviceIsChoice() {
        return this.deviceRepository.loadDeviceIsChoice();
    }

    public void loadNotificationListFromDb() {
        this.notificationListLive = this.notificationRepository.loadNotificationListFromDb();
    }

    public void reGetFitFileFromDevice(int n) {
        this.bleRepository.getFitFileFromDeviceBySptFtp(n, (byte)1);
    }

    public void removeNotification(NotificationEntity notificationEntity) {
        this.notificationRepository.deleteNotification(notificationEntity);
    }

    public void updateNotification(int n, int n2, String string2) {
        this.notificationRepository.updateNotification(n, n2, string2);
    }

    public static class Notification
    implements Parcelable {
        public static final Parcelable.Creator<Notification> CREATOR = new Parcelable.Creator<Notification>(){

            public Notification createFromParcel(Parcel parcel) {
                return new Notification(parcel);
            }

            public Notification[] newArray(int n) {
                return new Notification[n];
            }
        };
        public String content;
        private boolean isSelected;
        public int status;
        public String time;
        public String title;

        public Notification(int n, String string2, String string3) {
            this.isSelected = false;
            this.status = n;
            this.title = string2;
            this.content = "";
            this.time = string3;
        }

        public Notification(int n, String string2, String string3, String string4) {
            this.isSelected = false;
            this.status = n;
            this.title = string2;
            this.content = string3;
            this.time = string4;
        }

        protected Notification(Parcel parcel) {
            boolean bl = false;
            this.isSelected = false;
            this.status = parcel.readInt();
            this.title = parcel.readString();
            this.content = parcel.readString();
            this.time = parcel.readString();
            if (parcel.readByte() != 0) {
                bl = true;
            }
            this.isSelected = bl;
        }

        public int describeContents() {
            return 0;
        }

        public int getStatusIcon() {
            int n = this.status;
            if (n == 0) {
                return 2131165404;
            }
            if (n == 1) {
                return 2131165449;
            }
            if (n == 2) {
                return 2131165501;
            }
            if (n == 3) {
                return 2131165516;
            }
            if (n == 4) {
                return 2131165625;
            }
            return 2131165626;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.status);
            parcel.writeString(this.title);
            parcel.writeString(this.content);
            parcel.writeString(this.time);
            parcel.writeByte((byte)(this.isSelected ? 1 : 0));
        }
    }
}

