/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.profile;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.account.vo.AccountUserInfo;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.repo.account.LoginRepository;
import com.brytonsport.active.repo.profile.Connect3rdPartyRepository;
import com.brytonsport.active.vm.base.Sync;
import java.util.ArrayList;
import javax.inject.Inject;

public class Profile3rdPartyViewModel
extends BaseViewModel {
    private LiveData<AccountUserInfo> accountUserInfoLiveData;
    @Inject
    Connect3rdPartyRepository connect3rdPartyRepository;
    @Inject
    LoginRepository loginRepository;
    private boolean mIsRefreshed = false;
    private Sync mProcessingSync = null;
    private ArrayList<Object> syncList = new ArrayList();

    @Inject
    public Profile3rdPartyViewModel() {
    }

    public LiveData<AccountUserInfo> getAccountUserInfoLiveData() {
        return this.accountUserInfoLiveData;
    }

    public Sync getRunningSync() {
        return this.mProcessingSync;
    }

    public ArrayList<Object> getSyncList() {
        return this.syncList;
    }

    public MutableLiveData<Connect3rdPartyRepository.Token2ServerResult> getToken2ServerLiveData() {
        return this.connect3rdPartyRepository.getToken2ServerLiveData();
    }

    public MutableLiveData<String> getUpload2ReliveLiveData() {
        return this.connect3rdPartyRepository.getUpload2ReliveLiveData();
    }

    public MutableLiveData<String> getUpload2SelfloopsLiveData() {
        return this.connect3rdPartyRepository.getUpload2SelfloopsLiveData();
    }

    public MutableLiveData<String> getUpload2StravaLiveData() {
        return this.connect3rdPartyRepository.getUpload2StravaLiveData();
    }

    public MutableLiveData<String> getUpload2TodaysplanLiveData() {
        return this.connect3rdPartyRepository.getUpload2TodaysplanLiveData();
    }

    public MutableLiveData<String> getUpload2TrainingPeaksLiveData() {
        return this.connect3rdPartyRepository.getUpload2TrainingPeaksLiveData();
    }

    public void getUserInfo() {
        this.loginRepository.getUserInfo();
    }

    public void getUserInfoFromDb() {
        this.accountUserInfoLiveData = this.loginRepository.loadUserInfoFromDb();
    }

    public void init2UploadState(Sync sync) {
        this.mIsRefreshed = false;
        this.mProcessingSync = sync;
    }

    public MutableLiveData<Boolean> isUserInfoSuccessLiveData() {
        return this.loginRepository.isUserInfoSuccessLiveData();
    }

    public void load3rdPartyListFromPageType(String string2) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1869562574: {
                if (!string2.equals("plantrip")) break;
                n2 = 3;
                break;
            }
            case 1525170845: {
                if (!string2.equals("workout")) break;
                n2 = 2;
                break;
            }
            case -309425751: {
                if (!string2.equals("profile")) break;
                n2 = 1;
                break;
            }
            case -1655966961: {
                if (!string2.equals("activity")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                this.loadPlanTrip3rdPartyList();
                break;
            }
            case 2: {
                this.loadWorkout3rdPartyList();
                break;
            }
            case 1: {
                this.loadProfile3rdPartyList();
                break;
            }
            case 0: {
                this.loadActivity3rdPartyList();
            }
        }
    }

    public void loadActivity3rdPartyList() {
        this.syncList.add(new Sync(2131165387, "Strava", "strava").setChecked(false));
        this.syncList.add(new Sync(2131165389, "TrainingPeaks", "trainingpeaks").setChecked(false));
        this.syncList.add(new Sync(2131165381, "Relive", "relive").setChecked(false));
        this.syncList.add(new Sync(2131165388, "Today\u2019s Plan", "todaysplan"));
    }

    public void loadPlanTrip3rdPartyList() {
        this.syncList.add(new Sync(2131165387, "Strava", "strava").setChecked(false));
        this.syncList.add(new Sync(2131165380, "Komoot", "komoot").setChecked(false));
        this.syncList.add(new Sync(2131165382, "Ride with GPS", "ridewithgps").setChecked(false));
    }

    public void loadProfile3rdPartyList() {
        this.syncList.add(new Sync(2131165387, "Strava", "strava").setChecked(false));
        this.syncList.add(new Sync(2131165389, "TrainingPeaks", "trainingpeaks").setChecked(false));
        this.syncList.add(new Sync(2131165381, "Relive", "relive").setChecked(false));
        this.syncList.add(new Sync(2131165388, "Today\u2019s Plan", "todaysplan"));
        this.syncList.add(new Sync(2131165380, "Komoot", "komoot").setChecked(false));
        this.syncList.add(new Sync(2131165382, "Ride with GPS", "ridewithgps").setChecked(false));
    }

    public void loadWorkout3rdPartyList() {
        this.syncList.add(new Sync(2131165389, "TrainingPeaks", "trainingpeaks").setChecked(false));
    }

    public boolean refreshReliveToken(String string2) {
        if (!this.mIsRefreshed) {
            this.mIsRefreshed = true;
            this.connect3rdPartyRepository.refreshReliveToken(string2);
            return true;
        }
        return false;
    }

    public boolean refreshSelfloopsToken(String string2) {
        if (!this.mIsRefreshed) {
            this.mIsRefreshed = true;
            this.connect3rdPartyRepository.refreshSelfloopsToken(string2);
            return true;
        }
        return false;
    }

    public boolean refreshStravaToken(String string2) {
        if (!this.mIsRefreshed) {
            this.mIsRefreshed = true;
            this.connect3rdPartyRepository.refreshStravaToken(string2);
            return true;
        }
        return false;
    }

    public boolean refreshTrainingPeaksToken(String string2) {
        if (!this.mIsRefreshed) {
            this.mIsRefreshed = true;
            this.connect3rdPartyRepository.refreshTrainingPeaksToken(string2);
            return true;
        }
        return false;
    }

    public void resetUploadState() {
        this.mIsRefreshed = false;
        this.mProcessingSync = null;
    }

    public void updateRunningSync(Sync sync) {
        this.mProcessingSync = sync;
    }

    public void uploadActivity2Relive(String string2, String string3) {
        this.connect3rdPartyRepository.uploadActivity2Relive(string2, string3);
    }

    public void uploadActivity2Selfloops(String string2, String string3) {
        this.connect3rdPartyRepository.uploadActivity2Selfloops(string2, string3);
    }

    public void uploadActivity2Strava(String string2, String string3) {
        this.connect3rdPartyRepository.uploadActivity2Strava(string2, string3);
    }

    public void uploadActivity2Todaysplan(String string2, String string3) {
        this.connect3rdPartyRepository.uploadActivity2Todaysplan(string2, string3);
    }

    public void uploadActivity2TrainingPeaks(String string2, String string3) {
        this.connect3rdPartyRepository.uploadActivity2TrainingPeaks(string2, string3);
    }
}

