/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.profile;

import androidx.lifecycle.LiveData;
import com.brytonsport.active.api.account.vo.AccountUserProfile;
import com.brytonsport.active.base.SyncBLEViewModel;
import com.brytonsport.active.repo.account.LoginRepository;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.vm.base.Profile;
import javax.inject.Inject;
import org.json.JSONException;
import org.json.JSONObject;

public class ProfileAboutMeViewModel
extends SyncBLEViewModel {
    public AccountUserProfile accountUserProfile = null;
    private LiveData<AccountUserProfile> accountUserProfileLiveData;
    @Inject
    LoginRepository loginRepository;
    public Profile profile;

    @Inject
    public ProfileAboutMeViewModel() {
        Profile profile;
        this.profile = profile = new Profile();
        profile.loadMockData();
    }

    public LiveData<AccountUserProfile> getAccountUserProfileLiveData() {
        return this.accountUserProfileLiveData;
    }

    public void loadUserProfileFromDb() {
        this.accountUserProfileLiveData = this.loginRepository.loadUserProfileFromDb();
    }

    public void updateAvatar() {
        JSONObject jSONObject = new JSONObject();
        AccountUserProfile accountUserProfile = this.accountUserProfile;
        if (accountUserProfile != null && accountUserProfile.getAvatar() != null) {
            accountUserProfile = new JSONObject();
            try {
                accountUserProfile.put("image", this.accountUserProfile.getAvatar().getImage());
                accountUserProfile.put("tag", this.accountUserProfile.getAvatar().getTag());
                jSONObject.put("avatar", (Object)accountUserProfile);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            ProfileUtil.getInstance().set("avatar", this.accountUserProfile.getAvatar().getImage());
            this.loginRepository.updateUserProfileToDb(this.accountUserProfile);
            this.loginRepository.setUserProfile(jSONObject);
        }
    }

    public void updateBirthday() {
        JSONObject jSONObject = new JSONObject();
        AccountUserProfile accountUserProfile = this.accountUserProfile;
        if (accountUserProfile != null) {
            try {
                jSONObject.put("birthday", (Object)accountUserProfile.getBirthday());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.loginRepository.updateUserProfileToDb(this.accountUserProfile);
            this.loginRepository.setUserProfile(jSONObject);
        }
    }

    public void updateGender() {
        JSONObject jSONObject = new JSONObject();
        AccountUserProfile accountUserProfile = this.accountUserProfile;
        if (accountUserProfile != null) {
            try {
                jSONObject.put("gender", accountUserProfile.getGender());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.loginRepository.updateUserProfileToDb(this.accountUserProfile);
            this.loginRepository.setUserProfile(jSONObject);
        }
    }

    public void updateHeight() {
        JSONObject jSONObject = new JSONObject();
        AccountUserProfile accountUserProfile = this.accountUserProfile;
        if (accountUserProfile != null) {
            try {
                jSONObject.put("height", (double)accountUserProfile.getHeight());
                jSONObject.put("height_I", (double)this.accountUserProfile.getHeight_I());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.loginRepository.updateUserProfileToDb(this.accountUserProfile);
            this.loginRepository.setUserProfile(jSONObject);
        }
    }

    public void updateNickname() {
        JSONObject jSONObject = new JSONObject();
        AccountUserProfile accountUserProfile = this.accountUserProfile;
        if (accountUserProfile != null) {
            try {
                jSONObject.put("nickName", (Object)accountUserProfile.getNickName());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            ProfileUtil.getInstance().set("nickName", this.accountUserProfile.getNickName());
            this.loginRepository.updateUserProfileToDb(this.accountUserProfile);
            this.loginRepository.setUserProfile(jSONObject);
        }
    }

    public void updateWeight() {
        JSONObject jSONObject = new JSONObject();
        AccountUserProfile accountUserProfile = this.accountUserProfile;
        if (accountUserProfile != null) {
            try {
                jSONObject.put("weight", (double)accountUserProfile.getWeight());
                jSONObject.put("weight_I", (double)this.accountUserProfile.getWeight_I());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.loginRepository.updateUserProfileToDb(this.accountUserProfile);
            this.loginRepository.setUserProfile(jSONObject);
        }
    }
}

