/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.profile;

import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.account.vo.AccountUserInfo;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.repo.account.LoginRepository;
import com.brytonsport.active.repo.course.FileIdHistoryRepository;
import com.brytonsport.active.repo.course.SearchHistoryRepository;
import com.brytonsport.active.repo.notification.NotificationRepository;
import com.brytonsport.active.repo.result.ActivityRepository;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.vm.base.Profile;
import com.brytonsport.active.vm.profile.ProfileDeleteAccountViewModel$$ExternalSyntheticLambda0;
import com.brytonsport.active.vm.profile.ProfileDeleteAccountViewModel$$ExternalSyntheticLambda1;
import javax.inject.Inject;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProfileDeleteAccountViewModel
extends BaseViewModel {
    @Inject
    ActivityRepository activityRepository;
    @Inject
    BleRepository bleRepository;
    @Inject
    DeviceRepository deviceRepository;
    @Inject
    FileIdHistoryRepository fileIdHistoryRepository;
    @Inject
    LoginRepository loginRepository;
    @Inject
    NotificationRepository notificationRepository;
    public Profile profile;
    @Inject
    SearchHistoryRepository searchHistoryRepository;

    @Inject
    public ProfileDeleteAccountViewModel() {
    }

    @Override
    public void AfterLogoutClearData() {
        new Thread(new ProfileDeleteAccountViewModel$$ExternalSyntheticLambda0(this)).start();
    }

    public void checkPassword(String string2) {
        new Thread(new ProfileDeleteAccountViewModel$$ExternalSyntheticLambda1(this, string2)).start();
    }

    @Override
    public void clearUserAccountSharedPreferences() {
        ProfileUtil.getInstance().set("userId", "");
        ProfileUtil.getInstance().set("com.brytonsport.active.loginToken", "");
        ProfileUtil.getInstance().set("nickName", "");
        ProfileUtil.getInstance().set("avatar", "");
        ProfileUtil.getInstance().set("activityListTimestamp", 0);
        ProfileUtil.getInstance().set("app_first_in_need_show_tutorial", true);
        ProfileUtil.getInstance().set("connect_ready_to_send_get_user_name", false);
        App.isAppNeedGetAnnouncement = true;
    }

    public void deleteAccount() {
        this.loginRepository.deleteAccount();
    }

    @Override
    public void disconnectCurrentDevice() {
        for (DeviceManagerEntity deviceManagerEntity : this.deviceRepository.loadDeviceManagerList()) {
            if (!deviceManagerEntity.isConnected()) continue;
            this.bleRepository.disConnectDevice(deviceManagerEntity.getMacAddress());
        }
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.loginRepository.getLiveAccountErrorResponse();
    }

    public MutableLiveData<JSONObject> isDeleteAccountResultLiveData() {
        return this.loginRepository.get_isDeleteAccountResultLiveData();
    }

    public MutableLiveData<Boolean> isLoginSuccessLiveData() {
        return this.loginRepository.isLoginSuccessLiveData();
    }

    public /* synthetic */ void lambda$AfterLogoutClearData$1$com-brytonsport-active-vm-profile-ProfileDeleteAccountViewModel() {
        this.disconnectCurrentDevice();
        this.activityRepository.deleteActivityAllData();
        this.searchHistoryRepository.deleteAllData();
        this.fileIdHistoryRepository.deleteAllData();
        this.deviceRepository.deleteAllData();
        this.notificationRepository.deleteAllData();
        this.loginRepository.deleteUserInfoAllData();
        this.loginRepository.deleteUserProfileAllData();
        this.clearUserAccountSharedPreferences();
    }

    public /* synthetic */ void lambda$checkPassword$0$com-brytonsport-active-vm-profile-ProfileDeleteAccountViewModel(String string2) {
        Object object = this.loginRepository.getUserInfoFromDb();
        object = object != null && ((AccountUserInfo)object).getEmails() != null && ((AccountUserInfo)object).getEmails().size() > 0 ? ((AccountUserInfo)object).getEmails().get(0).getAddress() : "";
        if (!((String)object).isEmpty()) {
            this.loginRepository.login((String)object, string2);
        }
    }
}

