/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.profile;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.account.vo.AccountUserProfile;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.SyncBLEViewModel;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.repo.account.LoginRepository;
import com.brytonsport.active.repo.course.FileIdHistoryRepository;
import com.brytonsport.active.repo.course.SearchHistoryRepository;
import com.brytonsport.active.repo.notification.NotificationRepository;
import com.brytonsport.active.repo.result.ActivityRepository;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.vm.base.Profile;
import com.brytonsport.active.vm.profile.ProfileViewModel$$ExternalSyntheticLambda0;
import javax.inject.Inject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProfileViewModel
extends SyncBLEViewModel {
    private LiveData<AccountUserProfile> accountUserProfileLiveData;
    @Inject
    ActivityRepository activityRepository;
    @Inject
    DeviceRepository deviceRepository;
    @Inject
    FileIdHistoryRepository fileIdHistoryRepository;
    @Inject
    LoginRepository loginRepository;
    @Inject
    NotificationRepository notificationRepository;
    public Profile profile = App.profile;
    @Inject
    SearchHistoryRepository searchHistoryRepository;

    @Inject
    public ProfileViewModel() {
    }

    @Override
    public void AfterLogoutClearData() {
        new Thread(new ProfileViewModel$$ExternalSyntheticLambda0(this)).start();
    }

    @Override
    public void clearUserAccountSharedPreferences() {
        ProfileUtil.getInstance().set("userId", "");
        ProfileUtil.getInstance().set("com.brytonsport.active.loginToken", "");
        ProfileUtil.getInstance().set("nickName", "");
        ProfileUtil.getInstance().set("avatar", "");
        ProfileUtil profileUtil = ProfileUtil.getInstance();
        Boolean bl = false;
        Integer n = 0;
        profileUtil.set("activityListTimestamp", n);
        ProfileUtil.getInstance().set("app_first_in_need_show_tutorial", true);
        ProfileUtil.getInstance().set("connect_ready_to_send_get_user_name", bl);
        App.isAppNeedGetAnnouncement = true;
        ProfileUtil.getInstance().set("loginTokenUpdateTime", 0L);
        ProfileUtil.getInstance().set("groupRideId", "");
        ProfileUtil.getInstance().set("groupRideSearchId", "");
        ProfileUtil.getInstance().set("is_review_flow_complete", bl);
        ProfileUtil.getInstance().set("run_sync_fit_flow_count", n);
    }

    @Override
    public void disconnectCurrentDevice() {
        for (DeviceManagerEntity deviceManagerEntity : this.deviceRepository.loadDeviceManagerList()) {
            if (!deviceManagerEntity.isConnected()) continue;
            this.bleRepository.disConnectDevice(deviceManagerEntity.getMacAddress());
        }
    }

    public LiveData<AccountUserProfile> getAccountUserProfileLiveData() {
        return this.accountUserProfileLiveData;
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.loginRepository.getLiveAccountErrorResponse();
    }

    public MutableLiveData<Boolean> isLogoutSuccessLiveData() {
        return this.loginRepository.isLogoutSuccessLiveData();
    }

    public /* synthetic */ void lambda$AfterLogoutClearData$0$com-brytonsport-active-vm-profile-ProfileViewModel() {
        this.disconnectCurrentDevice();
        this.activityRepository.deleteActivityAllData();
        this.searchHistoryRepository.deleteAllData();
        this.fileIdHistoryRepository.deleteAllData();
        this.deviceRepository.deleteAllData();
        this.notificationRepository.deleteAllData();
        this.loginRepository.deleteUserInfoAllData();
        this.loginRepository.deleteUserProfileAllData();
        this.clearUserAccountSharedPreferences();
    }

    public void loadUserProfileFromDb() {
        this.accountUserProfileLiveData = this.loginRepository.loadUserProfileFromDb();
    }

    @Override
    public void logout() {
        this.loginRepository.logout();
    }
}

