/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.profile;

import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.profile.ApprovalPrompt;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.repo.account.LoginRepository;
import com.brytonsport.active.repo.profile.Connect3rdPartyRepository;
import com.brytonsport.active.utils.ProfileUtil;
import javax.inject.Inject;

public class ResultSyncInfoViewModel
extends BaseViewModel {
    private final MutableLiveData<Boolean> _isRideWithGpsUnBindSuccessLiveData = new MutableLiveData();
    @Inject
    Connect3rdPartyRepository connect3rdPartyRepository;
    private String komootBaseUrl = "https://auth.komoot.de/oauth/authorize?client_id=%s&redirect_uri=%s&scope=%s&response_type=code&state=login";
    @Inject
    LoginRepository loginRepository;
    public String redirectUrl = "https://active.brytonsport.com";
    private String reliveBaseUrl = "https://www.relive.cc/oauth/authorize?client_id=%s&scope=%s&response_type=code&redirect_uri=%s&state=close";
    public String reliveRedirectUrl = "https://active.brytonsport.com/_oauth/relive?close";
    private String routeyouBaseUrl = "https://www.routeyou.com/oauth/authorize?response_type=code&client_id=%s&redirect_uri=%s&scope=account:basic+content:read_all+content:write&state=abc123";
    public String routeyouRedirectUri = "oauth://active.brytonsport.com";
    private String selfloopsBaseUrl = "https://www.selfloops.com/oauth/authorize?client_id=%s&response_type=code&state=login";
    private String stravaBaseUrl = "https://www.strava.com/oauth/authorize?response_type=code&client_id=%s&redirect_uri=%s&approval_prompt=%s&scope=%s&state=login";
    private String todaysplanBaseUrl = "https://whats.todaysplan.com.au/en/authorize/%s?redirect_uri=%s&response_type=code&state=login";
    private String trainingPeaksBaseUrl = "https://oauth.trainingpeaks.com/OAuth/Authorize?client_id=%s&redirect_uri=%s&scope=%s&response_type=code&state=1234";

    @Inject
    public ResultSyncInfoViewModel() {
    }

    public String getKomootAuthCodeUrl() {
        return String.format(this.komootBaseUrl, "bryton-vg3tsv", this.redirectUrl, "profile");
    }

    public void getKomootToken(String string2) {
        this.connect3rdPartyRepository.getKomootToken(string2);
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.loginRepository.getLiveAccountErrorResponse();
    }

    public String getReliveAuthCodeUrl() {
        return String.format(this.reliveBaseUrl, "L2rqoyOeoJ", "activity:write", this.reliveRedirectUrl);
    }

    public void getReliveToken(String string2) {
        this.connect3rdPartyRepository.getReliveToken(string2);
    }

    public void getRideWithGpsUserId(String string2, String string3) {
    }

    public String getRouteyouAuthCodeUrl() {
        return String.format(this.routeyouBaseUrl, "4ys0malpfnkol0ep", this.routeyouRedirectUri);
    }

    public void getRouteyouToken(String string2) {
        this.connect3rdPartyRepository.getRouteyouToken(string2);
    }

    public String getSelfloopsAuthCodeUrl() {
        return String.format(this.selfloopsBaseUrl, "bc60072ad48f94e0f75ee3958bc22625d38bae4f86665ddce9af6c52e8dc09d1");
    }

    public void getSelfloopsToken(String string2) {
        this.connect3rdPartyRepository.getSelfloopsToken(string2);
    }

    public String getStravaAuthCodeUrl() {
        String string2 = ApprovalPrompt.FORCE.toString();
        return String.format(this.stravaBaseUrl, "10260", this.redirectUrl, string2, "read,activity:write");
    }

    public void getStravaToken(String string2) {
        this.connect3rdPartyRepository.getStravaToken(string2);
    }

    public String getTodaysplanAuthCodeUrl() {
        return String.format(this.todaysplanBaseUrl, "BrytonActive", this.redirectUrl);
    }

    public void getTodaysplanToken(String string2) {
        this.connect3rdPartyRepository.getTodaysplanToken(string2);
    }

    public void getTokenByCode(String string2, String string3) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1864948603: {
                if (!string2.equals("todaysplan")) break;
                n2 = 6;
                break;
            }
            case 5443894: {
                if (!string2.equals("routeyou")) break;
                n2 = 5;
                break;
            }
            case -552658214: {
                if (!string2.equals("trainingpeaks")) break;
                n2 = 4;
                break;
            }
            case -891993349: {
                if (!string2.equals("strava")) break;
                n2 = 3;
                break;
            }
            case -934646369: {
                if (!string2.equals("relive")) break;
                n2 = 2;
                break;
            }
            case -1125779861: {
                if (!string2.equals("komoot")) break;
                n2 = 1;
                break;
            }
            case -1679167869: {
                if (!string2.equals("selfloops")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 6: {
                this.getTodaysplanToken(string3);
                break;
            }
            case 5: {
                this.getRouteyouToken(string3);
                break;
            }
            case 4: {
                this.getTrainingPeaksToken(string3);
                break;
            }
            case 3: {
                this.getStravaToken(string3);
                break;
            }
            case 2: {
                this.getReliveToken(string3);
                break;
            }
            case 1: {
                this.getKomootToken(string3);
                break;
            }
            case 0: {
                this.getSelfloopsToken(string3);
            }
        }
    }

    public String getTrainingPeaksAuthCodeUrl() {
        return String.format(this.trainingPeaksBaseUrl, "bryton", this.redirectUrl, "file:write workouts:wod");
    }

    public void getTrainingPeaksToken(String string2) {
        this.connect3rdPartyRepository.getTrainingPeaksToken(string2);
    }

    public MutableLiveData<Boolean> getUpdateService2ServerSuccessLiveData() {
        return this.connect3rdPartyRepository.getUpdateService2ServerSuccessLiveData();
    }

    public void getUserInfo() {
        this.loginRepository.getUserInfo();
    }

    public MutableLiveData<Boolean> isRideWithGpsUnBindSuccessLiveData() {
        return this._isRideWithGpsUnBindSuccessLiveData;
    }

    public MutableLiveData<Boolean> isUnbindServiceSuccessLiveData() {
        return this.loginRepository.isUnbindServiceSuccessLiveData();
    }

    public MutableLiveData<Boolean> isUserInfoSuccessLiveData() {
        return this.loginRepository.isUserInfoSuccessLiveData();
    }

    public void unbindService(String string2) {
        if (string2.equals("ridewithgps")) {
            ProfileUtil.getInstance().set("rideWithGpsUserId", "");
            this._isRideWithGpsUnBindSuccessLiveData.postValue(true);
        } else {
            this.loginRepository.unbindService(string2.toLowerCase());
        }
    }
}

