/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.result;

import android.util.Log;
import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import com.brytonsport.active.api.Resource;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.base.SingleLiveEvent;
import com.brytonsport.active.bleplugin.ParserUtil;
import com.brytonsport.active.db.result.entity.ActivityEntity;
import com.brytonsport.active.repo.course.LiveTrackRepository;
import com.brytonsport.active.repo.notification.NotificationRepository;
import com.brytonsport.active.repo.result.ActivityRepository;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.TimeUtilByLee;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.vm.base.DayActivity;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.json.JSONException;
import org.json.JSONObject;

public class ResultViewModel
extends BaseViewModel {
    private static final String DEFAULT_ACTIVITY_NAME = "new activity";
    static final double MIN_FREE_MEMORY = 0.75;
    static final String TAG = "ResultViewModel";
    public List<ActivityEntity> activityEntityList;
    @Inject
    ActivityRepository activityRepository;
    public String defaultNoResultTxt;
    private int default_page_num = 10;
    private int getActivityLastCount = 0;
    private int getActivityRunCount = 0;
    private int getActivityRunIndex = 0;
    private int getActivityRunOffset = 0;
    private final LiveData<List<ActivityEntity>> listLiveData;
    private LiveData<Resource<List<ActivityEntity>>> liveResultList = new LiveData<Resource<List<ActivityEntity>>>(){};
    @Inject
    LiveTrackRepository liveTrackRepository;
    @Inject
    NotificationRepository notificationRepository;
    private LiveData<Integer> notificationUnReadCountLive;
    private final MutableLiveData<JSONObject> queryStartAndEndTsObj;
    public List<DayActivity> weekDaysActivityList;

    @Inject
    public ResultViewModel() {
        MutableLiveData mutableLiveData = new MutableLiveData();
        this.queryStartAndEndTsObj = mutableLiveData;
        this.activityEntityList = new ArrayList<ActivityEntity>();
        this.defaultNoResultTxt = i18N.get("M_Loading");
        this.listLiveData = Transformations.switchMap(mutableLiveData, new Function<JSONObject, LiveData<List<ActivityEntity>>>(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public LiveData<List<ActivityEntity>> apply(JSONObject jSONObject) {
                void var1_4;
                int n;
                int n2;
                block4: {
                    n2 = 0;
                    try {
                        n = jSONObject.getInt("startTimestamp");
                    }
                    catch (JSONException jSONException) {
                        n = 0;
                        break block4;
                    }
                    try {
                        int n3;
                        n2 = n3 = jSONObject.getInt("endTimestamp");
                        return ResultViewModel.this.activityRepository.getActivityListStartAndEndTimeFromDb(n, n2);
                    }
                    catch (JSONException jSONException) {}
                }
                var1_4.printStackTrace();
                return ResultViewModel.this.activityRepository.getActivityListStartAndEndTimeFromDb(n, n2);
            }
        });
    }

    private String displayActivityName(ActivityEntity object) {
        Long l = Utils.getDisplayLocalStartTime((ActivityEntity)object);
        String string2 = ((ActivityEntity)object).getName();
        object = string2;
        if (string2.equals(DEFAULT_ACTIVITY_NAME)) {
            object = new StringBuilder();
            ((StringBuilder)object).append("bike");
            ((StringBuilder)object).append(TimeUtilByLee.getDateHour(l));
            object = ((StringBuilder)object).toString();
        }
        return object;
    }

    public void checkLiveTrackIdOver24Hour() {
        if (!((String)ProfileUtil.getInstance().get("live_track_group_id")).isEmpty()) {
            this.liveTrackRepository.getCurrentForCheckOver24Hour();
        }
    }

    public void checkNotificationUnReadCount() {
        this.notificationUnReadCountLive = this.notificationRepository.getUnReadCount();
    }

    public MutableLiveData<Boolean> getActivityCountsNextLive() {
        return this.activityRepository.getActivityCountsNextLive();
    }

    public void getActivityFile() {
        Object object = (List)this.liveResultList.getValue().data;
        if (object != null && object.size() > 0) {
            object = (ActivityEntity)object.get(3);
            this.activityRepository.getActivityFile(((ActivityEntity)object).get_id(), ((ActivityEntity)object).getLocalStartTime());
        }
    }

    public void getActivityFileByPage() {
        List list = (List)this.liveResultList.getValue().data;
        if (list != null && list.size() > 0) {
            this.getActivityRunIndex = 0;
            int n = list.size() % this.default_page_num == 0 ? list.size() / this.default_page_num : list.size() / this.default_page_num + 1;
            this.getActivityRunCount = n;
            int n2 = list.size();
            if (n2 % (n = this.default_page_num) != 0) {
                n = list.size() % this.default_page_num;
            }
            this.getActivityLastCount = n;
            this.getActivityFileByPageRun();
        }
    }

    public void getActivityFileByPageRun() {
        List list = (List)this.liveResultList.getValue().data;
        if (this.getActivityRunIndex == this.getActivityRunCount - 1) {
            this.activityRepository.uploadFit2ServerTotalNum = this.getActivityLastCount;
            for (int i = this.getActivityRunIndex; i < this.getActivityRunOffset + this.getActivityLastCount; ++i) {
                ActivityEntity activityEntity = (ActivityEntity)list.get(i);
                this.activityRepository.getActivityFile(activityEntity.get_id(), activityEntity.getLocalStartTime());
            }
        } else {
            int n;
            int n2;
            this.activityRepository.uploadFit2ServerTotalNum = this.default_page_num;
            for (int i = this.getActivityRunIndex; i < (n2 = this.getActivityRunOffset) + (n = this.default_page_num); ++i) {
                ActivityEntity activityEntity = (ActivityEntity)list.get(i);
                this.activityRepository.getActivityFile(activityEntity.get_id(), activityEntity.getLocalStartTime());
            }
            this.getActivityRunIndex += n;
            this.getActivityRunOffset = n2 + n;
        }
    }

    public void getActivityFileByView(DayActivity dayActivity) {
        if (App.gettingActivityFitSet.contains(dayActivity._id)) {
            Log.d((String)TAG, (String)"\u7e2e\u5716\u6d41\u7a0b: getActivityFileByView \u53d6\u5f97Fit \u6a94\u6848\u4e2d(\u5df2\u5728gettingActivityFitSet\u6e05\u55ae\u88e1) : \u7565\u904e");
        } else {
            long l;
            long l2 = Runtime.getRuntime().totalMemory();
            double d = (double)l2 / (double)(l = Runtime.getRuntime().maxMemory());
            if (d >= 0.75) {
                String string2 = TAG;
                Log.d((String)string2, (String)"\u7e2e\u5716\u6d41\u7a0b: [1]\u8a18\u61b6\u9ad4\u4e0d\u8db3***********************");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\u7e2e\u5716\u6d41\u7a0b: totalMem");
                stringBuilder.append(l2);
                stringBuilder.append(" maxMem:");
                stringBuilder.append(l);
                stringBuilder.append(" percent:");
                stringBuilder.append(d);
                Log.d((String)string2, (String)stringBuilder.toString());
            }
            if (this.activityRepository.getFitProcessCount() < 5 && d < 0.75) {
                Log.d((String)TAG, (String)"\u7e2e\u5716\u6d41\u7a0b: getActivityFileByView \u53d6\u5f97\u4e2d\u6e05\u55ae\u9084\u6c92\u6709 \u52a0\u5165\u6e05\u55ae\u4e26\u958b\u59cb\u4e0b\u8f09Fit ");
                App.gettingActivityFitSet.add(dayActivity._id);
                this.activityRepository.getActivityFile(dayActivity._id, dayActivity.localStartTime, dayActivity);
            } else {
                Log.d((String)TAG, (String)"\u7e2e\u5716\u6d41\u7a0b: getActivityFileByView FitProcessCount >= 5 \u6216\u8a18\u61b6\u9ad4\u4e0d\u8db3\uff0c\u66ab\u6642\u63a0\u904e ");
                dayActivity.isGenImageIng = false;
            }
        }
    }

    public SingleLiveEvent<Integer> getActivityListCountLive() {
        return this.activityRepository.getActivityListCountLive();
    }

    public LiveData<List<ActivityEntity>> getActivityListFromDb(int n) {
        return this.activityRepository.getActivityListFromDb(n);
    }

    public ArrayList<DayActivity> getListByWeek(Date date) {
        Date date2 = new Date(date.getTime() + 518400000L);
        ArrayList<DayActivity> arrayList = new ArrayList<DayActivity>();
        for (ActivityEntity activityEntity : this.activityEntityList) {
            Long l = Utils.getDisplayLocalStartTime(activityEntity);
            if (date.getTime() > l * 1000L || l * 1000L > date2.getTime()) continue;
            Object object = activityEntity.get_id();
            long l2 = l;
            long l3 = l;
            int n = DayActivity.TYPE_RIDE;
            String string2 = this.displayActivityName(activityEntity);
            double d = activityEntity.getSummary().getTotalDistance() != null ? DistanceUtil.distanceMeteor2Km(activityEntity.getSummary().getTotalDistance()) : 0.0;
            int n2 = activityEntity.getSummary().getTotalMovingTime() != null ? activityEntity.getSummary().getTotalMovingTime().intValue() : 0;
            object = new DayActivity((String)object, l2 * 1000L, l3, 0, n, string2, d, n2, activityEntity.getSummary().getTotalAscent(), activityEntity.getMapImage());
            if (l <= 0L) continue;
            arrayList.add((DayActivity)object);
        }
        return arrayList;
    }

    public LiveData<List<ActivityEntity>> getListLiveData() {
        return this.listLiveData;
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.activityRepository.getLiveAccountErrorResponse();
    }

    public LiveData<Resource<List<ActivityEntity>>> getLiveResultList() {
        return this.liveResultList;
    }

    public LiveData<Integer> getNotificationUnReadCountLive() {
        return this.notificationUnReadCountLive;
    }

    public ArrayList<Object> getTop100Data() {
        Serializable serializable;
        Object object = new ArrayList();
        for (Serializable serializable2 : this.activityEntityList) {
            serializable = Utils.getDisplayLocalStartTime(serializable2);
            String string2 = serializable2.get_id();
            long l = (Long)serializable;
            long l2 = (Long)serializable;
            int n = DayActivity.TYPE_RIDE;
            String string3 = this.displayActivityName((ActivityEntity)serializable2);
            double d = serializable2.getSummary().getTotalDistance() != null ? DistanceUtil.distanceMeteor2Km(serializable2.getSummary().getTotalDistance()) : 0.0;
            int n2 = serializable2.getSummary().getTotalMovingTime() != null ? serializable2.getSummary().getTotalMovingTime().intValue() : 0;
            serializable2 = new DayActivity(string2, l * 1000L, l2, 0, n, string3, d, n2, serializable2.getSummary().getTotalAscent(), serializable2.getMapImage());
            if ((Long)serializable <= 0L) continue;
            ((ArrayList)object).add(serializable2);
        }
        App.dayActivityList = object;
        new SimpleDateFormat("MMM yyyy");
        serializable = new ArrayList();
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            DayActivity dayActivity = (DayActivity)object.next();
            if (((ArrayList)serializable).isEmpty()) {
                ((ArrayList)serializable).add(dayActivity);
                continue;
            }
            if (dayActivity.isSameMonth((DayActivity)((ArrayList)serializable).get(((ArrayList)serializable).size() - 1))) {
                ((ArrayList)serializable).add(dayActivity);
                continue;
            }
            ((ArrayList)serializable).add(dayActivity);
        }
        return serializable;
    }

    public boolean isActivityFileExist(Long object) {
        CharSequence charSequence = ProfileUtil.getInstance().getPrefString("userId");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)charSequence);
        stringBuilder.append("/activity");
        stringBuilder.append(File.separator);
        stringBuilder.append(ParserUtil.fileIdToFormatString((Long)object));
        stringBuilder.append(".fit");
        object = stringBuilder.toString();
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(App.getInstance().getFilesDir());
        ((StringBuilder)charSequence).append(File.separator);
        ((StringBuilder)charSequence).append((String)object);
        return new File(((StringBuilder)charSequence).toString()).exists();
    }

    public boolean isActivityPngExist(Long object) {
        CharSequence charSequence = ProfileUtil.getInstance().getPrefString("userId");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)charSequence);
        stringBuilder.append("/png");
        stringBuilder.append(File.separator);
        stringBuilder.append(ParserUtil.fileIdToFormatString((Long)object));
        stringBuilder.append(".png");
        object = stringBuilder.toString();
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(App.getInstance().getFilesDir());
        ((StringBuilder)charSequence).append(File.separator);
        ((StringBuilder)charSequence).append((String)object);
        return new File(((StringBuilder)charSequence).toString()).exists();
    }

    public void loadResultList() {
        Log.d((String)TAG, (String)" \u5f9e\u6a5f\u5668\u540c\u6b65Fit \u5230app \u5b8c\u6210: \u547c\u53ebloadResultList()");
        this.activityRepository.getActivityListFromServer();
    }

    public void prepareDataToView(List<ActivityEntity> object) {
        this.weekDaysActivityList = new ArrayList<DayActivity>();
        object = object.iterator();
        while (object.hasNext()) {
            ActivityEntity activityEntity = (ActivityEntity)object.next();
            Long l = Utils.getDisplayLocalStartTime(activityEntity);
            Object object2 = activityEntity.get_id();
            long l2 = l;
            long l3 = l;
            int n = DayActivity.TYPE_RIDE;
            String string2 = this.displayActivityName(activityEntity);
            double d = activityEntity.getSummary().getTotalDistance() == null ? 0.0 : DistanceUtil.distanceMeteor2Km(activityEntity.getSummary().getTotalDistance());
            int n2 = activityEntity.getSummary().getTotalMovingTime() != null ? activityEntity.getSummary().getTotalMovingTime().intValue() : 0;
            object2 = new DayActivity((String)object2, l2 * 1000L, l3, 0, n, string2, d, n2, activityEntity.getSummary().getTotalAscent(), activityEntity.getMapImage());
            if (l <= 0L) continue;
            this.weekDaysActivityList.add((DayActivity)object2);
        }
    }

    public void searchRepo(int n, int n2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("startTimestamp", n);
            jSONObject.put("endTimestamp", n2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.queryStartAndEndTsObj.setValue(jSONObject);
    }
}

