/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.setting;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.repo.BleBroadcastReceiver;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.ui.setting.GridINISettingData;
import com.brytonsport.active.utils.IniFileUtil;
import com.brytonsport.active.utils.RhinoJsUtil;
import com.brytonsport.active.vm.base.SettingGridData;
import com.brytonsport.active.vm.base.SettingIniGridData;
import java.util.ArrayList;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SettingDataPageViewModel
extends BaseViewModel {
    @Inject
    BleRepository bleRepository;
    MutableLiveData<String> currentPageNameLiveData = new MutableLiveData();
    SettingGridData data;
    private final BroadcastReceiver deviceDataReceiver;
    @Inject
    DeviceRepository deviceRepository;
    private JSONObject fieldLang;
    JSONArray gridPageList;
    MutableLiveData<Boolean> iniDataSyncCompleted = new MutableLiveData();
    MutableLiveData<Boolean> loadingPageLiveData = new MutableLiveData();
    private final BleBroadcastReceiver mGattUpdateReceiver;

    @Inject
    public SettingDataPageViewModel() {
        this.deviceDataReceiver = new BroadcastReceiver(){

            public void onReceive(Context object, Intent intent) {
                object = intent.getByteArrayExtra("com.brytonsport.active.SERVICE_BYTE_ARRAY_EXTRA_DATA");
                SettingDataPageViewModel.this.data.updateGridContent((byte[])object);
                SettingDataPageViewModel.this.updateCurrentIndex();
            }
        };
        this.mGattUpdateReceiver = new BleBroadcastReceiver(){

            @Override
            public void onCommandAck(int n) {
                super.onCommandAck(n);
                if (n == 22) {
                    SettingDataPageViewModel.this.getPageDetail();
                } else if (n == 38) {
                    SettingDataPageViewModel.this.getPageDetail();
                }
            }

            @Override
            public void onCommandResponse(int n, JSONObject jSONObject) {
                if (n == 22) {
                    try {
                        SettingDataPageViewModel.this.data.updateGridData(jSONObject);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    SettingDataPageViewModel.this.updateCurrentIndex();
                }
            }

            @Override
            public void onDataPost(int n) {
                super.onDataPost(n);
                if (n == 0) {
                    SettingDataPageViewModel.this.iniDataSyncCompleted.postValue(true);
                }
            }
        };
    }

    private Boolean gotoPage(Integer n) {
        block5: {
            try {
                JSONObject jSONObject = this.gridPageList.getJSONObject(n.intValue());
                n = jSONObject.getInt("row");
                if (n > this.data.getMaxGrid()) {
                    return false;
                }
                if (n < this.data.getMinGrid()) {
                    return false;
                }
                if (this.data.setDevicePageData(this.bleRepository, jSONObject).booleanValue()) {
                    this.data.setIniSectionFieldType();
                    this.updateCurrentIndex();
                    break block5;
                }
                this.loadingPageLiveData.postValue(true);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public Integer getActionSwitfhEnabled() {
        return ((SettingIniGridData)this.data).getActionSwitchEnable();
    }

    public ArrayList<ArrayList<Integer>> getCurrentGridLayout() {
        Object object = this.gridPageList;
        if (object == null) {
            return new ArrayList<ArrayList<Integer>>();
        }
        try {
            JSONObject jSONObject = object.getJSONObject(this.data.getCurrentGridPageIndex().intValue());
            int n = jSONObject.getInt("number");
            ArrayList<ArrayList<Integer>> arrayList = new ArrayList<ArrayList<Integer>>();
            object = 1;
            while ((Integer)object <= Integer.valueOf(n)) {
                JSONArray jSONArray = jSONObject.getJSONArray(String.valueOf(object));
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                arrayList2.add(jSONArray.getInt(0));
                arrayList2.add(jSONArray.getInt(1));
                arrayList.add(arrayList2);
                object = (Integer)object + 1;
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return new ArrayList<ArrayList<Integer>>();
        }
    }

    public MutableLiveData<String> getCurrentPageNameLiveData() {
        return this.currentPageNameLiveData;
    }

    public SettingGridData getData() {
        return this.data;
    }

    public BroadcastReceiver getDeviceDataReceiver() {
        return this.deviceDataReceiver;
    }

    public JSONObject getFieldLang() {
        return this.fieldLang;
    }

    public Rect getFrameRect() {
        return this.data.getFrameRect();
    }

    public Integer getGridItemFieldId(Integer n) {
        return this.data.getGridIdList().get(n);
    }

    public ArrayList<Integer> getGridList() {
        return this.data.getGridIdList();
    }

    public Integer getGridNumber() {
        return this.data.grid;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<GridINISettingData> getINISettingDataList() {
        ArrayList<GridINISettingData> arrayList;
        block7: {
            void var2_6;
            Object object;
            Object object2;
            arrayList = new ArrayList<GridINISettingData>();
            IniFileUtil.Section object32 = ((SettingIniGridData)this.data).getSection("HRZone");
            if (object32 != null) {
                object2 = new ArrayList<String>(){
                    {
                        this.add("MHR_BaseValue");
                        this.add("LTHR_BaseValue");
                    }
                }.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (!object32.hasKey((String)object).booleanValue()) continue;
                    arrayList.add(new GridINISettingData("HRZone", (String)object, object32.get((String)object)));
                }
            }
            if ((object2 = ((SettingIniGridData)this.data).getSection("System")) == null) break block7;
            for (String string2 : new ArrayList<String>(){
                {
                    this.add("SmartPause_Bike");
                    this.add("SecondMode");
                }
            }) {
                if (!((IniFileUtil.Section)object2).hasKey(string2).booleanValue()) continue;
                arrayList.add(new GridINISettingData("System", string2, ((IniFileUtil.Section)object2).get(string2)));
            }
            Integer n = 1;
            while (var2_6.intValue() <= 2) {
                block9: {
                    block8: {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Bike1Trip");
                        ((StringBuilder)object).append(String.valueOf(var2_6));
                        object = ((StringBuilder)object).toString();
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append((String)object);
                        stringBuilder.append("_km");
                        if (((IniFileUtil.Section)object2).hasKey(stringBuilder.toString()).booleanValue()) break block8;
                        stringBuilder = new StringBuilder();
                        stringBuilder.append((String)object);
                        stringBuilder.append("_mi");
                        if (!((IniFileUtil.Section)object2).hasKey(stringBuilder.toString()).booleanValue()) break block9;
                    }
                    arrayList.add(new GridINISettingData("System", (String)object, ((IniFileUtil.Section)object2).get((String)object)));
                }
                Integer n2 = var2_6.intValue() + 1;
            }
        }
        return arrayList;
    }

    public MutableLiveData<Boolean> getIniDataSyncCompleted() {
        return this.iniDataSyncCompleted;
    }

    public Integer getIniSectionCount() {
        return ((SettingIniGridData)this.data).getPageSectionCount();
    }

    public MutableLiveData<Boolean> getLoadingPageLiveData() {
        return this.loadingPageLiveData;
    }

    public String getModelFrameName() {
        return this.data.resourceFrameName();
    }

    public String getModelName() {
        return this.data.modelName;
    }

    public void getPageDetail() {
        if (this.data.getDeviceDetail(this.bleRepository).booleanValue()) {
            this.updateCurrentIndex();
        }
    }

    public Boolean isIniData() {
        return this.data instanceof SettingIniGridData;
    }

    public void lastPage() {
        int n;
        int n2 = this.data.getCurrentGridPageIndex();
        do {
            n = --n2;
            if (n2 < 0) {
                n = this.gridPageList.length();
            }
            n2 = n;
        } while (!this.gotoPage(n).booleanValue());
    }

    public void loadGridTable(Context context, SettingGridData object) {
        this.data = object;
        this.data.modelName = object = this.deviceRepository.getConnectedDeviceName().toLowerCase().replaceAll("_|\\s+", "");
        this.gridPageList = RhinoJsUtil.getGridTable(context, (String)object);
        this.fieldLang = RhinoJsUtil.getFieldLang(context, (String)object);
        this.getPageDetail();
    }

    public void nextPage() {
        int n;
        int n2 = this.data.getCurrentGridPageIndex();
        do {
            n = ++n2;
            if (n2 >= this.gridPageList.length()) {
                n = 0;
            }
            n2 = n;
        } while (!this.gotoPage(n).booleanValue());
    }

    public void registerBLEReceiver(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.brytonsport.active.SERVICE_SETTING_COMMAND_RETURN");
        intentFilter.addAction("com.brytonsport.active.SERVICE_POST_DATA");
        context.registerReceiver((BroadcastReceiver)this.mGattUpdateReceiver, intentFilter);
    }

    public void setActionSwitch(Boolean bl) {
        ((SettingIniGridData)this.data).setActionSwitch(bl);
    }

    public void setGridFielId(Integer n, Integer n2) {
        this.data.setGridFielId(this.bleRepository, n, n2);
    }

    public void setINIDataValue(String string2, String string3, String string4) {
        if (string3.startsWith("Bike1Trip")) {
            ((SettingIniGridData)this.data).setINIData(string2, "Bike1Trip1_mi", string4);
            ((SettingIniGridData)this.data).setINIData(string2, "Bike1Trip1_km", string4);
            ((SettingIniGridData)this.data).setINIData(string2, "Bike1Trip2_mi", string4);
            ((SettingIniGridData)this.data).setINIData(string2, "Bike1Trip2_km", string4);
            ((SettingIniGridData)this.data).setINIData(string2, "Bike2Trip1_mi", string4);
            ((SettingIniGridData)this.data).setINIData(string2, "Bike2Trip1_km", string4);
            ((SettingIniGridData)this.data).setINIData(string2, "Bike2Trip2_mi", string4);
            ((SettingIniGridData)this.data).setINIData(string2, "Bike2Trip2_km", string4);
        } else {
            ((SettingIniGridData)this.data).setINIData(string2, string3, string4);
        }
    }

    public void setSectionPage(Integer n) {
        ((SettingIniGridData)this.data).setPageIdx(n);
        this.updateCurrentIndex();
    }

    public void syncDataToDevice() {
        byte[] byArray = ((SettingIniGridData)this.data).saveIniData();
        this.bleRepository.postData(0, byArray);
    }

    public void unregisterBLEReceiver(Context context) {
        context.unregisterReceiver((BroadcastReceiver)this.mGattUpdateReceiver);
    }

    public void updateCurrentIndex() {
        block7: {
            block6: {
                Object object = this.loadingPageLiveData;
                object.postValue(false);
                object = this.gridPageList;
                if (object == null) break block6;
                if (object.length() == 0) break block6;
                for (int i = 0; i < this.gridPageList.length(); ++i) {
                    object = this.gridPageList.getJSONObject(i);
                    if (!this.data.checkIsEqualPageData((JSONObject)object).booleanValue()) continue;
                    this.data.setCurrentGridPageIndex(i);
                    object = this.data.getPageName(this.gridPageList);
                    this.currentPageNameLiveData.postValue((String)object);
                    break block7;
                }
            }
            try {
                this.currentPageNameLiveData.postValue("");
                return;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }
}

