/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.setting;

import android.content.Context;
import android.util.Log;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.fwupdate.FirmwareUtil;
import com.brytonsport.active.fwupdate.FwPackageInfo;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.vm.base.Device;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SettingFirmwareUpdateViewModel
extends BaseViewModel {
    @Inject
    BleRepository bleRepository;
    public Device device;
    public List<FwPackageInfo> fwPackageInfoList;
    public int isSptFwUpdateByUsb = 0;
    public int nowSendToDeviceIndex;
    public int progress = 0;
    public int uploadCount = 0;
    public int uploadIndex = 0;

    @Inject
    public SettingFirmwareUpdateViewModel() {
    }

    private void setUpdatePackageInfoToDevice(JSONArray jSONArray, int n, int n2) {
        JSONArray jSONArray2 = new JSONArray();
        jSONArray2.put((Object)"set.updatepackage_info");
        jSONArray2.put((Object)jSONArray);
        jSONArray2.put(n);
        jSONArray2.put(n2);
        this.bleRepository.passSettingCommand(jSONArray2);
    }

    public void cancelFwUpdateAction() {
        this.bleRepository.cancelSendFileToDevice();
    }

    public void prepareFwUpdateFileInfo() {
        this.fwPackageInfoList = new ArrayList<FwPackageInfo>();
        this.nowSendToDeviceIndex = 0;
        File[] fileArray = new File(FirmwareUtil.getFirmwareFolderByUuid((Context)App.getInstance(), this.device.uuid)).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Serializable serializable = new StringBuilder();
            ((StringBuilder)serializable).append("FileName:");
            ((StringBuilder)serializable).append(fileArray[i].getName());
            Log.d((String)"Files", (String)((StringBuilder)serializable).toString());
            if (fileArray[i].getName().equals("release.ini") || fileArray[i].getName().equals("AllProjectsImage.rel")) continue;
            serializable = new FwPackageInfo();
            ((FwPackageInfo)serializable).setFileName(fileArray[i].getName());
            ((FwPackageInfo)serializable).setIniName(FirmwareUtil.getIniNameFromFileName(fileArray[i].getName()));
            ((FwPackageInfo)serializable).setSize(fileArray[i].length());
            ((FwPackageInfo)serializable).setContentType(FirmwareUtil.getContentTypeFromFileName(fileArray[i].getName()));
            this.fwPackageInfoList.add((FwPackageInfo)serializable);
        }
        this.uploadCount = this.fwPackageInfoList.size();
        this.uploadIndex = 0;
    }

    public void resetUpdateProgress() {
        this.uploadCount = 0;
        this.uploadIndex = 0;
        this.progress = 0;
    }

    public void sendFileToDevice(int n, FwPackageInfo fwPackageInfo) {
        ++this.uploadIndex;
        this.bleRepository.postFwUpdateData(n, fwPackageInfo);
    }

    public void setDeviceUpdate() {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.device.update");
        jSONArray.put(0);
        this.bleRepository.passSettingCommand(jSONArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUpdatePackageInfo() {
        int n;
        JSONArray jSONArray = this.fwPackageInfoList;
        if (jSONArray == null) return;
        if (jSONArray.size() <= 0) return;
        int n2 = this.fwPackageInfoList.size();
        int n3 = 0;
        int n4 = 3;
        if (n2 > 3) {
            JSONObject jSONObject;
            jSONArray = new JSONArray();
            for (n = 0; n < 3; ++n) {
                jSONObject = new JSONObject();
                jSONObject.put("iniName", (Object)this.fwPackageInfoList.get(n).getIniName());
                jSONObject.put("size", this.fwPackageInfoList.get(n).getSize());
                jSONArray.put((Object)jSONObject);
            }
            this.setUpdatePackageInfoToDevice(jSONArray, 2, 1);
            jSONObject = new JSONArray();
            for (n = n4; n < this.fwPackageInfoList.size(); ++n) {
                jSONArray = new JSONObject();
                jSONArray.put("iniName", (Object)this.fwPackageInfoList.get(n).getIniName());
                jSONArray.put("size", this.fwPackageInfoList.get(n).getSize());
                jSONObject.put((Object)jSONArray);
            }
            this.setUpdatePackageInfoToDevice((JSONArray)jSONObject, 2, 2);
            return;
        }
        jSONArray = new JSONArray();
        for (n = n3; n < this.fwPackageInfoList.size(); ++n) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("iniName", (Object)this.fwPackageInfoList.get(n).getIniName());
            jSONObject.put("size", this.fwPackageInfoList.get(n).getSize());
            jSONArray.put((Object)jSONObject);
        }
        try {
            this.setUpdatePackageInfoToDevice(jSONArray, 1, 1);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }
}

